#!/bin/bash
sleep 5
POD_NAME=$(hostname)
NAMESPACE=$(cat /var/run/secrets/kubernetes.io/serviceaccount/namespace)
TOKEN=$(cat /var/run/secrets/kubernetes.io/serviceaccount/token)
K8S_API_SERVER="https://kubernetes.default.svc"

# Make API request to get pod IP
POD_IP=$(curl -sSk \
  -H "Authorization: Bearer $TOKEN" \
  "$K8S_API_SERVER/api/v1/namespaces/$NAMESPACE/pods/$POD_NAME" | jq -r '.status.podIP')

echo "Pod Name: $POD_NAME"
echo "Pod IP: $POD_IP"
echo "NAMESPACE: $NAMESPACE"


JVM_OPTIONS_FILE="/config/jvm.options"
NEW_OPTION="-Djava.rmi.server.hostname=$POD_IP"
SERVER_NAME="defaultServer"

# Add the new option to the JVM options file
sed -i "1s/^/$NEW_OPTION\n/" "$JVM_OPTIONS_FILE"

echo "JVM option is modified"
echo "update sh is done"

