//
//  KonyPKAddPassesViewController.h
//  KLPassBook
//
//  Created by Amba on 06/01/14.
//  Copyright (c) 2014 Konylabs. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <PassKit/PassKit.h>

@class KonyPKPass;
@class CallBack;

/*!
 The KonyPKAddPassesViewController class lets your app show a pass and prompt the user to add that pass to the pass library.
 To add multiple passes without presenting this view controller multiple times, use the addPasses:withCompletionCallback: method of KonyPKPassLibrary.
 @note KonyPKPassLibrary is a wrapper class around PKPassLibrary.
 */
@interface KonyPKAddPassesViewController : NSObject <PKAddPassesViewControllerDelegate>

/*!
 @abstract Initializes and returns a newly created add-passes view controller with a single pass.
 
 @param pass The pass that is displayed.
 @param  statusCallback The callback to get status
 
 @return The initialized add-passes view controller object or nil if there was a problem initializing the object.
 
 @note User has to dismiss the this viewController upon recieving the KonyPKAddPassesViewControllerFinished status in statusCallback
 by calling -dismissAnimated API.
 */
- (KonyPKAddPassesViewController *)initWithPass:(KonyPKPass *)pass andCallback:(CallBack *)statusCallback;

/*!
 @abstract Initializes and returns a newly created add-passes view controller with an array of passes.
 
 @param passes The passes that are displayed.
 @param statusCallback The callback to get status
 
 @return The initialized add-passes view controller object or nil if there was a problem initializing the object.
 
 @note User has to dismiss the this viewController upon recieving the KonyPKAddPassesViewControllerFinished status in statusCallback
 by calling -dismissAnimated API.
 */
- (KonyPKAddPassesViewController *)initWithPasses:(NSArray *)passes andCallback:(CallBack *)statusCallback;

/*!
 @abstract Presents the add passes view controller.
 
 @param animated Pass YES to animate the presentation; otherwise, pass NO.
 
 @note User has to dismiss the this viewController upon recieving the KonyPKAddPassesViewControllerFinished status in statusCallback
 by calling -dismissAnimated API.
 
 @todo modalPresentationStyle modalTransitionStyle (For iPad)
 */
- (void)presentAnimated:(BOOL)animated;

/*!
 @abstract Dismisses the add passes view controller that was presented.
 
 @param animated Pass YES to animate the transition; otherwise, pass NO.
 
 @return The initialized add-passes view controller object or nil if there was a problem initializing the object.
 
 @note User has to dismiss the this viewController upon recieving the KonyPKAddPassesViewControllerFinished status in statusCallback
 by calling -dismissAnimated API.
 
 @discussion The statusCallback is called after the viewDidDisappear: method is called on add passes view controller.
 */
- (void)dismissAnimated:(BOOL)animated;

@end

/*! @note addPassesCallback statuses */
/*! @typedef KonyPKAddPassesViewControllerFinished status used when view controller finished with adding passes */
extern NSString *const KonyPKAddPassesViewControllerFinished;

/*! @typedef KonyPKAddPassesViewControllerShown status used when view controller is shown */
extern NSString *const KonyPKAddPassesViewControllerShown;

/*! @typedef KonyPKAddPassesViewControllerDismissed status used when view controller is dismissed */
extern NSString *const KonyPKAddPassesViewControllerDismissed;
