<?xml version="1.0"?>

<xsl:transform
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <xsl:template match="/filelist">
    <xsl:for-each select="document(file)">
      <xsl:apply-templates select="Page" />
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="/Page">
    <html>
      <head>
        <title>Tour editable text</title>
      </head>
      <body>
        <p>
          <xsl:apply-templates />
        </p>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="PageTitle">
    <b>Page title:</b><xsl:value-of select="."/>
  </xsl:template>

  <xsl:template match="ccText">
    <br></br><br></br><b>Closed Captioning text:</b> <xsl:value-of select="."/>
  </xsl:template>

  <xsl:template match="PageText">
    <br></br><br></br><b>Page text:</b>
    <xsl:apply-templates />
    <hr></hr>
  </xsl:template>

  <xsl:template match="ul">
    <ul>
      <xsl:for-each select="li">
        <li><xsl:value-of select="." /></li>
      </xsl:for-each>
    </ul>
  </xsl:template>


</xsl:transform>

