/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.launcher.BlockAdapter;
import org.eclipse.pde.internal.ui.launcher.FeatureBlock;
import org.eclipse.pde.internal.ui.launcher.PluginBlock;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.PlatformUI;

public class PluginsTab
extends AbstractLauncherTab {
    private Image fImage = PDEPluginImages.DESC_PLUGINS_FRAGMENTS.createImage();
    private Combo fSelectionCombo;
    private BlockAdapter fBlock = new BlockAdapter(new PluginBlock(this), new FeatureBlock(this));
    private Combo fDefaultAutoStart;
    private Spinner fDefaultStartLevel;
    private Listener fListener = new Listener();
    private static final int DEFAULT_SELECTION = 0;
    private static final int PLUGIN_SELECTION = 1;
    private static final int FEATURE_SELECTION = 2;

    public PluginsTab() {
    }

    public PluginsTab(boolean showFeatures) {
        this();
    }

    public void dispose() {
        this.fBlock.dispose();
        this.fImage.dispose();
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite composite = SWTFactory.createComposite(parent, 1, 1, 768);
        Composite buttonComp = SWTFactory.createComposite(composite, 6, 1, 768, 0, 0);
        SWTFactory.createLabel(buttonComp, PDEUIMessages.PluginsTab_launchWith, 1);
        this.fSelectionCombo = SWTFactory.createCombo(buttonComp, 2056, 1, 32, new String[]{PDEUIMessages.PluginsTab_allPlugins, PDEUIMessages.PluginsTab_selectedPlugins, PDEUIMessages.PluginsTab_customFeatureMode});
        this.fSelectionCombo.select(0);
        this.fSelectionCombo.addSelectionListener((SelectionListener)this.fListener);
        Label label = SWTFactory.createLabel(buttonComp, PDEUIMessages.EquinoxPluginsTab_defaultStart, 1);
        GridData gd = new GridData();
        gd.horizontalIndent = 20;
        label.setLayoutData((Object)gd);
        this.fDefaultStartLevel = new Spinner(buttonComp, 2048);
        this.fDefaultStartLevel.setMinimum(1);
        this.fDefaultStartLevel.addModifyListener((ModifyListener)this.fListener);
        label = SWTFactory.createLabel(buttonComp, PDEUIMessages.EquinoxPluginsTab_defaultAuto, 1);
        gd = new GridData();
        gd.horizontalIndent = 20;
        label.setLayoutData((Object)gd);
        this.fDefaultAutoStart = SWTFactory.createCombo(buttonComp, 2056, 1, 32, new String[]{Boolean.toString(true), Boolean.toString(false)});
        this.fDefaultAutoStart.select(0);
        this.fDefaultAutoStart.addSelectionListener((SelectionListener)this.fListener);
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(768));
        this.fBlock.createControl(composite, 7, 10);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.pde.doc.user.launcher_advanced");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            int index = 0;
            if (configuration.getAttribute("usefeatures", false)) {
                index = 2;
            } else if (configuration.getAttribute("useCustomFeatures", false)) {
                index = 2;
            } else if (!configuration.getAttribute("default", true)) {
                index = 1;
            }
            this.fSelectionCombo.select(index);
            this.fBlock.setActiveBlock(index);
            boolean custom = this.fSelectionCombo.getSelectionIndex() == 1;
            this.fBlock.initializeFrom(configuration, custom);
            boolean auto = configuration.getAttribute("default_auto_start", false);
            this.fDefaultAutoStart.setText(Boolean.toString(auto));
            int level = configuration.getAttribute("default_start_level", 4);
            this.fDefaultStartLevel.setSelection(level);
        }
        catch (CoreException e) {
            PDEPlugin.log(e);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("default", true);
        configuration.removeAttribute("usefeatures");
        configuration.setAttribute("useCustomFeatures", false);
        this.fBlock.setDefaults(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        int index = this.fSelectionCombo.getSelectionIndex();
        configuration.setAttribute("default", index == 0);
        configuration.setAttribute("useCustomFeatures", index == 2);
        this.fBlock.performApply(configuration);
        String autoText = this.fDefaultAutoStart.getText();
        if (Boolean.toString(false).equals(autoText)) {
            configuration.setAttribute("default_auto_start", null);
        } else {
            configuration.setAttribute("default_auto_start", true);
        }
        int startLevel = this.fDefaultStartLevel.getSelection();
        if (4 == startLevel) {
            configuration.setAttribute("default_start_level", null);
        } else {
            configuration.setAttribute("default_start_level", startLevel);
        }
    }

    public String getName() {
        return PDEUIMessages.AdvancedLauncherTab_name;
    }

    public Image getImage() {
        return this.fImage;
    }

    @Override
    public void validateTab() {
        String errorMessage = null;
        this.setErrorMessage(errorMessage);
    }

    public String getId() {
        return "org.eclipse.pde.ui.launch.tab.plugins";
    }

    class Listener
    extends SelectionAdapter
    implements ModifyListener {
        Listener() {
        }

        public void widgetSelected(SelectionEvent e) {
            int index = PluginsTab.this.fSelectionCombo.getSelectionIndex();
            try {
                PluginsTab.this.fBlock.setActiveBlock(index);
                PluginsTab.this.fBlock.initialize(index == 1);
            }
            catch (CoreException ex) {
                PDEPlugin.log(ex);
            }
            PluginsTab.this.updateLaunchConfigurationDialog();
        }

        public void modifyText(ModifyEvent e) {
            PluginsTab.this.updateLaunchConfigurationDialog();
        }
    }
}

