/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.imagebrowser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.views.imagebrowser.ActiveImageSourceProvider;
import org.eclipse.pde.internal.ui.views.imagebrowser.IImageTarget;
import org.eclipse.pde.internal.ui.views.imagebrowser.ImageElement;
import org.eclipse.pde.internal.ui.views.imagebrowser.filter.AndFilter;
import org.eclipse.pde.internal.ui.views.imagebrowser.filter.IFilter;
import org.eclipse.pde.internal.ui.views.imagebrowser.filter.NotFilter;
import org.eclipse.pde.internal.ui.views.imagebrowser.filter.OrFilter;
import org.eclipse.pde.internal.ui.views.imagebrowser.filter.PatternFilter;
import org.eclipse.pde.internal.ui.views.imagebrowser.filter.SizeFilter;
import org.eclipse.pde.internal.ui.views.imagebrowser.repositories.AbstractRepository;
import org.eclipse.pde.internal.ui.views.imagebrowser.repositories.TargetPlatformRepository;
import org.eclipse.pde.internal.ui.views.imagebrowser.repositories.WorkspaceRepository;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.ISourceProviderService;

public class ImageBrowserView
extends ViewPart
implements IImageTarget {
    private final UpdateUI mUIJob = new UpdateUI();
    private final List<IFilter> mFilters = new ArrayList<IFilter>();
    private final IFilter disabledIcons;
    private final IFilter enabledIcons;
    private final IFilter wizard;
    private ScrolledComposite scrolledComposite;
    private Composite imageComposite;
    private ComboViewer sourceCombo;
    int mImageCounter = 0;
    private Label lblPlugin;
    private Label lblPath;
    private Label lblWidth;
    private Label lblHeight;
    private Text txtReference;
    private Button nextButton;
    private Spinner spinMaxImages;
    private List<Image> displayedImages = new ArrayList<Image>();
    private AbstractRepository repository;

    public ImageBrowserView() {
        SizeFilter iconSize = new SizeFilter(16, 0, 16, 0);
        PatternFilter disabled1 = new PatternFilter(".*/obj16/\\w+dis(_obj)?\\W.+");
        PatternFilter disabled2 = new PatternFilter(".*/d(?!ialogs)(?!ecorations)(?!nd)(?!evguide)\\w+/.+");
        OrFilter disabled = new OrFilter(new IFilter[]{disabled1, disabled2});
        this.disabledIcons = new AndFilter(new IFilter[]{iconSize, disabled});
        NotFilter enabled = new NotFilter(disabled);
        this.enabledIcons = new AndFilter(new IFilter[]{iconSize, enabled});
        SizeFilter wizardSize = new SizeFilter(75, 0, 66, 0);
        PatternFilter wizard1 = new PatternFilter(".*/wizban/.+");
        PatternFilter wizard2 = new PatternFilter(".+_wiz\\.\\w+");
        OrFilter wizardName = new OrFilter(new IFilter[]{wizard1, wizard2});
        this.wizard = new AndFilter(new IFilter[]{wizardSize, wizardName});
        this.mFilters.add(this.enabledIcons);
    }

    public void createPartControl(Composite parent) {
        Composite composite = SWTFactory.createComposite(parent, 1, 1, 1808, 0, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.pde.doc.user.image_browser_view");
        Composite topComp = new Composite(composite, 0);
        RowLayout layout = new RowLayout();
        topComp.setLayout((Layout)layout);
        topComp.setFont(parent.getFont());
        topComp.setBackground(composite.getBackground());
        GridData gd = new GridData(768);
        topComp.setLayoutData((Object)gd);
        Composite sourceComp = SWTFactory.createComposite(topComp, 7, 1, 0, 0, 0);
        sourceComp.setLayoutData((Object)new RowData());
        SWTFactory.createLabel(sourceComp, PDEUIMessages.ImageBrowserView_Source, 1);
        this.sourceCombo = new ComboViewer(SWTFactory.createCombo(sourceComp, 8, 1, null));
        this.sourceCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.sourceCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ImageBrowserView.this.scanImages();
            }
        });
        ArrayList<AbstractRepository> sourceComboInput = new ArrayList<AbstractRepository>();
        sourceComboInput.add(new TargetPlatformRepository(this, true));
        sourceComboInput.add(new TargetPlatformRepository(this, false));
        sourceComboInput.add(new WorkspaceRepository(this));
        this.sourceCombo.setInput(sourceComboInput);
        SWTFactory.createHorizontalSpacer(sourceComp, 3);
        SWTFactory.createLabel(sourceComp, PDEUIMessages.ImageBrowserView_Show, 1);
        Combo typeCombo = SWTFactory.createCombo(sourceComp, 8, 1, new String[]{PDEUIMessages.ImageBrowserView_FilterIcons, PDEUIMessages.ImageBrowserView_FilterDisabled, PDEUIMessages.ImageBrowserView_FilterWizards, PDEUIMessages.ImageBrowserView_FilterAllImages});
        typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageBrowserView.this.mFilters.clear();
                Combo source = (Combo)e.getSource();
                switch (source.getSelectionIndex()) {
                    case 0: {
                        ImageBrowserView.this.mFilters.add(ImageBrowserView.this.enabledIcons);
                        break;
                    }
                    case 1: {
                        ImageBrowserView.this.mFilters.add(ImageBrowserView.this.disabledIcons);
                        break;
                    }
                    case 2: {
                        ImageBrowserView.this.mFilters.add(ImageBrowserView.this.wizard);
                    }
                }
                ImageBrowserView.this.scanImages();
            }
        });
        Composite pageComp = SWTFactory.createComposite(topComp, 6, 1, 0, 0, 0);
        ((GridLayout)pageComp.getLayout()).marginLeft = 20;
        pageComp.setLayoutData((Object)new RowData());
        SWTFactory.createLabel(pageComp, PDEUIMessages.ImageBrowserView_MaxImages, 1);
        this.spinMaxImages = new Spinner(pageComp, 2048);
        this.spinMaxImages.setMaximum(999);
        this.spinMaxImages.setMinimum(1);
        this.spinMaxImages.setSelection(250);
        SWTFactory.createHorizontalSpacer(pageComp, 3);
        this.nextButton = SWTFactory.createPushButton(pageComp, PDEUIMessages.ImageBrowserView_ShowMore, null);
        this.nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageBrowserView.this.scanImages();
            }
        });
        this.nextButton.setEnabled(false);
        this.scrolledComposite = new ScrolledComposite(composite, 2560);
        this.scrolledComposite.setBackground(this.scrolledComposite.getParent().getBackground());
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = ImageBrowserView.this.scrolledComposite.getClientArea();
                ImageBrowserView.this.scrolledComposite.setMinSize(ImageBrowserView.this.imageComposite.computeSize(r.width, -1));
            }
        });
        this.imageComposite = SWTFactory.createComposite((Composite)this.scrolledComposite, 1, 1, 1808, 0, 0);
        ((GridLayout)this.imageComposite.getLayout()).verticalSpacing = 0;
        this.imageComposite.setBackground(this.imageComposite.getParent().getBackground());
        this.scrolledComposite.setContent((Control)this.imageComposite);
        this.scrolledComposite.setMinSize(this.imageComposite.computeSize(-1, -1));
        Composite infoGroup = SWTFactory.createComposite(composite, 4, 1, 768, 0, 0);
        ((GridLayout)infoGroup.getLayout()).verticalSpacing = 0;
        SWTFactory.createLabel(infoGroup, PDEUIMessages.ImageBrowserView_Path, 1);
        this.lblPath = new Label(infoGroup, 0);
        this.lblPath.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        SWTFactory.createLabel(infoGroup, PDEUIMessages.ImageBrowserView_Width, 1);
        this.lblWidth = new Label(infoGroup, 0);
        GridData gd_lblWidth = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblWidth.widthHint = 50;
        this.lblWidth.setLayoutData((Object)gd_lblWidth);
        SWTFactory.createLabel(infoGroup, PDEUIMessages.ImageBrowserView_Plugin, 1);
        this.lblPlugin = new Label(infoGroup, 0);
        this.lblPlugin.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        SWTFactory.createLabel(infoGroup, PDEUIMessages.ImageBrowserView_Height, 1);
        this.lblHeight = new Label(infoGroup, 0);
        GridData gd_lblHeight = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblHeight.widthHint = 50;
        this.lblHeight.setLayoutData((Object)gd_lblHeight);
        SWTFactory.createLabel(infoGroup, PDEUIMessages.ImageBrowserView_Reference, 1);
        this.txtReference = new Text(infoGroup, 2056);
        this.txtReference.setBackground(this.txtReference.getParent().getBackground());
        this.txtReference.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
    }

    public void setFocus() {
        if (this.sourceCombo.getSelection().isEmpty()) {
            this.sourceCombo.getCombo().setFocus();
        }
    }

    @Override
    public void notifyImage(ImageElement element) {
        for (IFilter filter : this.mFilters) {
            if (filter.accept(element)) continue;
            return;
        }
        this.mUIJob.addImage(element);
        --this.mImageCounter;
        if (this.mImageCounter <= 0) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ImageBrowserView.this.nextButton.setEnabled(true);
                }
            });
        }
    }

    @Override
    public boolean needsMore() {
        return this.mImageCounter > 0;
    }

    private void scanImages() {
        if (this.repository != null) {
            this.repository.cancel();
        }
        this.nextButton.setEnabled(false);
        this.mUIJob.reset();
        this.lblPath.setText("");
        this.lblPlugin.setText("");
        this.lblWidth.setText("");
        this.lblHeight.setText("");
        this.txtReference.setText("");
        Control[] controlArray = this.imageComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        this.disposeImages();
        if (!this.sourceCombo.getSelection().isEmpty()) {
            this.mImageCounter = this.spinMaxImages.getSelection();
            this.repository = (AbstractRepository)((Object)((IStructuredSelection)this.sourceCombo.getSelection()).getFirstElement());
            this.repository.schedule();
        }
    }

    public void dispose() {
        this.disposeImages();
    }

    private void disposeImages() {
        for (Image image : this.displayedImages) {
            image.dispose();
        }
        this.displayedImages.clear();
    }

    private class UpdateUI
    extends FocusAdapter
    implements Runnable {
        Collection<ImageElement> mElements = new LinkedList<ImageElement>();
        String mLastPlugin = "";
        private Composite mPluginImageContainer = null;
        private final RowLayout mRowLayout = new RowLayout(256);

        public UpdateUI() {
            this.mRowLayout.wrap = true;
            this.mRowLayout.marginWidth = 0;
            this.mRowLayout.marginHeight = 0;
        }

        public synchronized void addImage(ImageElement element) {
            this.mElements.add(element);
            if (this.mElements.size() == 1) {
                Display.getDefault().asyncExec((Runnable)this);
            }
        }

        @Override
        public synchronized void run() {
            if (!this.mElements.isEmpty()) {
                for (ImageElement element : this.mElements) {
                    if (!this.mLastPlugin.equals(element.getPlugin())) {
                        this.mLastPlugin = element.getPlugin();
                        Label label = new Label(ImageBrowserView.this.imageComposite, 0);
                        label.setText(this.mLastPlugin);
                        label.setBackground(label.getParent().getBackground());
                        if (this.mPluginImageContainer != null) {
                            this.mPluginImageContainer.layout();
                        }
                        this.mPluginImageContainer = new Composite(ImageBrowserView.this.imageComposite, 0);
                        this.mPluginImageContainer.setLayout((Layout)this.mRowLayout);
                        this.mPluginImageContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
                        this.mPluginImageContainer.setBackground(this.mPluginImageContainer.getParent().getBackground());
                    }
                    Button button = new Button(this.mPluginImageContainer, 0x800000);
                    Image image = new Image((Device)ImageBrowserView.this.getViewSite().getShell().getDisplay(), element.getImageData());
                    ImageBrowserView.this.displayedImages.add(image);
                    button.setImage(image);
                    button.setToolTipText(element.getPath());
                    button.setData((Object)element);
                    button.addFocusListener((FocusListener)this);
                }
                this.mElements.clear();
                this.mPluginImageContainer.layout();
                ImageBrowserView.this.imageComposite.layout();
                Rectangle r = ImageBrowserView.this.scrolledComposite.getClientArea();
                ImageBrowserView.this.scrolledComposite.setMinSize(ImageBrowserView.this.imageComposite.computeSize(r.width, -1));
            }
        }

        public void focusGained(FocusEvent e) {
            Control child = (Control)e.widget;
            Rectangle bounds = child.getBounds();
            Rectangle pluginBounds = child.getParent().getBounds();
            bounds.x += pluginBounds.x;
            bounds.y += pluginBounds.y;
            Rectangle area = ImageBrowserView.this.scrolledComposite.getClientArea();
            Point origin = ImageBrowserView.this.scrolledComposite.getOrigin();
            if (origin.x > bounds.x) {
                origin.x = Math.max(0, bounds.x);
            }
            if (origin.y > bounds.y) {
                origin.y = Math.max(0, bounds.y);
            }
            if (origin.x + area.width < bounds.x + bounds.width) {
                origin.x = Math.max(0, bounds.x + bounds.width - area.width);
            }
            if (origin.y + area.height < bounds.y + bounds.height) {
                origin.y = Math.max(0, bounds.y + bounds.height - area.height);
            }
            ImageBrowserView.this.scrolledComposite.setOrigin(origin);
            Object data = e.widget.getData();
            if (data instanceof ImageElement) {
                ImageBrowserView.this.lblPath.setText(((ImageElement)data).getPath());
                ImageBrowserView.this.lblPlugin.setText(((ImageElement)data).getFullPlugin());
                ImageBrowserView.this.txtReference.setText("platform:/plugin/" + ((ImageElement)data).getPlugin() + "/" + ((ImageElement)data).getPath());
                ImageBrowserView.this.lblWidth.setText(NLS.bind((String)PDEUIMessages.ImageBrowserView_Pixels, (Object)Integer.toString(((ImageElement)data).getImageData().width)));
                ImageBrowserView.this.lblHeight.setText(NLS.bind((String)PDEUIMessages.ImageBrowserView_Pixels, (Object)Integer.toString(((ImageElement)data).getImageData().height)));
                ISourceProviderService service = (ISourceProviderService)PlatformUI.getWorkbench().getService(ISourceProviderService.class);
                ISourceProvider provider = service.getSourceProvider("org.eclipse.pde.ui.imagebrowser.activeImage");
                if (provider instanceof ActiveImageSourceProvider) {
                    ((ActiveImageSourceProvider)provider).setImageData((ImageElement)data);
                }
            }
        }

        public synchronized void reset() {
            this.mLastPlugin = "";
            this.mElements.clear();
            this.mPluginImageContainer = null;
        }
    }
}

