/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.net.URI;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.TextURLDropAdapter;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RepositoryNameAndLocationDialog
extends StatusDialog {
    Button okButton;
    Text url;
    Text nickname;
    ProvisioningUI ui;
    URI location;
    String name;
    String initialURL;

    public RepositoryNameAndLocationDialog(Shell parentShell, ProvisioningUI ui) {
        super(parentShell);
        this.ui = ui;
        this.setTitle(ProvUIMessages.RepositoryNameAndLocationDialog_Title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.initializeDialogUnits((Control)comp);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginTop = this.convertVerticalDLUsToPixels(4);
        this.nickname = this.createNameField(comp);
        this.url = this.createLocationField(comp);
        comp.setLayout((Layout)layout);
        GridData data = new GridData();
        comp.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)comp);
        return comp;
    }

    protected RepositoryTracker getRepositoryTracker() {
        return this.ui.getRepositoryTracker();
    }

    protected void okPressed() {
        if (this.handleOk()) {
            super.okPressed();
        }
    }

    protected boolean handleOk() {
        IStatus status = this.validateRepositoryURL(false);
        this.location = this.getUserLocation();
        this.name = this.nickname.getText().trim();
        return status.isOK();
    }

    protected URI getUserLocation() {
        return this.getRepositoryTracker().locationFromString(this.url.getText().trim());
    }

    public URI getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    protected IStatus validateRepositoryURL(final boolean contactRepositories) {
        if (this.url == null || this.url.isDisposed()) {
            return Status.OK_STATUS;
        }
        final IStatus[] status = new IStatus[]{this.getRepositoryTracker().getInvalidLocationStatus(this.url.getText().trim())};
        final URI userLocation = this.getUserLocation();
        if (this.url.getText().length() == 0) {
            status[0] = new Status(4, "org.eclipse.equinox.p2.ui", 10100, ProvUIMessages.RepositoryGroup_URLRequired, null);
        } else if (userLocation == null) {
            status[0] = new Status(4, "org.eclipse.equinox.p2.ui", 10100, ProvUIMessages.AddRepositoryDialog_InvalidURL, null);
        } else if (this.initialURL.equals(this.url.getText().trim())) {
            status[0] = Status.OK_STATUS;
        } else if (userLocation.equals(this.getOriginalLocation())) {
            status[0] = Status.OK_STATUS;
        } else {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    status[0] = RepositoryNameAndLocationDialog.this.getRepositoryTracker().validateRepositoryLocation(RepositoryNameAndLocationDialog.this.ui.getSession(), userLocation, contactRepositories, null);
                }
            });
        }
        if (status[0].getSeverity() == 8) {
            this.cancelPressed();
        }
        this.setOkEnablement(status[0].isOK());
        this.updateStatus(status[0]);
        return status[0];
    }

    protected void updateButtonsEnableState(IStatus status) {
        this.setOkEnablement(!status.matches(4));
    }

    protected void setOkEnablement(boolean enable) {
        if (this.okButton != null && !this.okButton.isDisposed()) {
            this.okButton.setEnabled(enable);
        }
    }

    protected String getInitialLocationText() {
        return "http://";
    }

    protected String getInitialNameText() {
        return "";
    }

    protected URI getOriginalLocation() {
        return null;
    }

    protected Text createNameField(Composite parent) {
        Label nameLabel = new Label(parent, 0);
        nameLabel.setText(ProvUIMessages.AddRepositoryDialog_NameLabel);
        this.nickname = new Text(parent, 2048);
        this.nickname.setText(this.getInitialNameText());
        GridData data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.nickname.setLayoutData((Object)data);
        return this.nickname;
    }

    protected Text createLocationField(Composite parent) {
        Label urlLabel = new Label(parent, 0);
        urlLabel.setText(ProvUIMessages.AddRepositoryDialog_LocationLabel);
        this.url = new Text(parent, 2048);
        GridData data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.url.setLayoutData((Object)data);
        DropTarget target = new DropTarget((Control)this.url, 7);
        target.setTransfer(new Transfer[]{URLTransfer.getInstance(), FileTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new TextURLDropAdapter(this.url, true));
        this.url.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositoryNameAndLocationDialog.this.validateRepositoryURL(false);
            }
        });
        this.initialURL = this.getInitialLocationText();
        this.url.setText(this.initialURL);
        this.url.setSelection(0, this.url.getText().length());
        return this.url;
    }

    protected ProvisioningUI getProvisioningUI() {
        return this.ui;
    }
}

