package com.hcl.software.data.ingest.product.processors;

/*
 * Licensed Materials - Property of HCL Technologies Limited. (c) Copyright HCL Technologies Limited 1996, 2022.
 */

import static com.hcl.software.data.ingest.processors.CacheConstants.CACHE_DEPENDENCY_PROFILE;
import static com.hcl.software.data.ingest.processors.CacheConstants.CACHE_NAME_PROFILE;
import static com.hcl.software.data.ingest.processors.ProcessorConstants.CONNECTOR_DOT_NAME;
import static com.hcl.software.data.ingest.processors.ProcessorConstants.DEFAULT_DOT_CATALOG;
import static com.hcl.software.data.ingest.processors.ProcessorConstants.ENVIRONMENT_DOT_NAME;
import static com.hcl.software.data.ingest.processors.ProcessorConstants.INGEST_DOT_PROFILE_DOT_NAME;
import static com.hcl.software.data.ingest.processors.ProcessorConstants.PARAM_DOT_STOREID;
import static com.hcl.software.data.ingest.processors.ProcessorConstants.TIME_DOT_ID;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

import org.apache.nifi.processor.Relationship;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.Before;
import org.junit.Test;

import com.hcl.commerce.cache.Cache;
import com.hcl.software.data.ingest.util.CacheEntryHelper;

import groovy.json.JsonSlurper;

public class CreateProductDocumentFromDatabaseTest {

    private TestRunner testRunner;

    @Before
    public void init() throws Exception {
    	final Path JSON_SNIPPET = Paths.get("src/test/resources/product/CreateProductDocumentFromDatabase/profile_cache.json");
    	final Map<String, Object> ingestProfile = (Map<String, Object>) new JsonSlurper().parse(JSON_SNIPPET.toFile());
        final Cache profileCache = CacheEntryHelper.getCache("auth", CACHE_NAME_PROFILE);
		CacheEntryHelper.set(profileCache, "MyProductStage1a", ingestProfile, CACHE_DEPENDENCY_PROFILE);
        testRunner = TestRunners.newTestRunner(CreateProductDocumentFromDatabase.class);
    }
       
    @Test
    public void testCreateProductWithIngestProfile() throws Exception {
    	final Path JSON_SNIPPET = Paths.get("src/test/resources/product/CreateProductDocumentFromDatabase/product.json");	
    	
    	Map<String, String> attributes = new HashMap<String, String>();
        attributes.put(PARAM_DOT_STOREID, "1");
        attributes.put(CONNECTOR_DOT_NAME, "auth.reindex");
        attributes.put(ENVIRONMENT_DOT_NAME, "auth");
        attributes.put(TIME_DOT_ID, "202006160325");
        attributes.put(DEFAULT_DOT_CATALOG, "10502");
        attributes.put(INGEST_DOT_PROFILE_DOT_NAME, "MyProductStage1a");
        testRunner.setValidateExpressionUsage(false);
    	testRunner.enqueue(JSON_SNIPPET, attributes);
        testRunner.run();
        
        Relationship expectedRel = CreateProductDocumentFromDatabase.RELATIONSHIP_SUCCESS; 
        testRunner.assertTransferCount(expectedRel, 1);
        expectedRel = CreateProductDocumentFromDatabase.RELATIONSHIP_FAILURE;
        testRunner.assertTransferCount(expectedRel, 0);
    }   
}
