package com.hcl.software.data.ingest.common.processors;

import static com.hcl.software.data.ingest.processors.ProcessorConstants.CONNECTOR_DOT_NAME;
import static com.hcl.software.data.ingest.processors.ProcessorConstants.ENVIRONMENT_DOT_NAME;
import static com.hcl.software.data.ingest.processors.ProcessorConstants.PARAM_DOT_CATALOGID;
import static com.hcl.software.data.ingest.processors.ProcessorConstants.PARAM_DOT_LANGID;
import static com.hcl.software.data.ingest.processors.ProcessorConstants.PARAM_DOT_STOREID;
import static com.hcl.software.data.ingest.processors.ProcessorConstants.TIME_DOT_ID;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

import org.apache.nifi.processor.Relationship;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockserver.client.server.MockServerClient;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.matchers.Times;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.springframework.util.SocketUtils;

import com.hcl.software.data.ingest.controller.service.ProfileControllerService;
import com.hcl.software.data.ingest.controller.service.ProfileService;

@SuppressWarnings("deprecation")
public class ComposeDatabaseSQLTest {

	private ClientAndServer mockServer;
    private TestRunner testRunner;
    private Integer port = SocketUtils.findAvailableTcpPort();
    
    private static final Path JSON_PROFILE = Paths.get("src/test/resources/common/ComposeDatabaseSQL/profile_response.json");

    @Before
    public void init() throws IOException {
    	mockServer = ClientAndServer.startClientAndServer(port);
    	MockServerClient mockClient = new MockServerClient("localhost", port);
    	mockClient.when(new HttpRequest().withMethod("GET").withPath("/search/resources/api/v2/documents/profiles")
									     .withQueryStringParameter("profileType", "Ingest"), Times.exactly(1))
    		      .respond(new HttpResponse().withStatusCode(200).withBody(new String(Files.readAllBytes(JSON_PROFILE))));
        testRunner = TestRunners.newTestRunner(ComposeDatabaseSQL.class);
    }
    
    @After
    public void teardown() {
    	mockServer.stop();
    }

    @Test
    public void testProvider() throws Exception {
    	final Path JSON_SNIPPET = Paths.get("src/test/resources/product/CreateProductDocumentFromDatabase/product.json");
    	
    	ProfileService profileService = new ProfileControllerService(port);
    	testRunner.setProperty(ComposeDatabaseSQL.PROFILE_SERVICE, "Profile Service");
    	testRunner.addControllerService("Profile Service", profileService);
    	testRunner.setValidateExpressionUsage(false);
    	testRunner.setProperty(profileService, ProfileControllerService.RETRY_LIMIT, "500");
    	testRunner.enableControllerService(profileService);

    	Map<String, String> attributes = new HashMap<String, String>();
        attributes.put(PARAM_DOT_STOREID, "1");
        attributes.put(PARAM_DOT_LANGID, "-1");
        attributes.put(PARAM_DOT_CATALOGID, "10001");
        attributes.put(CONNECTOR_DOT_NAME, "auth.reindex");
        attributes.put(ENVIRONMENT_DOT_NAME, "auth");
        attributes.put(TIME_DOT_ID, "202006160325");
        testRunner.setProperty(ComposeDatabaseSQL.INGEST_PROFILE, "MyProductStage1a");
        testRunner.setProperty(ComposeDatabaseSQL.INGEST_SQL, 
        		  "WITH 	\r\n"
        		+ "	RELATED_STORES ( STORE_ID ) AS (\r\n"
        		+ "		    SELECT RELATEDSTORE_ID \r\n"
        		+ "		      FROM STOREREL\r\n"
        		+ "		     WHERE STATE       =  1 \r\n"
        		+ "		       AND STRELTYP_ID = -4 \r\n"
        		+ "		       AND STORE_ID    =  ${param.storeId} )\r\n"
        		+ "        SELECT C.CATENTRY_ID, C.MEMBER_ID, C.CATENTTYPE_ID, C.PARTNUMBER, C.MARKFORDELETE, C.BUYABLE, C.STATE,\r\n"
        		+ "			   COALESCE(D.LANGUAGE_ID, L.LANGUAGE_ID) LANGUAGE_ID,\r\n"
        		+ "               COALESCE(C.MFPARTNUMBER, VP.MFPARTNUMBER) MFPARTNUMBER,\r\n"
        		+ "               COALESCE(C.MFNAME,VP.MFNAME) MFNAME,\r\n"
        		+ "               COALESCE(C.STARTDATE,VP.STARTDATE) STARTDATE,\r\n"
        		+ "               COALESCE(C.ENDDATE,VP.ENDDATE) ENDDATE,\r\n"
        		+ "               COALESCE(D.NAME, PD.NAME) NAME,\r\n"
        		+ "               COALESCE(D.SHORTDESCRIPTION, PD.SHORTDESCRIPTION) SHORTDESCRIPTION,\r\n"
        		+ "               COALESCE(D.KEYWORD, PD.KEYWORD) KEYWORD,\r\n"
        		+ "               D.THUMBNAIL, D.FULLIMAGE, D.PUBLISHED, \r\n"
        		+ "	           R.CATALOG_ID, L.LOCALENAME, S.STOREENT_ID, PD.THUMBNAIL PARENT_THUMBNAIL, PD.FULLIMAGE PARENT_FULLIMAGE\r\n"
        		+ "		       , MPD.DISPLAYNAME ORGENTITYNAME \r\n"
        		+ "          FROM STORECENT SC,\r\n"
        		+ "	        RELATED_STORES RS,\r\n"
        		+ "			language L,\r\n"
        		+ "	        CATGPENREL R\r\n"
        		+ "			join STORECAT S on (S.CATALOG_ID = R.CATALOG_ID)\r\n"
        		+ "			join CATENTRY C on ( R.CATENTRY_ID = C.CATENTRY_ID)\r\n"
        		+ "			${TI_DELTA_JOIN_QUERY}\r\n"
        		+ "            ${X_CUSTOM_JOIN_QUERY}\r\n"
        		+ "            LEFT OUTER JOIN CATENTDESC D ON (D.CATENTRY_ID=C.CATENTRY_ID AND D.LANGUAGE_ID = ${param.langId})\r\n"
        		+ "            LEFT OUTER JOIN CATENTREL PV ON (C.CATENTRY_ID = PV.CATENTRY_ID_CHILD AND PV.CATRELTYPE_ID IN ('PRODUCT_VARIANT', 'PRODUCT_ITEM')\r\n"
        		+ "                                                                                  AND PV.CATENTRY_ID_CHILD <> PV.CATENTRY_ID_PARENT)\r\n"
        		+ "            LEFT OUTER JOIN CATENTRY VP ON (VP.CATENTRY_ID = PV.CATENTRY_ID_PARENT)\r\n"
        		+ "            LEFT OUTER JOIN CATENTDESC PD ON (PV.CATENTRY_ID_PARENT=PD.CATENTRY_ID AND PD.LANGUAGE_ID = ${param.langId})\r\n"
        		+ "			${MARKET_PLACE_SQL_JOIN_QUERY}\r\n"
        		+ "         WHERE R.CATALOG_ID = ${param.catalogId}\r\n"
        		+ "           AND R.CATALOG_ID IN (SELECT CATALOG_ID FROM STORECAT WHERE STOREENT_ID IN\r\n"
        		+ "               (SELECT RELATEDSTORE_ID FROM STOREREL WHERE STATE = 1 AND STRELTYP_ID = -4 AND STORE_ID = ${param.storeId}))\r\n"
        		+ "           AND R.CATENTRY_ID = C.CATENTRY_ID AND C.MARKFORDELETE = 0\r\n"
        		+ "           AND SC.CATENTRY_ID = C.CATENTRY_ID AND SC.STOREENT_ID = RS.STORE_ID\r\n"
        		+ "           AND S.CATALOG_ID = R.CATALOG_ID AND L.LANGUAGE_ID = ${param.langId} ${extCatentryAndSQL}\r\n"
        		+ "         ORDER BY CATENTRY_ID\r\n"
        		+ " ${paging.prefix} ${param.offset} ${paging.link} ${param.pageSize} ${paging.suffix}");
    	testRunner.enqueue(JSON_SNIPPET, attributes);
        testRunner.run();
	
        Relationship expectedRel = ComposeDatabaseSQL.RELATIONSHIP_SUCCESS; 
        testRunner.assertTransferCount(expectedRel, 1);
        expectedRel = ComposeDatabaseSQL.RELATIONSHIP_FAILURE;
        testRunner.assertTransferCount(expectedRel, 0);
    }
}
