package com.mycompany.commerce.rest.extension.project.handler;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2011
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */

import java.util.Map;
import java.util.logging.Logger;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.DELETE;
import javax.ws.rs.Produces;
import com.ibm.commerce.foundation.rest.resourcehandler.AbstractResourceHandler;

import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

import org.apache.wink.common.http.HttpStatus;

import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.mycompany.commerce.rest.extension.bod.helpers.ProjectCollectionHelper;
import commonj.sdo.DataObject;
import com.ibm.icu.text.MessageFormat;
import com.ibm.commerce.rest.config.ResourceConfigManager;

/**
 * This class provides RESTful services to retrieve ProjectCollection details.
 */

@Path("store/{storeId}/projectcollection")
@Encoded
public class ProjectCollectionHandler extends AbstractResourceHandler {

	private static final String CLASSNAME = ProjectCollectionHandler.class.getName();
	private static final Logger LOGGER = LoggingHelper.getLogger(ProjectCollectionHandler.class);

	/** The Constant RESOURCE_NAME. */
	public static final String RESOURCE_NAME = "projectcollection";
	
	/** The Constant RESOURCE_MAPPING_KEY. */
	public static final String RESOURCE_MAPPING_KEY = "projectcollection";

	/** The constant FORMAT_GROUP_NAME */
	public static final String FORMAT_GROUP_NAME = "ShowProjectCollection";
	
	/**
	 * Helper to retrieve and deal with BOD.
	 */
	protected ProjectCollectionHelper helper = getHelper();
	
	/**
	 * @see com.ibm.commerce.foundation.rest.resourcehandler.IResourceHandler#getResourceName()
	 */
	public String getResourceName() {
		return RESOURCE_NAME;
	}
	
	/**
	 * @see com.ibm.commerce.foundation.rest.resourcehandler.AbstractResourceHandler#getFormattingGroupName()
	 */
	@Override
	public String getFormattingGroupName() {
		return FORMAT_GROUP_NAME;
	}
	
	/**
	 * This method returns the BOD helper associated with the projectcollection resource.
	 * This method can be override to use the extended <code>ProjectCollectionHelper</code> for customization.
	 * @return ProjectCollectionHelper
	 */
	public ProjectCollectionHelper getHelper() {
		if(null == helper){
			helper = new ProjectCollectionHelper();
		}
		return helper;
	}
	
	
	/**
	 * This method returns the projectcollection details by specified projectcollectionid.
	 *
	 * @param storeId the store identifier, this is mandatory parameter and cann't be null or empty.
	 * @param projectcollectionid the noun's projectcollectionid, this is mandatory parameter and cann't be null or empty.
	 * @param responseFormat the response format (xml, json, or atom).
	 * @return The array of projectcollection details in the specified format.
	 */
	@GET
	@Path("byProjectCollectionId/{projectcollectionid}")
	@Produces( { "application/atom+xml", "application/json", "application/xml", "application/xhtml+xml" })
	public Response findProjectCollectionByProjectCollectionId(
			@PathParam("storeId") String storeId,
			@PathParam("projectcollectionid") String projectcollectionid,
			@QueryParam(value = "responseFormat") String responseFormat) {
		
		final String METHODNAME = "findProjectCollectionByProjectCollectionId(String, String, String)";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[]{storeId, projectcollectionid, responseFormat});
		}
		final String uriPath = "store/{storeId}/projectcollection/byProjectCollectionId/{projectcollectionid}"; 
		final String accessProfile = ResourceConfigManager.getInstance().getAccessProfile(RESOURCE_NAME, uriPath);
		
		// Perform the service request and return the response in the appropriate format.
		Object[] params = { projectcollectionid };
		String expression = MessageFormat.format(
				ProjectCollectionHelper.FIND_BY_PROJECTCOLLECTIONID_XPATH, params);
		
		Response result = renderGetProjectCollection(expression, accessProfile, responseFormat);
		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME, new Object[]{result});
		}
		return result;
	}
	
	/**
	 * This method builds the response in appropriate format.
	 *
	 * @param dataArea the resulted data area for ProjectCollection.
	 * @param responseFormat the response format.
	 * @return the response for ProjectCollection.
	 */
	protected Response renderGetProjectCollection(String expression, String accessProfile,
			String responseFormat) {
		
		final String METHODNAME = "renderGetProjectCollection(String, String, String)";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[]{expression, accessProfile, responseFormat});
		}
		
		Response result = null;
		try {

			// call helper to get projectcollection from service client
			DataObject dataArea = helper.getProjectCollection(businessContext,
					activityTokenCallbackHandler, expression, accessProfile);

			Map<String, Object> dataMap = createMapForProvider(dataArea,
					getResourceName(), RESOURCE_MAPPING_KEY, true);

			result = generateResponseFromHttpStatusCodeAndRespData(
					responseFormat, dataMap, HttpStatus.OK);

		} catch (Exception ex) {
			// Call handleException to generate response with error status code
    		result = handleException(responseFormat, ex, METHODNAME);
    	}

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME, new Object[]{result});
		}
		return result;
	}

	
	
	
}
