package com.mycompany.commerce.rest.extension.bod.helpers;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2011
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;

import java.util.logging.Logger;

import com.ibm.commerce.foundation.client.facade.bod.AbstractBusinessObjectDocumentFacadeClient;
import com.ibm.commerce.foundation.client.util.oagis.SelectionCriteriaHelper;
import com.ibm.commerce.foundation.common.datatypes.BusinessContextType;
import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.mycompany.commerce.project.facade.client.ProjectException;
import com.mycompany.commerce.project.facade.client.ProjectFacadeClient;
import com.ibm.commerce.oagis9.datatypes.GetType;
import com.ibm.commerce.oagis9.datatypes.ExpressionType;
import com.ibm.commerce.foundation.rest.bodmapping.BODMappingConfigMgr;
import com.ibm.commerce.foundation.rest.bodmapping.RestToBODHelper;
import commonj.sdo.DataObject;

/**
 * The ProjectHelper is a helper utility class for ProjectHandler 
 * to make the OAGIS calls and get the data area for constructing the response. 
 */
public class ProjectHelper {
	private static final String CLASSNAME = ProjectHelper.class.getName();
	private static final Logger LOGGER = LoggingHelper.getLogger(ProjectHelper.class);

	/**
	 * The default access profile, used when an access profile is not specified
	 * using the <code>accessProfile</code> query parameter.
	 */
	public static final String DEFAULT_ACCESS_PROFILE = "MyCompany_Store_Summary";


	/**
	 * The XPATH expression, used to retrieve the Project by ProjectId
	 */
	public static final String FIND_BY_PROJECTID_XPATH = "/Project[ProjectIdentifier[(UniqueID={0})]]";
	
	
	/**
	 * This method retrieves the project details for the specified expression.
	 *
	 * @param businessContext the business context.
	 * @param callbackHandler the callback handler.
	 * @param expression the XPath expression.
	 * @param accessProfile the specified access profile.
	 * @return the data object for the project.
	 * @throws ProjectException the project exception
	 */
	public DataObject getProject(BusinessContextType businessContext, CallbackHandler callbackHandler, String expression, String accessProfile) throws ProjectException {
		
		final String METHODNAME = "getProject(BusinessContextType, CallbackHandler, String, String)";
		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME);
		}
		if (accessProfile == null) {
	    	accessProfile = getAccessProfile();
	    }
		
		// Construct the selection criteria helper.
		SelectionCriteriaHelper selectionCriteria = buildExpression(expression, accessProfile);

		// Perform the service request.
		ProjectFacadeClient client = new ProjectFacadeClient(businessContext, callbackHandler);
		GetType getVerb = buildGetVerb(selectionCriteria.getSelectionCriteriaExpression());
		DataObject dataArea = (DataObject)client.getProject(getVerb);
		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME, dataArea);
		}
		return dataArea;
	}
	
	/**
	 * This method creates a <code>SelectionCriteriaHelper</code> object with the provided XPath expression and
	 * access profile.  This method can be overridden to add additional control parameters to the expression. 
	 * @param expression the XPath expression of the request.
	 * @param accessProfile the access profile of the request.
	 * @return the <code>SelectionCriteriaHelper</code> with the provided XPath expression and access profile.
	 */
	protected SelectionCriteriaHelper buildExpression(String expression, String accessProfile) {
		SelectionCriteriaHelper selectionCriteria = new SelectionCriteriaHelper(expression);
		selectionCriteria.addAccessProfile(accessProfile);		
		return selectionCriteria;
	}
	
	/**
	 * This method creates the Project Get Verb.  This method can be 
	 * overridden to add paging information.
	 * @param expression The get expression.
	 * @return The Get Verb.
	 */
	protected GetType buildGetVerb(ExpressionType expression) {		
		return AbstractBusinessObjectDocumentFacadeClient.createGetVerb(expression);
	}
	
	/**
	 * This method returns the access profile for the OAGIS service call.
	 * This method can be overridden to change the access profile.
	 *
	 * @return the access profile
	 */
	public String getAccessProfile() {
		return DEFAULT_ACCESS_PROFILE;
	}
	
	
	
	
}
