BEGIN_SYMBOL_DEFINITIONS

  COLS:XPRJCOL=XPRJCOL:*  
  COLS:XPRJCOLDES=XPRJCOLDES:*

END_SYMBOL_DEFINITIONS

<!-- ====================================================================== 
	Get project collection based on the project collection id 
	@param UniqueID The project collection id.	
=========================================================================== -->
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/ProjectCollection[ProjectCollectionIdentifier[(UniqueID=)]]+MyCompany_Project_Update
	base_table=XPRJCOL
	sql=
		SELECT 
			XPRJCOL.$COLS:XPRJCOL$
							
	     	FROM	     			
	     		XPRJCOL
	     	WHERE
	     		XPRJCOL.XPRJCOL_ID IN (?UniqueID?)	     			
	     			
END_XPATH_TO_SQL_STATEMENT
<!-- ====================================================================== 
	Get project collection description based on the project collection id 
	@param UniqueID The project collection id.	
=========================================================================== -->
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/ProjectCollection[ProjectCollectionIdentifier[(UniqueID=)]]+MyCompany_ProjectColDescription_Update
	base_table=XPRJCOLDES
	sql=
		SELECT 
			XPRJCOLDES.$COLS:XPRJCOLDES$
							
	     	FROM	     			
	     		XPRJCOLDES
	     	WHERE
	     		XPRJCOLDES.XPRJCOL_ID IN (?UniqueID?)	     			
	     			
END_XPATH_TO_SQL_STATEMENT
<!-- ====================================================================== 
	Get project collection based on the project collection name 
	@param UniqueID The project collection name.	
=========================================================================== -->
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/ProjectCollection[ProjectCollectionIdentifier[ExternalIdentifier[(Name=)]]]+MyCompany_IdResolve
	base_table=XPRJCOL
	sql=
		SELECT 
			XPRJCOL.$COLS:XPRJCOL$
							
	     	FROM	     			
	     		XPRJCOL
	     	WHERE
	     		XPRJCOL.PRJCOLNAME IN (?Name?)	     			
	     			
END_XPATH_TO_SQL_STATEMENT


