<%--
 =================================================================
  Licensed Materials - Property of IBM

  WebSphere Commerce

  (C) Copyright IBM Corp. 2011 All Rights Reserved.

  US Government Users Restricted Rights - Use, duplication or
  disclosure restricted by GSA ADP Schedule Contract with
  IBM Corp.
 =================================================================
--%>
<%@ include file="../../foundation/atom/FeedEnvironment.jspf"%>

<c:set var="projects" value="${dataObject.project}"/>

<c:if test="${!empty projects}">

<!-- use lang and xml:lang if your language supports it - A.7 -->
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
<head>
  <title>Recipe Collction</title>
  <!-- Embed encoding when you can't set it from the server - A.9 -->
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

  <!-- use base, not xml:base - A.20 -->
  <base href="http://www.w3.org/MarkUp" />

  <!-- if you must embed, escape bad stuff - A.4, A.14 -->
  <style type="text/css">/*<![CDATA[*/
      /* Use lower case names in stylesheets - A.13 */
      .main { padding-left: 10px; }
      /* put properties on whole document - A.24 */
      html {background-color: #e4e5e9; }
      body {background-color: #e4e5e9; }
  /*]]>*/</style>

</head>

<body>

<!-- use the id attribute to identify elements - A.8 -->
<div id="main">

    <!-- ensure there are never linebreaks in attribute values - A.5 -->
    <h1 title="Recipe Collections">Recipe:</h1>
    
  <p/>
    
    <table>
        <!-- use explicit tbody element - A.19 -->
        <tbody>
		<c:forEach items="${projects}" var="project">
		  
		   <tr>
                <td width="804"><b>Name:</b> ${ project.projectIdentifier.externalIdentifier.name}</td>
          </tr>
		   <tr>
                <td><b>Unique ID:</b> ${ project.projectIdentifier.uniqueID}</td>
          </tr>   
		   <tr>
                <td><b>Collection:</b> ${ project.collection[0].projectCollectionIdentifier.externalIdentifier.name}</td>
          </tr>
           <tr>
                <td><b> Description:</b> ${ project.description[0].longDescription }</td>
          </tr>          
           <tr>
                <td></td>
          </tr> 
                     
           <tr>
             <td>
             <p><strong>Materials:</strong>: </p>
                       
               <ol>
                 
                <c:forEach items="${project.material}" var="material">
			
					<c:forEach items="${material.projectMaterialDescription}" var="materialDescription">
                
                		<li> ${ materialDescription.value}</li></br>
                
          			</c:forEach>
           
         		</c:forEach>
                        
            	
        		</ol></td>
        		     	
           </tr>
           
           <tr>
                <td><b>Instructions:</b></td>
          </tr> 
          				
            <tr>
                
                <td>
                
                <ol>
                 
                <c:forEach items="${project.instruction}" var="instruction">
			
					<c:forEach items="${instruction.projectInstructionDescription}" var="instructionDescription">
                
                		<li> ${ instructionDescription.value}</li></br>
                
          			</c:forEach>
           
          		 </c:forEach>
            	
            	</ol>
                </td>
           
           
            </tr>                   
       
            <tr>
                <td></td>
            </tr>
	

       
		</c:forEach>
        </tbody>
    </table>

</div>

</body>

</html>
</c:if>

