package com.mycompany.commerce.project.facade.server.services.dataaccess.bom.mediator;
/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2008
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import com.ibm.commerce.foundation.common.datatypes.CommerceFoundationFactory;
import com.ibm.commerce.foundation.common.datatypes.DescriptionType;
import com.ibm.commerce.foundation.common.datatypes.StoreIdentifierType;
import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.server.services.dataaccess.bom.exception.BusinessObjectMediatorException;
import com.ibm.commerce.foundation.server.services.dataaccess.bom.mediator.AbstractReadBusinessObjectPartMediatorImpl;
import com.mycompany.commerce.project.facade.datatypes.ProjectCollectionExternalIdentifierType;
import com.mycompany.commerce.project.facade.datatypes.ProjectCollectionIdentifierType;
import com.mycompany.commerce.project.facade.datatypes.ProjectCollectionReferenceType;
import com.mycompany.commerce.project.facade.datatypes.ProjectFactory;
import com.mycompany.commerce.project.facade.datatypes.ProjectType;
import com.mycompany.commerce.project.facade.server.entity.datatypes.Xprjcoldes;
import com.mycompany.commerce.project.facade.server.entity.datatypes.Xprjprjcolrel;
import com.mycompany.commerce.project.facade.server.entity.datatypes.Xproject;

/**
 * Read operation on the logical noun for Project
 */
public class ReadProjectCollectionRelPartMediator extends
		AbstractReadBusinessObjectPartMediatorImpl {

	private static final String CLASSNAME = ReadProjectCollectionRelPartMediator.class
			.getName();

	private static final Logger LOGGER = LoggingHelper
			.getLogger(ReadProjectCollectionRelPartMediator.class);

	/**
	 * This method reads the logical Project description noun part and adds it
	 * to the main Project noun.
	 * 
	 * @param aLogicalEntityType
	 *            The root noun which will contain the noun part built through
	 *            this mediator.
	 * @param aPhysicalEntityType
	 *            The root physical data object.
	 * @throws BusinessObjectMediatorException
	 */
	public void buildNounPart(Object aLogicalEntityType,
			Object aPhysicalEntityType) throws BusinessObjectMediatorException {
		final String METHODNAME = "buildNounPart";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] {
					aLogicalEntityType, aPhysicalEntityType });
		}

		if (aPhysicalEntityType != null) {
			ProjectType aProjectLogicalDO = (ProjectType) aLogicalEntityType;
			Xproject aProjectPhysicalDO = (Xproject) aPhysicalEntityType;

			// build the logical SDO by using the Phyical SDO

			List aListIns = aProjectPhysicalDO.getXprjprjcolrelForXproject();
			if (aListIns != null) {
				Iterator objIter = aListIns.iterator();

				while (objIter.hasNext()) {

					Xprjprjcolrel aPhysicalColRel = (Xprjprjcolrel) objIter
							.next();

					ProjectCollectionReferenceType colRefType = getProjectFactory()
							.createProjectCollectionReferenceType();
					ProjectCollectionIdentifierType colIdentifier = getProjectFactory()
							.createProjectCollectionIdentifierType();
					colIdentifier.setUniqueID(Long.toString(aPhysicalColRel
							.getXprjcol_id()));
					ProjectCollectionExternalIdentifierType externalIdentifier = getProjectFactory()
							.createProjectCollectionExternalIdentifierType();
					colIdentifier.setExternalIdentifier(externalIdentifier);
					externalIdentifier.setName(aPhysicalColRel
							.getXprjcolForXprjprjcolrel().getPrjcolname());
					colRefType.setProjectCollectionIdentifier(colIdentifier);
					StoreIdentifierType storeindentifier = getCommerceFoundationFactory()
							.createStoreIdentifierType();
					storeindentifier.setUniqueID(Integer
							.toString(aPhysicalColRel.getStoreent_id()));
					colRefType.setStoreIdentifier(storeindentifier);
					buildCollectionDescription(colRefType, aPhysicalColRel);

					aProjectLogicalDO.getCollection().add(colRefType);

				}
			}

		}

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}

	private void buildCollectionDescription(
			ProjectCollectionReferenceType colRefType,
			Xprjprjcolrel aPhysicalColRel) {
		final String METHODNAME = "buildInstructionDescription";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { colRefType,
					aPhysicalColRel });
		}

		List aListDescription = aPhysicalColRel.getXprjcolForXprjprjcolrel()
				.getXprjcoldesForXprjcol();
		if (aListDescription != null) {
			Xprjcoldes aDescription = (Xprjcoldes)aListDescription.get(0);
			DescriptionType descriptionType = getCommerceFoundationFactory()
					.createDescriptionType();
			descriptionType.setLanguage(Integer.toString(aDescription.getLanguage_id()));
			descriptionType.setValue(aDescription.getShortdesc());
			colRefType.setDisplayName(descriptionType);
			
				
		}
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}

	/**
	 * Getter method which returns the <code>ProjectFactory</code>.
	 * 
	 * @return an object of type <code>ProjectFactory</code>
	 */
	protected ProjectFactory getProjectFactory() {
		return ProjectFactory.eINSTANCE;
	}

	/**
	 * This method will return the default instance of the Commerce Foundation
	 * Factory. This factory can be used to create objects defined by the
	 * Commerce Foundation.
	 * 
	 * @return The default Commerce Foundation Factory.
	 */
	protected CommerceFoundationFactory getCommerceFoundationFactory() {
		return CommerceFoundationFactory.eINSTANCE;
	}

}
