package com.mycompany.commerce.project.facade.server.services.dataaccess.bom.mediator;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2008
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.ibm.commerce.foundation.client.util.oagis.RelationalExpression;
import com.ibm.commerce.foundation.common.datatypes.DescriptionType;
import com.ibm.commerce.foundation.common.exception.AbstractApplicationException;
import com.ibm.commerce.foundation.common.exception.ApplicationError;
import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.server.services.dataaccess.DataServiceFacade;
import com.ibm.commerce.foundation.server.services.dataaccess.PhysicalDataContainer;
import com.ibm.commerce.foundation.server.services.dataaccess.SelectionCriteria;
import com.ibm.commerce.foundation.server.services.dataaccess.bom.mediator.AbstractChangeBusinessObjectPartMediatorImpl;
import com.ibm.commerce.foundation.server.services.dataaccess.exception.DataMediatorException;
import com.mycompany.commerce.project.facade.ProjectFacadeConstants;
import com.mycompany.commerce.project.facade.datatypes.ProjectCollectionType;
import com.mycompany.commerce.project.facade.server.entity.datatypes.Xprjcoldes;
import com.mycompany.commerce.project.facade.server.metadata.ProjectMetadata;
import com.mycompany.commerce.project.logging.ProjectApplicationMessageKeys;

/**
 * Update operation on the logical noun for ProjectCollection
 */
public class ChangeProjectCollectionDescriptionPartMediator extends
		AbstractChangeBusinessObjectPartMediatorImpl {

	private static final String CLASSNAME = ChangeProjectCollectionDescriptionPartMediator.class
			.getName();

	private static final Logger LOGGER = LoggingHelper
			.getLogger(ChangeProjectCollectionDescriptionPartMediator.class);

	public static final String CHANGE_PROJECTCOL_DESCRIPTION_ACCESS_PROFILE = "MyCompany_ProjectColDescription_Update";

	private static final String UNIQUE_ID = "UniqueID";

	/**
	 * Initialize the physical data container for this mediator. Obtain the
	 * physical entities that correspond to this logical entity. The data from
	 * noun present in the list will be used to fetch the physical entities with
	 * the help of queries configured with DSL
	 * 
	 * @throws DataMediatorException
	 * @see com.ibm.commerce.foundation.server.services.dataaccess.bom.mediator.AbstractChangeBusinessObjectPartMediatorImpl#initializePhysicalDataContainer(java.util.List)
	 */
	protected PhysicalDataContainer initializePhysicalDataContainer(
			Map aMapNounPart) throws Exception {
		final String METHODNAME = "initializePhysicalDataContainer";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME,
					new Object[] { aMapNounPart });
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}

		PhysicalDataContainer physicalEntites = null;

		List projectIds = new ArrayList();
		Iterator projectIter = aMapNounPart.keySet().iterator();
		while (projectIter.hasNext()) {
			ProjectCollectionType aProject = (ProjectCollectionType) projectIter
					.next();
			String uniqueId = aProject.getProjectCollectionIdentifier()
					.getUniqueID();
			if (uniqueId != null && uniqueId.length() > 0) {
				projectIds.add(uniqueId);
			}
		}

		if (!projectIds.isEmpty()) {
			SelectionCriteria anExpression = new SelectionCriteria();
			anExpression
					.setXPathKey(ProjectFacadeConstants.XPATH_PROJECTCOLLECTION_UID
							+ ProjectFacadeConstants.DOUBLE_CLOSE_XPATH);
			;
			anExpression
					.setAccessProfile(CHANGE_PROJECTCOL_DESCRIPTION_ACCESS_PROFILE);
			anExpression.setXPathParameter(new RelationalExpression(UNIQUE_ID,
					projectIds));

			physicalEntites = DataServiceFacade.getInstance(
					ProjectFacadeConstants.COMPONENT_NAME)
					.getPhysicalDataContainer(anExpression);

		} else {
			physicalEntites = DataServiceFacade.getInstance(
					ProjectFacadeConstants.COMPONENT_NAME)
					.getEmptyPhysicalDataContainer();

		}

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
		return physicalEntites;
	}
	/**
	 * This method performs no actions as the resolve is done by the
	 * <code>ChangeProjectCollectionMediator</code>.
	 * 
	 * @param aNoun
	 *            The logical <code>ProjectCollectionType</code> SDO business
	 *            object.
	 * @param aNounPart
	 *            The logical <code>ProjectCollectionType</code> SDO business
	 *            object.
	 * @return This method returns false.
	 */
	protected boolean resolveByExternalIdentifier(Object aNoun, Object aNounPart)
			throws Exception {

		return false;
	}

	/**
	 * Checks the object to be created . If there are errors then a validation
	 * error will be added to the return list
	 * 
	 * @param aNoun
	 *            The noun that is being requested to be changed
	 * @param aNounPart
	 *            The noun part that is being requested to be changed
	 * @return List of errors; null if there are no errors
	 * @throws DataMediatorException
	 * 
	 * @see com.ibm.commerce.foundation.server.services.dataaccess.bom.mediator.ChangeBusinessObjectPartMediator#validateCreate(java.lang.Object)
	 */
	public List validateCreate(Object aNoun, Object aNounPart)
			throws DataMediatorException {
		final String METHODNAME = "validateCreate";
		boolean traceEnabled = LoggingHelper.isTraceEnabled(LOGGER);
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun,
					aNounPart });
		}
		List validationErrors = new ArrayList();

		DescriptionType aLogicalDescription = (DescriptionType) aNounPart;
		//Check each description for a language ID.		
		if (aLogicalDescription.getLanguage() == null || aLogicalDescription.getLanguage().length() == 0) {
			ApplicationError validationError = new ApplicationError(
					ApplicationError.TYPE_MISSING_PARAMETER,
					ProjectApplicationMessageKeys._ERR_EXCEPTION_GETTING_LANGUAGE_ID,
					new Object[] {aLogicalDescription},
					LOGGER.getResourceBundleName());	
			validationErrors.add(validationError);
		}								
		if (ProjectMetadata.invalidStringLength(aLogicalDescription.getValue(),
				ProjectMetadata.PROJECTCOLLECTION_DESCRIPTION_LENGTH_LIMIT)) {
			// checked description length
			ApplicationError validateError = new ApplicationError(
					ApplicationError.TYPE_GENERIC_ERROR,
					ProjectApplicationMessageKeys._APP_PROJECTCOLLECTION_DESCRIPTION_TOO_LONG,
					null, LOGGER.getResourceBundleName());
			validationErrors.add(validateError);
		}
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME, validationErrors);
		}
		return validationErrors;
	}

	/**
	 * This method checks if the logical <code>ProjectCollectionType</code>
	 * noun can be updated. It checks that the noun exists in the physical data
	 * container If the noun cannot be updated, the appropriate error exception
	 * is added to the list of exceptions to be returned to the caller.
	 * 
	 * @param aNoun
	 *            The logical <code>ProjectCollectionType</code> SDO business
	 *            object to validate.
	 * @param aNounPart
	 *            The logical <code>DescriptionType</code> SDO business
	 *            object.
	 * @return This method returns a list of <code>ApplicationError</code> if
	 *         there are any errors, otherwise the list will be empty.
	 * @throws DataMediatorException
	 */
	public List validateChange(Object aNoun, Object aNounPart)
			throws DataMediatorException {
		final String METHODNAME = "validateChange";
		boolean traceEnabled = LoggingHelper.isTraceEnabled(LOGGER);
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun,
					aNounPart });
		}
		List validationErrors = new ArrayList();

		DescriptionType aLogicalDescription = (DescriptionType) aNounPart;
		//Check each description for a language ID.		
		if (aLogicalDescription.getLanguage() == null || aLogicalDescription.getLanguage().length() == 0) {
			ApplicationError validationError = new ApplicationError(
					ApplicationError.TYPE_MISSING_PARAMETER,
					ProjectApplicationMessageKeys._ERR_EXCEPTION_GETTING_LANGUAGE_ID,
					new Object[] {aLogicalDescription},
					LOGGER.getResourceBundleName());	
			validationErrors.add(validationError);
		}				
		if (ProjectMetadata.invalidStringLength(aLogicalDescription.getValue(),
				ProjectMetadata.PROJECTCOLLECTION_DESCRIPTION_LENGTH_LIMIT)) {
			// checked description length
			ApplicationError validateError = new ApplicationError(
					ApplicationError.TYPE_GENERIC_ERROR,
					ProjectApplicationMessageKeys._APP_PROJECTCOLLECTION_DESCRIPTION_TOO_LONG,
					null, LOGGER.getResourceBundleName());
			validationErrors.add(validateError);
		}
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME, validationErrors);
		}
		return validationErrors;
	}
	/**
	 * This method performs no actions as it does not need delete services.
	 * 
	 * @param aNoun
	 *            The logical <code>ProjectCollectionType</code> SDO business object.
	 * @param aNounPart
	 *            The logical <code>DescriptionType</code> SDO business object.	
	 * @throws AbstractApplicationException
	 */
	public List validateDelete(Object aNoun, Object aNounPart)
			throws AbstractApplicationException {

		return null;
	}

	/**
	 * Creates the physical entities corresponding to the logical noun part and
	 * adds to the root physical entity
	 * 
	 * @param aNoun
	 *            (ProjectCollectionType) The logical noun that contains the
	 *            noun part
	 * @param aNounPart
	 *            (DescriptionType) The noun part for which the
	 *            corresponding physical entities needs to be created
	 * @throws AbstractApplicationException
	 *             Error during create
	 */

	public void create(Object aNoun, Object aNounPart)
			throws AbstractApplicationException {
		final String METHODNAME = "create";

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun,
					aNounPart });

		}

		ProjectCollectionType aLogicalProject = (ProjectCollectionType) aNoun;

		Long aProjectId = Long.valueOf(aLogicalProject
				.getProjectCollectionIdentifier().getUniqueID());
		DescriptionType logicalDesc = (DescriptionType) aNounPart;

		Integer languageId = Integer.valueOf(logicalDesc.getLanguage());
		
		Xprjcoldes aPhysicalPrjcoldes = (Xprjcoldes) getPhysicalDataContainer()
				.createPhysicalObject(null, Xprjcoldes.class);

		aPhysicalPrjcoldes.setLanguage_id(languageId.intValue());
		aPhysicalPrjcoldes.setXprjcol_id(aProjectId.longValue());
		aPhysicalPrjcoldes.setShortdesc(logicalDesc.getValue());

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {

			LOGGER.exiting(CLASSNAME, METHODNAME);
		}

	}

	/**
	 * This method updates the physical data container with the modified
	 * <code>Projectcollection</code> object.
	 * 
	 * @param aNoun
	 *            The logical <code>ProjectCollectionType</code> SDO business
	 *            object to update.
	 * @param aNounPart
	 *            The logical <code>DescriptionType</code> SDO business object
	 *            to update.
	 * @throws AbstractApplicationException
	 */
	public void update(Object aNoun, Object aNounPart)
			throws AbstractApplicationException {
		final String METHODNAME = "update";

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun,
					aNounPart });
		}

		Xprjcoldes aPhysicalEntity = (Xprjcoldes) findPhysicalEntity(aNoun,
				aNounPart);

		DescriptionType aLogicalDescription = (DescriptionType) aNounPart;

		if (aPhysicalEntity != null) {
			aPhysicalEntity.setShortdesc(aLogicalDescription.getValue());

		} else {
			create(aNoun, aNounPart);
		}

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}

	}
	/**
	 * This method performs no actions as it does not need delete services.
	 * 
	 * @param aNoun
	 *            The logical <code>ProjectCollectionType</code> SDO business object.
	 * @param aNounPart
	 *            The logical <code>DescriptionType</code> SDO business object.
	 * @throws AbstractApplicationException
	 */
	public void delete(Object arg0, Object arg1)
			throws AbstractApplicationException {

	}

	/**
	 * This method returns the <code>Xprjdes</code> physical SDO from the
	 * <code>PhysicalDataContainer</code> that was created in the
	 * <code>ChangeProjectDescriptionMediator</code> mediator.
	 * 
	 * @param aNoun
	 *            The logical <code>ProjectCollectionType</code> SDO.
	 * @param aNounPart
	 *            The logical <code>DescriptionType</code> SDO.
	 * @return This method returns the <code>Xprjdes</code> object if it is
	 *         found, otherwise it returns null.
	 * @throws DataMediatorException
	 */
	public Object findPhysicalEntity(Object aNoun, Object aNounPart)
			throws DataMediatorException {
		final String METHODNAME = "findPhysicalEntity";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { aNoun });
		}

		Xprjcoldes aPhysicalEntity = null;
		PhysicalDataContainer pdc = getPhysicalDataContainer();

		// if the PhysicalDataContainer is not null, loop it and compare the uid
		// to find the DataObject
		if (pdc != null) {
			ProjectCollectionType aLogicalProject = (ProjectCollectionType) aNoun;
			DescriptionType aLogicalDescription = (DescriptionType) aNounPart;

			Integer languageId 	= Integer.valueOf(aLogicalDescription.getLanguage());
			
			if (aLogicalProject.getProjectCollectionIdentifier().getUniqueID() != null) {
				long projectId = Long.parseLong(aLogicalProject
						.getProjectCollectionIdentifier().getUniqueID());
				if (LoggingHelper.isTraceEnabled(LOGGER)) {
					LOGGER.logp(Level.FINE, CLASSNAME, METHODNAME,
							"Find Project: " + projectId);
				}

				List projectList = pdc.getPhysicalObjects();
				if (projectList != null && projectList.size() > 0) {
					Iterator projectIter = projectList.iterator();
					while (projectIter.hasNext()) {
						Xprjcoldes tempPhysicalEntity = (Xprjcoldes) projectIter
								.next();
						// compare id to get the Physical DataObject
						if (tempPhysicalEntity.getXprjcol_id() == projectId
								&& tempPhysicalEntity.getLanguage_id() == languageId
										.intValue()) {
							
							aPhysicalEntity = tempPhysicalEntity;
							break;
						}
					}
				}

			}
		}

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME, aPhysicalEntity);
		}

		return aPhysicalEntity;

	}

	/**
	 * This method gets the xpath for the main noun part.
	 * 
	 * @return The xpath for the main noun part.
	 */
	public String[] getNounPartXPaths() {

		return XPATH;
	}

	private static final String[] XPATH = new String[] { "/Description[]" };
}
