package com.mycompany.commerce.project.facade.server.helpers;
/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp.  2008
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */
import java.util.logging.Logger;

import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.server.services.businesscontext.ContextService;
import com.ibm.commerce.foundation.server.services.businesscontext.ContextServiceFactory;
import com.ibm.commerce.context.base.BaseContext;
import com.ibm.commerce.context.globalization.GlobalizationContext;
import com.mycompany.commerce.project.logging.ProjectApplicationMessageKeys;

/**
 *This class has some the common methods that are used by the project component.
 */
public class ProjectComponentHelper {

	private static final String CLASSNAME = ProjectComponentHelper.class
			.getName();

	private static final Logger LOGGER = LoggingHelper
			.getLogger(ProjectComponentHelper.class);

	/**
	 * This method gets the store ID from the service context.
	 * @return The Integer storeId.	 
	 */
	public static Integer getStoreId() {

		String method_name = "getStoreId()";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, method_name);
		}
		Integer storeId = null;
		ContextService bcs = ContextServiceFactory.getContextService();
		try {
			BaseContext baseContext = (BaseContext) bcs
					.findContext(BaseContext.CONTEXT_NAME);
			storeId = baseContext.getStoreId();
			if (storeId == null) {
				LOGGER
						.log(
								LoggingHelper.DEFAULT_TRACE_LOG_LEVEL,
								ProjectApplicationMessageKeys._ERR_EXCEPTION_GETTING_STORE_ID,
								new Object[] {});

			}

		} catch (Exception e) {
			if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper
					.isTraceEnabled(LOGGER)) {
				LOGGER
						.log(
								LoggingHelper.DEFAULT_TRACE_LOG_LEVEL,
								ProjectApplicationMessageKeys._ERR_EXCEPTION_GETTING_STORE_ID,
								new Object[] {});

			}

		}

		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper
				.isTraceEnabled(LOGGER)) {
			LOGGER.log(LoggingHelper.DEFAULT_TRACE_LOG_LEVEL, method_name
					+ ", The store ID from the base context  was retrieved: "
					+ storeId);
		}
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, method_name, storeId);
		}

		return storeId;

	}

	/**
	 * This method gets the language ID from the service context.
	 * @return The language ID.	 
	 */
	public static Integer getLanguageId() {

		String method_name = "getLanguageId()";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, method_name);
		}
		Integer languageId = null;
		ContextService bcs = ContextServiceFactory.getContextService();
		try {
			GlobalizationContext context = (GlobalizationContext) bcs
					.findContext(GlobalizationContext.CONTEXT_NAME);
			languageId = context.getLanguageId();

		} catch (Exception e) {
			if (LoggingHelper.isTraceEnabled(LOGGER)) {
				LOGGER
						.log(
								LoggingHelper.DEFAULT_TRACE_LOG_LEVEL,
								ProjectApplicationMessageKeys._ERR_EXCEPTION_GETTING_LANGUAGE_ID,
								new Object[] {});

			}

		}

		if (languageId == null) {
			if (LoggingHelper.isTraceEnabled(LOGGER)) {
				LOGGER
						.log(
								LoggingHelper.DEFAULT_TRACE_LOG_LEVEL,
								ProjectApplicationMessageKeys._ERR_EXCEPTION_GETTING_LANGUAGE_ID,
								new Object[] {});
			}

		}

		if (LoggingHelper.isTraceEnabled(LOGGER)) {
			LOGGER
					.log(
							LoggingHelper.DEFAULT_TRACE_LOG_LEVEL,
							method_name
									+ ", The language ID from the globalization context  was retrieved: "
									+ languageId);

		}

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, method_name, languageId);
		}

		return languageId;

	}

}
