package com.mycompany.commerce.project.facade.server.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import com.ibm.commerce.foundation.common.exception.AbstractApplicationException;
import com.ibm.commerce.foundation.common.exception.ApplicationError;
import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.internal.common.exception.FoundationApplicationException;
import com.ibm.commerce.foundation.server.command.bod.bom.AbstractProcessCreateActionUsingBusinessObjectMediatorCmdImpl;
import com.mycompany.commerce.project.logging.ProjectApplicationMessageKeys;

/**
 * This command is used to create a ProjectCollection noun.  This command performs business logic validation and its parent calls
 * the ChangeProjectCollectionMediator to persist the noun in the database.
 */
public class ProcessProjectCollectionCreateActionCmdImpl extends AbstractProcessCreateActionUsingBusinessObjectMediatorCmdImpl 
		implements ProcessProjectCollectionActionCmd {
	
	private static final String CLASSNAME = ProcessProjectCollectionCreateActionCmdImpl.class.getName();
	
	private static final Logger LOGGER = LoggingHelper.getLogger(ProcessProjectCollectionCreateActionCmdImpl.class);
		
	/**
	 * This method performs business logic validation for this action.
	 * @throws AbstractApplicationException	 
	 */
	public void validate() throws AbstractApplicationException {
		final String METHODNAME = "validate";		
		
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME);
		}
		
		// TODO: Add business logic validation.
		
		// The following sample code creates an invalid operation exception. 	
		//List validationErrors = new ArrayList();
		//ApplicationError validateError = new ApplicationError(
		//		ApplicationError.TYPE_GENERIC_ERROR,
		//		ProjectApplicationMessageKeys._APP_INVALID_OPERATION,
		//		new Object[] {getNoun()}, LOGGER.getResourceBundleName());
		//validationErrors.add(validateError);
		//if (validationErrors != null && validationErrors.size() > 0) {
		//	throw new FoundationApplicationException(validationErrors, CLASSNAME, METHODNAME, null);
		//}
		
		// Must always call super() to run the data service layer validation.
		super.validate();		
		
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}
	
	/**
	 * This method returns if the command can be executed.
	 * @return This method returns true if the command is ready to be executed, otherwise it returns false.
	 */
	public boolean isReadyToCallExecute() {
		return true;
	}		

}