/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package com.mycompany.commerce.project.facade.datatypes;

import com.ibm.commerce.foundation.common.datatypes.CatalogEntryIdentifierType;
import com.ibm.commerce.foundation.common.datatypes.DescriptionType;
import com.ibm.commerce.foundation.common.datatypes.StoreIdentifierType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Catentry Reference Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * 
 * 				Defines a reference to a Catalog Entry for a specific
 * 				store.
 * 			
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.CatentryReferenceType#getCatalogEntryIdentifier <em>Catalog Entry Identifier</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.CatentryReferenceType#getStoreIdentifier <em>Store Identifier</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.CatentryReferenceType#getDisplayName <em>Display Name</em>}</li>
 * </ul>
 * </p>
 *
 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getCatentryReferenceType()
 * @generated
 */
public interface CatentryReferenceType {
	/**
	 * Returns the value of the '<em><b>Catalog Entry Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 						The catalog entry bound with the association.
	 * 					
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Catalog Entry Identifier</em>' containment reference.
	 * @see #setCatalogEntryIdentifier(CatalogEntryIdentifierType)
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getCatentryReferenceType_CatalogEntryIdentifier()
	 * @generated
	 */
	CatalogEntryIdentifierType getCatalogEntryIdentifier();

	/**
	 * Sets the value of the '{@link com.mycompany.commerce.project.facade.datatypes.CatentryReferenceType#getCatalogEntryIdentifier <em>Catalog Entry Identifier</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Catalog Entry Identifier</em>' containment reference.
	 * @see #getCatalogEntryIdentifier()
	 * @generated
	 */
	void setCatalogEntryIdentifier(CatalogEntryIdentifierType value);

	/**
	 * Returns the value of the '<em><b>Store Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 						The identifier of the store associated with the
	 * 						association.
	 * 					
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Store Identifier</em>' containment reference.
	 * @see #setStoreIdentifier(StoreIdentifierType)
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getCatentryReferenceType_StoreIdentifier()
	 * @generated
	 */
	StoreIdentifierType getStoreIdentifier();

	/**
	 * Sets the value of the '{@link com.mycompany.commerce.project.facade.datatypes.CatentryReferenceType#getStoreIdentifier <em>Store Identifier</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Store Identifier</em>' containment reference.
	 * @see #getStoreIdentifier()
	 * @generated
	 */
	void setStoreIdentifier(StoreIdentifierType value);

	/**
	 * Returns the value of the '<em><b>Display Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 						The shortDescription of this catalog entry. It
	 * 						is retrieved by calling the catalog service.
	 * 						This element is not persisted for a Change
	 * 						request. It is read only.
	 * 					
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Display Name</em>' containment reference.
	 * @see #setDisplayName(DescriptionType)
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getCatentryReferenceType_DisplayName()
	 * @generated
	 */
	DescriptionType getDisplayName();

	/**
	 * Sets the value of the '{@link com.mycompany.commerce.project.facade.datatypes.CatentryReferenceType#getDisplayName <em>Display Name</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Display Name</em>' containment reference.
	 * @see #getDisplayName()
	 * @generated
	 */
	void setDisplayName(DescriptionType value);

} // CatentryReferenceType
