package com.mycompany.commerce.project.facade.client;
/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2008
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */
import java.text.MessageFormat;

import com.ibm.commerce.foundation.client.facade.bod.AbstractBusinessObjectDocumentFacadeClient;
import com.ibm.commerce.foundation.client.util.oagis.SelectionCriteriaHelper;
import com.ibm.commerce.foundation.common.datatypes.CommerceFoundationFactory;
import com.ibm.commerce.foundation.common.datatypes.DescriptionType;
import com.mycompany.commerce.project.facade.ProjectFacadeConstants;
import com.mycompany.commerce.project.facade.datatypes.AcknowledgeProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.AcknowledgeProjectType;
import com.mycompany.commerce.project.facade.datatypes.ChangeProjectType;
import com.mycompany.commerce.project.facade.datatypes.GetProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.GetProjectType;
import com.mycompany.commerce.project.facade.datatypes.ProcessProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.ProcessProjectType;
import com.mycompany.commerce.project.facade.datatypes.ProjectCollectionExternalIdentifierType;
import com.mycompany.commerce.project.facade.datatypes.ProjectCollectionIdentifierType;
import com.mycompany.commerce.project.facade.datatypes.ProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.ProjectDescriptionType;
import com.mycompany.commerce.project.facade.datatypes.ProjectDifficultyType;
import com.mycompany.commerce.project.facade.datatypes.ProjectExternalIdentifierType;
import com.mycompany.commerce.project.facade.datatypes.ProjectFactory;
import com.mycompany.commerce.project.facade.datatypes.ProjectIdentifierType;
import com.mycompany.commerce.project.facade.datatypes.ProjectInstructionType;
import com.mycompany.commerce.project.facade.datatypes.ProjectType;
import com.mycompany.commerce.project.facade.datatypes.RespondProjectType;
import com.mycompany.commerce.project.facade.datatypes.ShowProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.ShowProjectType;



/**
 * <p>This class provides common methods that this and other utility class to the Project
 * facade can use.  This class also provides a set of convenient Java API to represent
 * particular Project operations.  This set of Java API also include APIs for Web based requests
 * to transform the name value pair request into the appropriate request documents.</p> 
 */
public class ProjectFacadeClient extends AbstractProjectFacadeClient {


	
	// ==============================================================================
	// Constants for logging and tracing.
	// ==============================================================================

	// uncommnent it when implement the code
	// private static final String CLASSNAME = ProjectFacadeClient.class.getName();
	// private static final java.util.logging.Logger LOGGER = com.ibm.commerce.foundation.common.util.logging.LoggingHelper.getLogger(ProjectFacadeClient.class);	
	
	// ==============================================================================
	// Constructors for the client to the Project facade.
	// ==============================================================================
	
	/**
	 * Creates an instance of the client to communicate with the Project facade.
	 */
	public ProjectFacadeClient() {
		super();
	}
	/**
	 * Creates an instance of the client to communicate with the Project facade.
	 * @param businessContext The default business context to associate with the messages
	 * when making requests.
	 * @param callbackHandler Used for authentication purposes so the controller can give
	 * the authentication information to the transport when required.
	 */
	public ProjectFacadeClient(com.ibm.commerce.foundation.common.datatypes.BusinessContextType businessContext,
			javax.security.auth.callback.CallbackHandler callbackHandler) {
		super(businessContext, callbackHandler);
	}	
	/**
	 * Get All Project Collection noun  And returns show BOD contains
	 * the Project Collection noun
	 * 	
	 * @param accessProfile
	 *            the accessprofile is selected
	 * @return ShowProjectCollectionType the show BOD contains the Project Collection noun
	 */
	public ShowProjectCollectionType getProjectCollectionAll(
			String accessProfile) {

		// construct the verb
		GetProjectCollectionType getProjectCollection = ProjectFactory.eINSTANCE
				.createGetProjectCollectionType();
		getProjectCollection.setDataArea(ProjectFactory.eINSTANCE
				.createGetProjectCollectionDataAreaType());
		getProjectCollection
				.getDataArea()
				.setGet(
						AbstractBusinessObjectDocumentFacadeClient
								.createGetVerb(
										SelectionCriteriaHelper.STR_XPATH_LANG,
										"{"
												+ SelectionCriteriaHelper.STR_ACCESS_PROFILE_PARAMETER
												+ "="
												+ accessProfile
												+ "}"
												+ ProjectFacadeConstants.XPATH_PROJECTCOLLECTION_ALL));

		

		// send the "get" request and get the "show" response
		ShowProjectCollectionType showProjectCollection = getProjectCollection(getProjectCollection);	

		return showProjectCollection;
	}
	/**
	 * Get a Project noun by providing  project colleciton unique id And returns show BOD contains
	 * the Project noun
	 * 
	 * @param prjcolUID
	 *            an unique id of the project collection
	 * @param accessProfile
	 *            the accessprofile is selected
	 * @return ShowProjectType the show BOD contains the Project noun
	 */
	public ShowProjectType getProjectByPrjcolUID(String prjcolUID,
			String accessProfile) {

		// construct the verb
		GetProjectType getProject = ProjectFactory.eINSTANCE
				.createGetProjectType();
		getProject.setDataArea(ProjectFactory.eINSTANCE
				.createGetProjectDataAreaType());
		getProject
				.getDataArea()
				.setGet(
						AbstractBusinessObjectDocumentFacadeClient
								.createGetVerb(
										SelectionCriteriaHelper.STR_XPATH_LANG,
										"{"
												+ SelectionCriteriaHelper.STR_ACCESS_PROFILE_PARAMETER
												+ "="
												+ accessProfile
												+ "}"
												+ MessageFormat
														.format(
																ProjectFacadeConstants.XPATH_PROJECT_PRJCOL_UID,
																new String[] { prjcolUID })));

		

		// send the "get" request and get the "show" response
		ShowProjectType showProject = getProject(getProject);
		
		return showProject;
	}
	/**
	 * Get a Project noun by providing project name id And returns show BOD contains
	 * the Project noun
	 * 
	 * @param name
	 *            name of the project
	 * @param accessProfile
	 *            the accessprofile is selected
	 * @return ShowProjectType the show BOD contains the Project noun
	 */
	public ShowProjectType getProjectByName(String name, String accessProfile) {

		// construct the verb
		GetProjectType getProject = ProjectFactory.eINSTANCE
				.createGetProjectType();
		getProject.setDataArea(ProjectFactory.eINSTANCE
				.createGetProjectDataAreaType());
		getProject
				.getDataArea()
				.setGet(
						AbstractBusinessObjectDocumentFacadeClient
								.createGetVerb(
										SelectionCriteriaHelper.STR_XPATH_LANG,
										"{"
												+ SelectionCriteriaHelper.STR_ACCESS_PROFILE_PARAMETER
												+ "="
												+ accessProfile
												+ "}"
												+ "/Project[search(contains(ProjectIdentifier/ExternalIdentifier/Name,'"
												+ name + "'))]"));

		

		// send the "get" request and get the "show" response
		ShowProjectType showProject = getProject(getProject);

		

		return showProject;
	}
	/**
	 * Get a Project noun by providing  catentry unique id And returns show BOD contains
	 * the Project noun
	 * 
	 * @param catentryUID
	 *            an unique id of the catentry
	 * @param accessProfile
	 *            the accessprofile is selected
	 * @return ShowProjectType the show BOD contains the Project noun
	 */
	public ShowProjectType getProjectByCatentryUID(String catentryUID,
			String accessProfile) {

		// construct the verb
		GetProjectType getProject = ProjectFactory.eINSTANCE
				.createGetProjectType();
		getProject.setDataArea(ProjectFactory.eINSTANCE
				.createGetProjectDataAreaType());
		getProject
				.getDataArea()
				.setGet(
						AbstractBusinessObjectDocumentFacadeClient
								.createGetVerb(
										SelectionCriteriaHelper.STR_XPATH_LANG,
										"{"
												+ SelectionCriteriaHelper.STR_ACCESS_PROFILE_PARAMETER
												+ "="
												+ accessProfile
												+ "}"
												+ MessageFormat
														.format(
																ProjectFacadeConstants.XPATH_PROJECT_CATENTRY_UID,
																new String[] { catentryUID })));

		

		// send the "get" request and get the "show" response
		ShowProjectType showProject = getProject(getProject);
		

		return showProject;
	}
	/**
	 * Get a Project noun by providing  unique id And returns show BOD contains
	 * the Project noun
	 * 
	 * @param projectUID
	 *            an unique id of the project
	 * @param accessProfile
	 *            the accessprofile is selected
	 * @return ShowProjectType the show BOD contains the Project noun
	 */
	public ShowProjectType getProjectByUID(String projectUID,
			String accessProfile) {

		// construct the verb
		GetProjectType getProject = ProjectFactory.eINSTANCE
				.createGetProjectType();
		getProject.setDataArea(ProjectFactory.eINSTANCE
				.createGetProjectDataAreaType());
		getProject
				.getDataArea()
				.setGet(
						AbstractBusinessObjectDocumentFacadeClient
								.createGetVerb(
										SelectionCriteriaHelper.STR_XPATH_LANG,
										"{"
												+ SelectionCriteriaHelper.STR_ACCESS_PROFILE_PARAMETER
												+ "="
												+ accessProfile
												+ "}"
												+ MessageFormat
														.format(
																ProjectFacadeConstants.XPATH_PROJECT_IDEXPRESSION,
																new String[] { projectUID })));

		
		// send the "get" request and get the "show" response
		ShowProjectType showProject = getProject(getProject);

		

		return showProject;
	}

	/**
	 * Create a new Project noun by providing name and description And returns
	 * an acknowledge BOD
	 * 
	 * @param projectName
	 *            the name of the noun Project
	 * @param description
	 *            the description of the noun Project
	 * @return AcknowledgeProjectType the acknowledge BOD after creating a
	 *         Project noun
	 */
	public AcknowledgeProjectType createProject(String projectName,
			String description) {
		ProcessProjectType processProject = ProjectFactory.eINSTANCE
				.createProcessProjectType();
		processProject.setDataArea(ProjectFactory.eINSTANCE
				.createProcessProjectDataAreaType());

		// Create the action and XPath
		java.util.List actions = new java.util.ArrayList();
		actions
				.add(AbstractBusinessObjectDocumentFacadeClient
						.createActionExpression(
								ProjectFacadeConstants.PROCESS_VERB_ACTION_CREATE_PROJECT,
								SelectionCriteriaHelper.STR_XPATH_LANG,
								ProjectFacadeConstants.XPATH_PROJECT + "1"
										+ ProjectFacadeConstants.CLOSE_XPATH));
		com.ibm.commerce.oagis9.datatypes.ProcessType processVerb = AbstractBusinessObjectDocumentFacadeClient
				.createProcessVerb(actions);
		processProject.getDataArea().setProcess(processVerb);

		// Create the noun
		ProjectType project = ProjectFactory.eINSTANCE.createProjectType();
		//	Add new noun into the BOD
		processProject.getDataArea().getProject().add(project);
		// Insert projectname
		ProjectExternalIdentifierType projectExID = ProjectFactory.eINSTANCE
				.createProjectExternalIdentifierType();
		projectExID.setName(projectName);
	
		ProjectIdentifierType projectID = ProjectFactory.eINSTANCE
				.createProjectIdentifierType();
		projectID.setExternalIdentifier(projectExID);
		project.setProjectIdentifier(projectID);

		// insert the description
		//project.setDescription(description);

		ProjectDescriptionType projectDesc = ProjectFactory.eINSTANCE
				.createProjectDescriptionType();
		projectDesc.setLanguage("-1");
		projectDesc.setLongDescription(description);		
		projectDesc.setShortDescription(description);

		
		project.getDescription().add(projectDesc);

		//	insert prjins

		for (int i = 0; i < 5; i++) {

			ProjectInstructionType projectIns = ProjectFactory.eINSTANCE
					.createProjectInstructionType();
			projectIns.setDisplaySequence(i);
			project.getInstruction().add(projectIns);

			DescriptionType desc = CommerceFoundationFactory.eINSTANCE
					.createDescriptionType();
			desc.setLanguage("-1");
			desc.setValue(description + i);
			projectIns.getProjectInstructionDescription().add(desc);
		}
		

		// =========================
		// Send the BOD request
		// =========================

		// Send the request
		AcknowledgeProjectType acknowledgeProject = processProject(processProject);		

		return acknowledgeProject;

	}
	/**
	 * Change a Project noun by providing external id (name) And returns a
	 * repond BOD contains the Project noun
	 * 
	 * @param uid
	 *            an unique id of the noun Project
	 * @param name
	 *            an external id(name) of the noun Project
	 * @return RespondProject the respond BOD contains the Project noun
	 */
	public RespondProjectType changeProjectName(String uid, String name) {
		ChangeProjectType changeProject = ProjectFactory.eINSTANCE
				.createChangeProjectType();
		changeProject.setDataArea(ProjectFactory.eINSTANCE
				.createChangeProjectDataAreaType());

		// create the verb
		java.util.List actions = new java.util.ArrayList();
		actions
				.add(AbstractBusinessObjectDocumentFacadeClient
						.createActionExpression(
								AbstractBusinessObjectDocumentFacadeClient.CHANGE_VERB_ACTION_CHANGE,
								SelectionCriteriaHelper.STR_XPATH_LANG,
								MessageFormat
										.format(
												ProjectFacadeConstants.XPATH_CHANGE_PROJECT,
												new String[] { String
														.valueOf(1) })));
		com.ibm.commerce.oagis9.datatypes.ChangeType changeVerb = AbstractBusinessObjectDocumentFacadeClient
				.createChangeVerb(actions);
		changeProject.getDataArea().setChange(changeVerb);

		// create the noun
		ProjectType project = ProjectFactory.eINSTANCE.createProjectType();
		changeProject.getDataArea().getProject().add(project);
		ProjectIdentifierType idType = ProjectFactory.eINSTANCE
				.createProjectIdentifierType();
		project.setProjectIdentifier(idType);

		// set uid
		if (uid != null) {
			idType.setUniqueID(uid);
		}

		// set name
		if (name != null) {
			ProjectExternalIdentifierType extIDType = ProjectFactory.eINSTANCE
					.createProjectExternalIdentifierType();
			idType.setExternalIdentifier(extIDType);
			extIDType.setName(name);
		}

		
		project.setDifficulty(ProjectDifficultyType.DIFFICULT_LITERAL);

		

		// send the request
		RespondProjectType respondProject = changeProject(changeProject);

		

		return respondProject;

	}

	/**
	 * Change a Project noun by providing its description And returns a repond
	 * BOD contains the Project noun
	 * 
	 * @param uid
	 *            an unique id of the noun Project
	 * @param description
	 *            a description of the noun Project
	 * @return RespondProject the respond BOD contains the Project noun
	 */
	public RespondProjectType changeProjectDesc(String uid, String desc) {
		ChangeProjectType changeProject = ProjectFactory.eINSTANCE
				.createChangeProjectType();
		changeProject.setDataArea(ProjectFactory.eINSTANCE
				.createChangeProjectDataAreaType());

		// create the verb
		java.util.List actions = new java.util.ArrayList();
		actions
				.add(AbstractBusinessObjectDocumentFacadeClient
						.createActionExpression(
								AbstractBusinessObjectDocumentFacadeClient.CHANGE_VERB_ACTION_CHANGE,
								SelectionCriteriaHelper.STR_XPATH_LANG,
								MessageFormat
										.format(
												ProjectFacadeConstants.XPATH_CHANGE_PROJECT_DESC,
												new String[] {
														String.valueOf(1),
														String.valueOf(1) })));
		com.ibm.commerce.oagis9.datatypes.ChangeType changeVerb = AbstractBusinessObjectDocumentFacadeClient
				.createChangeVerb(actions);
		changeProject.getDataArea().setChange(changeVerb);

		// create the noun
		ProjectType project = ProjectFactory.eINSTANCE.createProjectType();
		changeProject.getDataArea().getProject().add(project);
		ProjectIdentifierType idType = ProjectFactory.eINSTANCE
				.createProjectIdentifierType();
		project.setProjectIdentifier(idType);

		// set uid
		if (uid != null) {
			idType.setUniqueID(uid);
		}

		// set name
		if (desc != null) {
			ProjectDescriptionType descType = ProjectFactory.eINSTANCE
					.createProjectDescriptionType();
			project.getDescription().add(descType);
			descType.setLanguage("-1");
			descType.setLongDescription(desc);
			descType.setShortDescription(desc);
		}

		

		// send the request
		RespondProjectType respondProject = changeProject(changeProject);

		

		return respondProject;

	}
	/**
	 * Create a new ProjectCollection noun by providing name and description And
	 * returns an acknowledge BOD
	 * 
	 * @param projectcollectionName
	 *            the name of the noun ProjectCollection
	 * @param description
	 *            the description of the noun ProjectCollection
	 * @return AcknowledgeProjectCollectionType the acknowledge BOD after
	 *         creating a ProjectCollection noun
	 */
	public AcknowledgeProjectCollectionType createProjectCollection(
			String projectcollectionName, String description) {
		ProcessProjectCollectionType processProjectCollection = ProjectFactory.eINSTANCE
				.createProcessProjectCollectionType();
		processProjectCollection.setDataArea(ProjectFactory.eINSTANCE
				.createProcessProjectCollectionDataAreaType());

		// Create the action and XPath
		java.util.List actions = new java.util.ArrayList();
		actions
				.add(AbstractBusinessObjectDocumentFacadeClient
						.createActionExpression(
								ProjectFacadeConstants.PROCESS_VERB_ACTION_CREATE_PROJECTCOLLECTION,
								SelectionCriteriaHelper.STR_XPATH_LANG,
								ProjectFacadeConstants.XPATH_PROJECTCOLLECTION
										+ "1"
										+ ProjectFacadeConstants.CLOSE_XPATH));
		com.ibm.commerce.oagis9.datatypes.ProcessType processVerb = AbstractBusinessObjectDocumentFacadeClient
				.createProcessVerb(actions);
		processProjectCollection.getDataArea().setProcess(processVerb);

		// Create the noun
		ProjectCollectionType projectcollection = ProjectFactory.eINSTANCE
				.createProjectCollectionType();

		// Insert projectcollectionname
		ProjectCollectionExternalIdentifierType projectcollectionExID = ProjectFactory.eINSTANCE
				.createProjectCollectionExternalIdentifierType();
		projectcollectionExID.setName(projectcollectionName);
		ProjectCollectionIdentifierType projectcollectionID = ProjectFactory.eINSTANCE
				.createProjectCollectionIdentifierType();
		projectcollectionID.setExternalIdentifier(projectcollectionExID);
		projectcollection.setProjectCollectionIdentifier(projectcollectionID);

		// insert the description

		DescriptionType collectionDesc = CommerceFoundationFactory.eINSTANCE
				.createDescriptionType();
		collectionDesc.setLanguage("-1");
		collectionDesc.setValue(description);
		projectcollection.getDescription().add(collectionDesc);

		// Add new noun into the BOD
		processProjectCollection.getDataArea().getProjectCollection().add(
				projectcollection);

		// =========================
		// Send the BOD request
		// =========================

		

		// Send the request
		AcknowledgeProjectCollectionType acknowledgeProjectCollection = processProjectCollection(processProjectCollection);

		

		return acknowledgeProjectCollection;
	}

}
