package com.mycompany.commerce.project.facade;
/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2008
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */
/**
 * This class defines the constants used to interact with the Project facade.
 */
public class ProjectFacadeConstants {

	// ==========================================================================================
	// The following is global constants names associated with the component.
	// ==========================================================================================
	/**
	 * The component name for the Project component.
	 */
	public static final String COMPONENT_NAME = "com.mycompany.commerce.project";

	// ==========================================================================================
	// The following is a predefined set of access profiles provided by the component.
	// ==========================================================================================
	/**
	 * This constants represents an admin access profile that returns detail
	 * information about the noun.  This includes most of the
	 * information associated with the specified noun.
	 */
	public static final String ACCESS_PROFILE_ADMIN_DETAILS_INFORMATION = "MyCompany_Admin_Details";

	/**
	 * This constants represents an admin access profile that returns summary
	 * information about the noun being returned.  This includes enough
	 * information to display a list of nouns and does not include much
	 * detail about that noun.
	 */
	public static final String ACCESS_PROFILE_ADMIN_SUMMARY_INFORMATION = "MyCompany_Admin_Summary";
	/**
	 * This constants represents an store access profile that returns detail
	 * information about the noun.  This includes most of the
	 * information associated with the specified noun.
	 */
	public static final String ACCESS_PROFILE_STORE_DETAILS_INFORMATION = "MyCompany_Store_Details";
	/**
	 * This constants represents an store access profile that returns summary
	 * information about the noun being returned.  This includes enough
	 * information to display a list of nouns and does not include much
	 * detail about that noun.
	 */
	public static final String ACCESS_PROFILE_STORE_SUMMARY_INFORMATION = "MyCompany_Store_Summary";
	/**
	 * This constants represents an admin access profile that returns material
	 * information about the noun.  
	 */	
	public static final String ACCESS_PROFILE_ADMIN_PRJMTR = "MyCompany_Admin_ProjectMaterial";
	/**
	 * This constants represents an admin access profile that returns instruction
	 * information about the noun.  
	 */	
	public static final String ACCESS_PROFILE_ADMIN_PRJINS = "MyCompany_Admin_ProjectInstruction";
	/**
	 * This constants represents an admin access profile that returns collection relationship
	 * information about the noun.  
	 */	
	public static final String ACCESS_PROFILE_ADMIN_PRJCOLREL = "MyCompany_Admin_ProjectColRel";
	/**
	 * This constants represents an admin access profile that returns tool
	 * information about the noun.  
	 */	
	public static final String ACCESS_PROFILE_ADMIN_PRJTOOL = "MyCompany_Admin_ProjectTool";

	/**
	 * This constants if the default access profile when one is not specified.
	 * The default access profile is the summary access profile.
	 */
	public static final String ACCESS_PROFILE_DEFAULT = ACCESS_PROFILE_ADMIN_SUMMARY_INFORMATION;

	/**
	 * Access profile for updating a noun
	 */
	public static final String ACCESS_PROFILE_UPDATE = "MyCompany_Project_Update";

	/**
	 * Access profile for resolving a noun's ID 
	 */
	public static final String ACCESS_PROFILE_ID_RESOLVE = "MyCompany_IdResolve";

	

	// ==========================================================================================
	// The following is a predefined set of XPATH provided by the component.
	// ==========================================================================================	

	/**
	 * The constanst for closing the <code>Xpath</code> with a backet.
	 */
	public static final String CLOSE_XPATH = "]";

	/**
	 * The constanst for closing the <code>Xpath</code> with 2 backets.
	 */
	public static final String DOUBLE_CLOSE_XPATH = "";

	/**
	 * The attribute name of UID in noun Project.
	 */
	public static final String NOUN_ATTRIBUTE_NAME_PROJECT_UID = "UniqueID";
	/**
	 * The <code>Xpath</code> of Project with catentry UID.
	 */
	public static final String XPATH_PROJECT_CATENTRY_UID = "/Project[Material[CatalogEntry[CatalogEntryIdentifier[("
			+ NOUN_ATTRIBUTE_NAME_PROJECT_UID + "={0})]]]]";

	/**
	 * The <code>Xpath</code> of Project with UID.
	 */
	public static final String XPATH_PROJECT_UID = "/Project[ProjectIdentifier[("
			+ NOUN_ATTRIBUTE_NAME_PROJECT_UID + "=)]]";
	/**
	 * The <code>Xpath</code> of Project with UID.
	 */
	public static final String XPATH_PROJECT_IDEXPRESSION = "/Project[ProjectIdentifier[("
			+ NOUN_ATTRIBUTE_NAME_PROJECT_UID + "={0})]]";
	/**
	 * The <code>Xpath</code> of Project with collection UID.
	 */
	public static final String XPATH_PROJECT_PRJCOL_UID = "/Project[Collection[ProjectCollectionIdentifier[("
			+ NOUN_ATTRIBUTE_NAME_PROJECT_UID + "={0})]]]";
	/**
	 * The <code>Xpath</code> of Project with material UID.
	 */
	public static final String XPATH_PROJECT_MATERIAL_UID = "/Project[Material[ProjectMaterialIdentifier[("
		+ NOUN_ATTRIBUTE_NAME_PROJECT_UID + "=)]]]";
	/**
	 * The <code>Xpath</code> of Project with instruction  UID.
	 */
	public static final String XPATH_PROJECT_INSTRUCTION_UID = "/Project[Instruction[("
		+ NOUN_ATTRIBUTE_NAME_PROJECT_UID + "=)]]";
	/**
	 * The attribute name of Name in noun Project.
	 */
	public static final String NOUN_ATTRIBUTE_NAME_PROJECT_NAME = "Name";

	/**
	 * The <code>Xpath</code> of Project with Name.
	 */
	public static final String XPATH_PROJECT_NAME = "/Project[ProjectIdentifier[ExternalIdentifier[("
			+ NOUN_ATTRIBUTE_NAME_PROJECT_NAME + "=)]]]";

	/**
	 * The <code>Xpath</code> of Project .
	 */
	public static final String XPATH_PROJECT = "/Project[";

	/**
	 * The attribute name of UID in noun ProjectCollection.
	 */
	public static final String NOUN_ATTRIBUTE_NAME_PROJECTCOLLECTION_UID = "UniqueID";

	/**
	 * The <code>Xpath</code> of ProjectCollection with UID.
	 */
	public static final String XPATH_PROJECTCOLLECTION_UID = "/ProjectCollection[ProjectCollectionIdentifier[("
			+ NOUN_ATTRIBUTE_NAME_PROJECTCOLLECTION_UID + "=)]]";

	/**
	 * The attribute name of Name in noun ProjectCollection.
	 */
	public static final String NOUN_ATTRIBUTE_NAME_PROJECTCOLLECTION_NAME = "Name";

	/**
	 * The <code>Xpath</code> of ProjectCollection with Name.
	 */
	public static final String XPATH_PROJECTCOLLECTION_NAME = "/ProjectCollection[ProjectCollectionIdentifier[ExternalIdentifier[("
			+ NOUN_ATTRIBUTE_NAME_PROJECTCOLLECTION_NAME + "=)]]]";

	/**
	 * The <code>Xpath</code> of ProjectCollection .
	 */
	public static final String XPATH_PROJECTCOLLECTION = "/ProjectCollection[";
	/**
	 * The <code>Xpath</code> of Get All ProjectCollection.
	 */
	public static final String XPATH_PROJECTCOLLECTION_ALL = "/ProjectCollection";

	

	// ==========================================================================================
	// The following is a list of actions that can be used for the process request.
	// ==========================================================================================

	/**
	 * Constant for the Process Create action on Project
	 */
	public static final String PROCESS_VERB_ACTION_CREATE_PROJECT = "Create";

	/**
	 * Constant for the Process Delete action on Project
	 */
	public static final String PROCESS_VERB_ACTION_DELETE_PROJECT = "Delete";

	/**
	 * Constant for the Process Create action on ProjectCollection
	 */
	public static final String PROCESS_VERB_ACTION_CREATE_PROJECTCOLLECTION = "Create";

	/**
	 * Constant for the Process Delete action on ProjectCollection
	 */
	public static final String PROCESS_VERB_ACTION_DELETE_PROJECTCOLLECTION = "Delete";
	

	/**
	 * The XPath key to update the Project.
	 */
	public static String XPATH_CHANGE_PROJECT = "/Project[{0}]";
	/**
	 * The XPath key to update the Project Description.
	 */
	public static String XPATH_CHANGE_PROJECT_DESC = "/Project[{0}]/Description[{1}]";
	/**
	 * The XPath key to update the Project Collection .
	 */
	public static String XPATH_CHANGE_PROJECTCOLLECTION = "/ProjectCollection[{0}]";
	/**
	 * The XPath key to update the Project Collection Description.
	 */
	public static String XPATH_CHANGE_PROJECTCOLLECTION_DESC = "/ProjectCollection[{0}]/Description[{1}]";

	

	

	

}
