package com.mycompany.commerce.project.facade;
 
import com.mycompany.commerce.project.facade.datatypes.AcknowledgeProjectType;
import com.mycompany.commerce.project.facade.datatypes.ChangeProjectType;
import com.mycompany.commerce.project.facade.datatypes.GetProjectType;
import com.mycompany.commerce.project.facade.datatypes.ProcessProjectType;
import com.mycompany.commerce.project.facade.datatypes.RespondProjectType;
import com.mycompany.commerce.project.facade.datatypes.ShowProjectType;


/**
 * The facade for the Project noun.
 */
public interface ProjectFacade {

	
	/**
	 * This method will communicate with the Project facade and send the specified
	 * GetProject request.
	 * @param aGetProject The GetProject request document.
	 * @return The resulting ShowProject response document.
	 */
	public ShowProjectType 
			getProject(GetProjectType aGetProject);
	
	/**
	 * This method will communicate with the Project facade and send the specified
	 * ProcessProject request.
	 * @param aProcessProject The ProcessProject request document.
	 * @return The resulting AcknowledgeProject response document.
	 */
	public AcknowledgeProjectType 
			processProject(ProcessProjectType aProcessProject);
	
	/**
	 * This method will communicate with the Project facade and send the specified
	 * ChangeProject request.
	 * @param aChangeProject The ProcessProject request document.
	 * @return The resulting RespondProject response document.
	 */
	public RespondProjectType 
			changeProject(ChangeProjectType aChangeProject);
		
}
