package com.mycompany.commerce.project.facade;
 
import com.mycompany.commerce.project.facade.datatypes.AcknowledgeProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.ChangeProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.GetProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.ProcessProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.RespondProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.ShowProjectCollectionType;


/**
 * The facade for the ProjectCollection noun.
 */
public interface ProjectCollectionFacade {

	
	/**
	 * This method will communicate with the ProjectCollection facade and send the specified
	 * GetProjectCollection request.
	 * @param aGetProjectCollection The GetProjectCollection request document.
	 * @return The resulting ShowProjectCollection response document.
	 */
	public ShowProjectCollectionType 
			getProjectCollection(GetProjectCollectionType aGetProjectCollection);
	
	/**
	 * This method will communicate with the ProjectCollection facade and send the specified
	 * ProcessProjectCollection request.
	 * @param aProcessProjectCollection The ProcessProjectCollection request document.
	 * @return The resulting AcknowledgeProjectCollection response document.
	 */
	public AcknowledgeProjectCollectionType 
			processProjectCollection(ProcessProjectCollectionType aProcessProjectCollection);
	
	/**
	 * This method will communicate with the ProjectCollection facade and send the specified
	 * ChangeProjectCollection request.
	 * @param aChangeProjectCollection The ProcessProjectCollection request document.
	 * @return The resulting RespondProjectCollection response document.
	 */
	public RespondProjectCollectionType 
			changeProjectCollection(ChangeProjectCollectionType aChangeProjectCollection);
		
}
