package com.mycompany.commerce.project.facade.server.commands;

/**
 * This is the interface for the Get ProjectCollection web service command. This interface is to be implemented by the class
 * that provides the ProjectCollection get service. This interface defines a method to set the <code>GetProjectCollectionType</code>
 * object which contains the xpath request. It also defines a method to get the <code>ShowProjectCollectionType</code> object
 * which contains the information used to compose the show business object document.
 */
public interface GetProjectCollectionCmd extends com.ibm.commerce.foundation.server.command.bod.BusinessObjectDocumentCmd {

	
	/**
	 * This method sets the <code>GetProjectCollectionType</code> business object document that this command will process.
	 * @param getProjectCollection The <code>GetProjectCollectionType</code> business object document.
	 */
	public void setGetProjectCollection(com.mycompany.commerce.project.facade.datatypes.GetProjectCollectionType getProjectCollection);

	/**
	 * This method gets the <code>ShowProjectCollectionType</code> business object document result.
	 * @return This method returns the <code>ShowProjectCollectionType</code> business object document result to the client.
	 */
	public com.mycompany.commerce.project.facade.datatypes.ShowProjectCollectionType getShowProjectCollection();
}
