package com.mycompany.commerce.project.facade.server;
 
import com.mycompany.commerce.project.facade.ProjectFacadeConstants;
import com.ibm.commerce.foundation.server.command.bod.BusinessObjectDocumentProcessor;

	
import com.mycompany.commerce.project.facade.datatypes.ShowProjectType;
import com.mycompany.commerce.project.facade.datatypes.GetProjectType;

import com.mycompany.commerce.project.facade.datatypes.RespondProjectType;
import com.mycompany.commerce.project.facade.datatypes.ChangeProjectType;

import com.mycompany.commerce.project.facade.datatypes.AcknowledgeProjectType;
import com.mycompany.commerce.project.facade.datatypes.ProcessProjectType;


	
import com.mycompany.commerce.project.facade.datatypes.ShowProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.GetProjectCollectionType;

import com.mycompany.commerce.project.facade.datatypes.RespondProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.ChangeProjectCollectionType;

import com.mycompany.commerce.project.facade.datatypes.AcknowledgeProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.ProcessProjectCollectionType;


import com.ibm.commerce.oagis9.datatypes.ConfirmBODType;
	
/**
 * Bean implementation class for Enterprise Bean: Project
 */
public class ProjectFacadeImpl implements ProjectFacade {
	
	
	
	/**
	 * @param type
	 * @return ShowProjectType
	 */
	public ShowProjectType 
			getProject(GetProjectType type) {
		return (ShowProjectType) BusinessObjectDocumentProcessor.getInstance()
					.processBusinessObjectDocument(type, ProjectFacadeConstants.COMPONENT_NAME);

	}
	
	/**
	 * @param type
	 * @return RespondProjectType
	 */
	public RespondProjectType 
			changeProject(ChangeProjectType type) {
		return (RespondProjectType) BusinessObjectDocumentProcessor.getInstance()
					.processBusinessObjectDocument(type, ProjectFacadeConstants.COMPONENT_NAME);

	}
	
	/**
	 * @param type
	 * @return AcknowledgeProjectType
	 */
	public AcknowledgeProjectType 
			processProject(ProcessProjectType type) {
		return (AcknowledgeProjectType) BusinessObjectDocumentProcessor.getInstance()
					.processBusinessObjectDocument(type, ProjectFacadeConstants.COMPONENT_NAME);
	}
	
	
	
	/**
	 * @param type
	 * @return ShowProjectCollectionType
	 */
	public ShowProjectCollectionType 
			getProjectCollection(GetProjectCollectionType type) {
		return (ShowProjectCollectionType) BusinessObjectDocumentProcessor.getInstance()
					.processBusinessObjectDocument(type, ProjectFacadeConstants.COMPONENT_NAME);

	}
	
	/**
	 * @param type
	 * @return RespondProjectCollectionType
	 */
	public RespondProjectCollectionType 
			changeProjectCollection(ChangeProjectCollectionType type) {
		return (RespondProjectCollectionType) BusinessObjectDocumentProcessor.getInstance()
					.processBusinessObjectDocument(type, ProjectFacadeConstants.COMPONENT_NAME);

	}
	
	/**
	 * @param type
	 * @return AcknowledgeProjectCollectionType
	 */
	public AcknowledgeProjectCollectionType 
			processProjectCollection(ProcessProjectCollectionType type) {
		return (AcknowledgeProjectCollectionType) BusinessObjectDocumentProcessor.getInstance()
					.processBusinessObjectDocument(type, ProjectFacadeConstants.COMPONENT_NAME);
	}
	
	
}
