/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package com.mycompany.commerce.project.facade.datatypes.impl;

import com.ibm.commerce.foundation.common.datatypes.DescriptionType;
import com.ibm.commerce.foundation.common.datatypes.UserDataType;

import com.mycompany.commerce.project.facade.datatypes.ProjectInstructionType;
import com.mycompany.commerce.project.facade.datatypes.ProjectPackage;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.sdo.impl.EDataObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Instruction Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.impl.ProjectInstructionTypeImpl#getProjectInstructionDescription <em>Project Instruction Description</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.impl.ProjectInstructionTypeImpl#getUserData <em>User Data</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.impl.ProjectInstructionTypeImpl#getDisplaySequence <em>Display Sequence</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.impl.ProjectInstructionTypeImpl#isOptional <em>Optional</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.impl.ProjectInstructionTypeImpl#getUniqueID <em>Unique ID</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ProjectInstructionTypeImpl extends EDataObjectImpl implements ProjectInstructionType {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * The cached value of the '{@link #getProjectInstructionDescription() <em>Project Instruction Description</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProjectInstructionDescription()
	 * @generated
	 * @ordered
	 */
	protected EList projectInstructionDescription;

	/**
	 * The cached value of the '{@link #getUserData() <em>User Data</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUserData()
	 * @generated
	 * @ordered
	 */
	protected UserDataType userData;

	/**
	 * The default value of the '{@link #getDisplaySequence() <em>Display Sequence</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDisplaySequence()
	 * @generated
	 * @ordered
	 */
	protected static final double DISPLAY_SEQUENCE_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getDisplaySequence() <em>Display Sequence</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDisplaySequence()
	 * @generated
	 * @ordered
	 */
	protected double displaySequence = DISPLAY_SEQUENCE_EDEFAULT;

	/**
	 * This is true if the Display Sequence attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean displaySequenceESet;

	/**
	 * The default value of the '{@link #isOptional() <em>Optional</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isOptional()
	 * @generated
	 * @ordered
	 */
	protected static final boolean OPTIONAL_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isOptional() <em>Optional</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isOptional()
	 * @generated
	 * @ordered
	 */
	protected boolean optional = OPTIONAL_EDEFAULT;

	/**
	 * This is true if the Optional attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean optionalESet;

	/**
	 * The default value of the '{@link #getUniqueID() <em>Unique ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUniqueID()
	 * @generated
	 * @ordered
	 */
	protected static final String UNIQUE_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getUniqueID() <em>Unique ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUniqueID()
	 * @generated
	 * @ordered
	 */
	protected String uniqueID = UNIQUE_ID_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProjectInstructionTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ProjectPackage.Literals.PROJECT_INSTRUCTION_TYPE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getProjectInstructionDescription() {
		if (projectInstructionDescription == null) {
			projectInstructionDescription = new EObjectContainmentEList(DescriptionType.class, this, ProjectPackage.PROJECT_INSTRUCTION_TYPE__PROJECT_INSTRUCTION_DESCRIPTION);
		}
		return projectInstructionDescription;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UserDataType getUserData() {
		return userData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetUserData(UserDataType newUserData, NotificationChain msgs) {
		UserDataType oldUserData = userData;
		userData = newUserData;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ProjectPackage.PROJECT_INSTRUCTION_TYPE__USER_DATA, oldUserData, newUserData);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUserData(UserDataType newUserData) {
		if (newUserData != userData) {
			NotificationChain msgs = null;
			if (userData != null)
				msgs = ((InternalEObject)userData).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ProjectPackage.PROJECT_INSTRUCTION_TYPE__USER_DATA, null, msgs);
			if (newUserData != null)
				msgs = ((InternalEObject)newUserData).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ProjectPackage.PROJECT_INSTRUCTION_TYPE__USER_DATA, null, msgs);
			msgs = basicSetUserData(newUserData, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProjectPackage.PROJECT_INSTRUCTION_TYPE__USER_DATA, newUserData, newUserData));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getDisplaySequence() {
		return displaySequence;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDisplaySequence(double newDisplaySequence) {
		double oldDisplaySequence = displaySequence;
		displaySequence = newDisplaySequence;
		boolean oldDisplaySequenceESet = displaySequenceESet;
		displaySequenceESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProjectPackage.PROJECT_INSTRUCTION_TYPE__DISPLAY_SEQUENCE, oldDisplaySequence, displaySequence, !oldDisplaySequenceESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetDisplaySequence() {
		double oldDisplaySequence = displaySequence;
		boolean oldDisplaySequenceESet = displaySequenceESet;
		displaySequence = DISPLAY_SEQUENCE_EDEFAULT;
		displaySequenceESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, ProjectPackage.PROJECT_INSTRUCTION_TYPE__DISPLAY_SEQUENCE, oldDisplaySequence, DISPLAY_SEQUENCE_EDEFAULT, oldDisplaySequenceESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetDisplaySequence() {
		return displaySequenceESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isOptional() {
		return optional;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOptional(boolean newOptional) {
		boolean oldOptional = optional;
		optional = newOptional;
		boolean oldOptionalESet = optionalESet;
		optionalESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProjectPackage.PROJECT_INSTRUCTION_TYPE__OPTIONAL, oldOptional, optional, !oldOptionalESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetOptional() {
		boolean oldOptional = optional;
		boolean oldOptionalESet = optionalESet;
		optional = OPTIONAL_EDEFAULT;
		optionalESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, ProjectPackage.PROJECT_INSTRUCTION_TYPE__OPTIONAL, oldOptional, OPTIONAL_EDEFAULT, oldOptionalESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetOptional() {
		return optionalESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getUniqueID() {
		return uniqueID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUniqueID(String newUniqueID) {
		String oldUniqueID = uniqueID;
		uniqueID = newUniqueID;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProjectPackage.PROJECT_INSTRUCTION_TYPE__UNIQUE_ID, oldUniqueID, uniqueID));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ProjectPackage.PROJECT_INSTRUCTION_TYPE__PROJECT_INSTRUCTION_DESCRIPTION:
				return ((InternalEList)getProjectInstructionDescription()).basicRemove(otherEnd, msgs);
			case ProjectPackage.PROJECT_INSTRUCTION_TYPE__USER_DATA:
				return basicSetUserData(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ProjectPackage.PROJECT_INSTRUCTION_TYPE__PROJECT_INSTRUCTION_DESCRIPTION:
				return getProjectInstructionDescription();
			case ProjectPackage.PROJECT_INSTRUCTION_TYPE__USER_DATA:
				return getUserData();
			case ProjectPackage.PROJECT_INSTRUCTION_TYPE__DISPLAY_SEQUENCE:
				return new Double(getDisplaySequence());
			case ProjectPackage.PROJECT_INSTRUCTION_TYPE__OPTIONAL:
				return isOptional() ? Boolean.TRUE : Boolean.FALSE;
			case ProjectPackage.PROJECT_INSTRUCTION_TYPE__UNIQUE_ID:
				return getUniqueID();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ProjectPackage.PROJECT_INSTRUCTION_TYPE__PROJECT_INSTRUCTION_DESCRIPTION:
				getProjectInstructionDescription().clear();
				getProjectInstructionDescription().addAll((Collection)newValue);
				return;
			case ProjectPackage.PROJECT_INSTRUCTION_TYPE__USER_DATA:
				setUserData((UserDataType)newValue);
				return;
			case ProjectPackage.PROJECT_INSTRUCTION_TYPE__DISPLAY_SEQUENCE:
				setDisplaySequence(((Double)newValue).doubleValue());
				return;
			case ProjectPackage.PROJECT_INSTRUCTION_TYPE__OPTIONAL:
				setOptional(((Boolean)newValue).booleanValue());
				return;
			case ProjectPackage.PROJECT_INSTRUCTION_TYPE__UNIQUE_ID:
				setUniqueID((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(int featureID) {
		switch (featureID) {
			case ProjectPackage.PROJECT_INSTRUCTION_TYPE__PROJECT_INSTRUCTION_DESCRIPTION:
				getProjectInstructionDescription().clear();
				return;
			case ProjectPackage.PROJECT_INSTRUCTION_TYPE__USER_DATA:
				setUserData((UserDataType)null);
				return;
			case ProjectPackage.PROJECT_INSTRUCTION_TYPE__DISPLAY_SEQUENCE:
				unsetDisplaySequence();
				return;
			case ProjectPackage.PROJECT_INSTRUCTION_TYPE__OPTIONAL:
				unsetOptional();
				return;
			case ProjectPackage.PROJECT_INSTRUCTION_TYPE__UNIQUE_ID:
				setUniqueID(UNIQUE_ID_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ProjectPackage.PROJECT_INSTRUCTION_TYPE__PROJECT_INSTRUCTION_DESCRIPTION:
				return projectInstructionDescription != null && !projectInstructionDescription.isEmpty();
			case ProjectPackage.PROJECT_INSTRUCTION_TYPE__USER_DATA:
				return userData != null;
			case ProjectPackage.PROJECT_INSTRUCTION_TYPE__DISPLAY_SEQUENCE:
				return isSetDisplaySequence();
			case ProjectPackage.PROJECT_INSTRUCTION_TYPE__OPTIONAL:
				return isSetOptional();
			case ProjectPackage.PROJECT_INSTRUCTION_TYPE__UNIQUE_ID:
				return UNIQUE_ID_EDEFAULT == null ? uniqueID != null : !UNIQUE_ID_EDEFAULT.equals(uniqueID);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (displaySequence: ");
		if (displaySequenceESet) result.append(displaySequence); else result.append("<unset>");
		result.append(", optional: ");
		if (optionalESet) result.append(optional); else result.append("<unset>");
		result.append(", uniqueID: ");
		result.append(uniqueID);
		result.append(')');
		return result.toString();
	}

} //ProjectInstructionTypeImpl
