<!-- TODO: This is a sample query template file. -->
<!-- Please modify to match your implementation. -->

BEGIN_SYMBOL_DEFINITIONS
	
	<!-- The table for noun Project  -->
		<!-- Defining all columns of the table -->
		COLS:PROJECT = PROJECT:* 	
		<!-- Defining the unique ID column of the table -->
		COLS:PROJECT_ID = PROJECT:PROJECT_ID
		<!-- Defining the name column of the table -->
		COLS:PROJECT_NAME = PROJECT:PROJECT_NAME
		<!-- Defining the description column of the table -->
		COLS:PROJECT_DESC = PROJECT:PROJECT_DESC
		
END_SYMBOL_DEFINITIONS

<!-- ================================================================================== -->
<!-- XPath: /Project/ProjectIdentifier[(UniqueID=)] -->
<!-- AccessProfile:	myCompany_All -->
<!-- Get the all information for Project with specified unique ID. -->
<!-- All access profile includes all columns from the table. -->
<!-- @param UniqueID  Unique ID of Project to retrieve. -->   
<!-- ================================================================================== -->

BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project/ProjectIdentifier[(UniqueID=)]+myCompany_All
	base_table=PROJECT
	sql=	
		SELECT 
	     				PROJECT.$COLS:PROJECT  	     				
	     	FROM
	     				PROJECT
	     	WHERE
						PROJECT.PROJECT_ID = ?UniqueID? 

END_XPATH_TO_SQL_STATEMENT

<!-- ================================================================================== -->
<!-- XPath: /Project/ProjectIdentifier[(UniqueID=)] -->
<!-- AccessProfile:	myCompany_Details -->
<!-- Get the detail information for Project with the specfified unique ID. -->
<!-- Details access profile includes the unique ID and external name. -->
<!-- @param UniqueID  Unique ID of Project to retrieve. -->   
<!-- ================================================================================== -->

BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project/ProjectIdentifier[(UniqueID=)]+myCompany_Details
	base_table=PROJECT
	sql=	
		SELECT 
	     				PROJECT.$COLS:PROJECT_ID$,  
	     				PROJECT.$COLS:PROJECT_NAME$
	     	FROM
	     				PROJECT
	     	WHERE
						PROJECT.PROJECT_ID = ?UniqueID? 

END_XPATH_TO_SQL_STATEMENT

<!-- ================================================================================== -->
<!-- XPath: /Project/ProjectIdentifier[(UniqueID=)] -->
<!-- AccessProfile:	myCompany_Summary -->
<!-- Get the summary information for Project with the specified unique ID. -->
<!-- Summary access profile includes the unique ID. -->
<!-- @param UniqueID  Unique ID of Project to retrieve. -->   
<!-- ================================================================================== -->

BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project/ProjectIdentifier[(UniqueID=)]+myCompany_Summary
	base_table=PROJECT
	sql=	
		SELECT 
	     				PROJECT.$COLS:PROJECT_ID$ 
	     	FROM
	     				PROJECT
	     	WHERE
						PROJECT.PROJECT_ID = ?UniqueID? 

END_XPATH_TO_SQL_STATEMENT


<!-- ================================================================================== -->
<!-- XPath: /Project/ProjectIdentifier/ExternalIdentifier[(Name=)] -->
<!-- AccessProfile:	myCompany_All -->
<!-- Get all information for Project with the specfified external ID (name) -->
<!-- All access profile includes all columns in the table. -->
<!-- @param Name  Name (External ID) of Project to retrieve.	-->   
<!-- ================================================================================== -->

BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project/ProjectIdentifier/ExternalIdentifier[(Name=)]+myCompany_All
	base_table=PROJECT
	sql=	
		SELECT 
	     				PROJECT.$COLS:PROJECT
	     	FROM
	     				PROJECT
	     	WHERE
						PROJECT.PROJECT_NAME = ?Name?

END_XPATH_TO_SQL_STATEMENT

<!-- ================================================================================== -->
<!-- XPath: /Project/ProjectIdentifier/ExternalIdentifier[(Name=)] -->
<!-- AccessProfile:	myCompany_Details -->
<!-- Get the details information for Project with the specfified external ID (name). -->
<!-- Detail access profile includes the unique ID and name. -->
<!-- @param Name  Name (External ID) of Project to retrieve. --> 
<!-- ================================================================================== -->

BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project/ProjectIdentifier/ExternalIdentifier[(Name=)]+myCompany_Details
	base_table=PROJECT
	sql=	
		SELECT 
	     				PROJECT.$COLS:PROJECT_ID$,
	     				PROJECT.$COLS:PROJECT_NAME$
	     	FROM
	     				PROJECT
	     	WHERE
						PROJECT.PROJECT_NAME = ?Name?

END_XPATH_TO_SQL_STATEMENT

<!-- ================================================================================== -->
<!-- XPath: /Project/ProjectIdentifier/ExternalIdentifier[(Name=)] -->
<!-- AccessProfile:	myCompany_Summary -->
<!-- Get the summary information for Project with specfified external ID (name). -->
<!-- Summary access profile includes the unique ID. -->
<!-- @param Name  Name (External ID) of Project to retrieve. --> 
<!-- ================================================================================== -->

BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project/ProjectIdentifier/ExternalIdentifier[(Name=)]+myCompany_Summary
	base_table=PROJECT
	sql=	
		SELECT 
	     				PROJECT.$COLS:PROJECT_ID$	     				
	     	FROM
	     				PROJECT
	     	WHERE
						PROJECT.PROJECT_NAME = ?Name?

END_XPATH_TO_SQL_STATEMENT