package com.ibm.commerce.sample.handler;

import java.util.logging.Logger;

import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

/*
 *--------------------------------------------------------------------------------------
 * The sample contained herein is provided to you "AS IS".
 *
 * It is furnished by IBM as a simple example and has not been thoroughly tested
 * under all conditions.  IBM, therefore, cannot guarantee its reliability, 
 * serviceability or functionality.
 *
 * This sample may include the names of individuals, companies, brands and products 
 * in order to illustrate concepts as completely as possible.  All of these names
 * are fictitious and any similarity to the names and addresses used by actual persons 
 * or business enterprises is entirely coincidental.
 *--------------------------------------------------------------------------------------
 */

import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.rest.classic.core.AbstractConfigBasedClassicHandler;

/**
 * This is an auto-generated sample REST handler for
 * 'com.ibm.commerce.sample.commands.ContactUpdateCmd'.
 */
@Path("store/{storeId}/project")
public class ProjectHandler extends AbstractConfigBasedClassicHandler {
	private static final String CLASSNAME = ProjectHandler.class.getName();

	private static final Logger LOGGER = LoggingHelper.getLogger(CLASSNAME);

	private static final String RESOURCE_NAME = "contact";

	@Override
	public String getResourceName() {
		return RESOURCE_NAME;
	}
	@GET
	@Path("{xproject_id}")
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML, MediaType.APPLICATION_XHTML_XML,
			MediaType.APPLICATION_ATOM_XML })
	public Response processGetRequest(@QueryParam("responseFormat") String responseFormat,
			@PathParam("storeId") String storeId, @PathParam("xproject_id") String contactId) {
		// Set up trace facilities
		final String METHODNAME = "processGetRequest(String responseFormat, String storeId, ...)";
		final boolean traceEnabled = LoggingHelper.isTraceEnabled(LOGGER);
		final boolean entryExitTraceEnabled = LoggingHelper.isEntryExitTraceEnabled(LOGGER);
		if (entryExitTraceEnabled) {
			Object[] parameters = new Object[] { responseFormat, storeId };
			LOGGER.entering(CLASSNAME, METHODNAME, parameters);
		}
		/**
		 * Use the configuration-based REST API to automatically fill in input
		 * values, execute, and build the response.
		 */
		Response result = executeConfigBasedBeanWithContext("com.ibm.commerce.sample.beans.ProjectDataBean", "sample",
				responseFormat, null);
		// Log method exit
		if (entryExitTraceEnabled) {
			LOGGER.exiting(CLASSNAME, METHODNAME, result);
		}

		return result;
	}
	@PUT
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML, MediaType.APPLICATION_XHTML_XML,
			MediaType.APPLICATION_ATOM_XML })
	public Response processPutRequest(@QueryParam("responseFormat") String responseFormat,
			@PathParam("storeId") String storeId,@QueryParam("xproject_id") String xproject_id, @QueryParam("prjname") String prjname) {
		// Set up trace facilities
		final String METHODNAME = "processPostRequest(String responseFormat, String storeId, ...)";
		final boolean traceEnabled = LoggingHelper.isTraceEnabled(LOGGER);
		final boolean entryExitTraceEnabled = LoggingHelper.isEntryExitTraceEnabled(LOGGER);
		if (entryExitTraceEnabled) {
			Object[] parameters = new Object[] { responseFormat, storeId };
			LOGGER.entering(CLASSNAME, METHODNAME, parameters);
		}

		/**
		 * Use the configuration-based REST API to automatically fill in input
		 * values, execute, and build the response.
		 */
		Response result = executeConfigBasedCommandWithContext("com.ibm.commerce.sample.commands.ProjectUpdateCmd",
				"sample", responseFormat, storeId, null);

		// Log method exit
		if (entryExitTraceEnabled) {
			LOGGER.exiting(CLASSNAME, METHODNAME, result);
		}

		return result;
	}
}
