package com.ibm.commerce.sample.commands;

import java.util.Date;

//*-------------------------------------------------------------------

//* Licensed Materials - Property of IBM
//*
//* WebSphere Commerce
//*
//* (c) Copyright International Business Machines Corporation. 2001, 2003, 2005
//*     All rights reserved.
//*
//* US Government Users Restricted Rights - Use, duplication or
//* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
//*
//*-------------------------------------------------------------------
//* The sample contained herein is provided to you "AS IS".
//*
//* It is furnished by IBM as a simple example and has not been  
//* thoroughly tested under all conditions.  IBM, therefore, cannot guarantee its 
//* reliability, serviceability or functionality.  
//*
//* This sample may include the names of individuals, companies, brands 
//* and products in order to illustrate concepts as completely as 
//* possible.  All of these names
//* are fictitious and any similarity to the names and addresses used by 
//* actual persons or business enterprises is entirely coincidental.
//*---------------------------------------------------------------------

/// Import Section 1 ///////////////////////////////
import com.ibm.commerce.accesscontrol.AccessVector;
import com.ibm.commerce.command.ControllerCommandImpl;
import com.ibm.commerce.datatype.TypedProperty;
import com.ibm.commerce.exception.ECException;
import com.ibm.commerce.exception.ParameterNotFoundException;
import com.ibm.commerce.foundation.persistence.EntityDao;
import com.ibm.commerce.sample.objects.ProjectE;
import com.ibm.commerce.sample.persistence.ProjectDaoImpl;

/*
 * Implementation for update contact command.
 */
public class ProjectUpdateCmdImpl extends ControllerCommandImpl implements ProjectUpdateCmd {

	private static final String COPYRIGHT = com.ibm.commerce.copyright.IBMCopyright.SHORT_COPYRIGHT;

	private Long xproject_id = null;
	private String prjname = null;
	private ProjectE project = null;
	private AccessVector iResourcelist = null;
	


	public ProjectUpdateCmdImpl() {
		super();
	}

	public ProjectE getProject() {
		return project;
	}

	public void setProject(ProjectE project) {
		this.project = project;
	}


	public void performExecute() throws ECException {
		project = getProject();
		EntityDao<ProjectE, Long> entityDao = new ProjectDaoImpl();
		entityDao.merge(project);
		setPrjname(prjname);
	}

	public void validateParameters() throws ECException {
		iResourcelist = new AccessVector();
		xproject_id = getXproject_id();
		prjname = getPrjname();
		
		EntityDao<ProjectE, Long> entityDao = new ProjectDaoImpl();
		ProjectE projectToUpdate = entityDao.find(xproject_id);
        if(prjname == null){
        	prjname =projectToUpdate.getPrjname()+ new Date();
		}
		projectToUpdate.setPrjname(prjname);
		setProject(projectToUpdate);
		iResourcelist.addElement(projectToUpdate);
	}

	@Override
	public AccessVector getResources() throws ECException {
		return iResourcelist;
	}

	@Override
	public long getXproject_id() {
		 TypedProperty reqProps =this.getCommandContext().getRequestProperties();
        String xproject_id=null;
        if (reqProps != null && reqProps.containsKey("xproject_id")) {
        	try {
				xproject_id = reqProps.getString("xproject_id");
			} catch (ParameterNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		    }
		return Integer.valueOf(xproject_id);
	}

	@Override
	public void setXproject_id(long xproject_id) {
		// TODO Auto-generated method stub
		this.xproject_id=xproject_id;
	}

	@Override
	public String getPrjname() {
		
		//add new
		 TypedProperty reqProps =this.getCommandContext().getRequestProperties();
       String xproject_name=null;
       if (reqProps != null && reqProps.containsKey("prjname")) {
       	try {
       		xproject_name = reqProps.getString("prjname");
			} catch (ParameterNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

		    }
       if(xproject_name==null || xproject_name.trim().length()==0){
    		xproject_name = prjname;
    	}
		// TODO Auto-generated method stub
		return xproject_name;
	}

	@Override
	public void setPrjname(String prjname) {
		// TODO Auto-generated method stub
		this.prjname=prjname;
	}

	/**
	 * Can be removed or customization the access control part
	 */
	@Override
	public boolean checkPermission() throws ECException {
		// TODO Auto-generated method stub
		return true;
	}

	@Override
	public boolean accessControlCheck() throws ECException {
		// TODO Auto-generated method stub
		return true;
	}

	@Override
	public void checkResourcePermission() throws ECException {
		// TODO Auto-generated method stub
		// do nothing
	}
	
	
}
