package com.ibm.commerce.sample.commands;

//*-------------------------------------------------------------------

//* Licensed Materials - Property of IBM
//*
//* WebSphere Commerce
//*
//* (c) Copyright International Business Machines Corporation. 2001, 2003, 2005
//*     All rights reserved.
//*
//* US Government Users Restricted Rights - Use, duplication or
//* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
//*
//*-------------------------------------------------------------------
//* The sample contained herein is provided to you "AS IS".
//*
//* It is furnished by IBM as a simple example and has not been  
//* thoroughly tested under all conditions.  IBM, therefore, cannot guarantee its 
//* reliability, serviceability or functionality.  
//*
//* This sample may include the names of individuals, companies, brands 
//* and products in order to illustrate concepts as completely as 
//* possible.  All of these names
//* are fictitious and any similarity to the names and addresses used by 
//* actual persons or business enterprises is entirely coincidental.
//*---------------------------------------------------------------------

/// Import Section 1 ///////////////////////////////
import com.ibm.commerce.accesscontrol.AccessVector;
import com.ibm.commerce.beans.DataBeanManager;
import com.ibm.commerce.command.CommandContext;
import com.ibm.commerce.command.ControllerCommandImpl;
import com.ibm.commerce.datatype.TypedProperty;
import com.ibm.commerce.exception.ECException;
import com.ibm.commerce.foundation.persistence.EntityDao;
import com.ibm.commerce.sample.beans.ProjectDataBean;
import com.ibm.commerce.sample.objects.ProjectE;
import com.ibm.commerce.sample.persistence.ProjectDaoImpl;

/*
 * Implementation for create contact command.
 */
public class ProjectCreateCmdImpl extends ControllerCommandImpl implements ProjectCreateCmd {

	private static final String COPYRIGHT = com.ibm.commerce.copyright.IBMCopyright.SHORT_COPYRIGHT;


	 private Long xproject_id = null;
	 private Integer time  = null;
	 private Integer difficulty = null;
	 private String prjname = null;
	 private Integer storeent_id = null;

	public ProjectCreateCmdImpl() {
		super();
	}


	public void performExecute() throws ECException {
		Long xproject_id = null;
		 TypedProperty reqProps =this.getCommandContext().getRequestProperties();
         String time=null;
         String prjname=null;
         if (reqProps != null) {
        	 prjname = reqProps.getString("prjname");
		    }
		EntityDao<ProjectE, Long> entityDao = new ProjectDaoImpl();
		ProjectE project = new ProjectE();
		if(getXproject_id()==null){
			project.setXproject_id(entityDao.generatePrimaryKey("XPROJECT"));
		}
		project.setDifficulty(1);

		project.setStoreent_id(2);
		project.setTime(Integer.valueOf(1));
		project.setPrjname(prjname);

		entityDao.persist(project);
		setXproject_id(project.getXproject_id());
	}

	@Override
	public AccessVector getResources() throws ECException {
		return null;
	}

	@Override
	public void setRequestProperties(TypedProperty reqProperties) throws ECException {
		// TODO Auto-generated method stub
		
		super.setRequestProperties(reqProperties);
	}

	@Override
	public Long getXproject_id() {
		// TODO Auto-generated method stub
		return xproject_id;
	}

	@Override
	public void setTime(Integer time) {
		// TODO Auto-generated method stub
		this.time=time;
		
	}

	@Override
	public void setDifficulty(Integer difficulty) {
		// TODO Auto-generated method stub
		this.difficulty=difficulty;
	}

	@Override
	public void setPrjname(String prjname) {
		// TODO Auto-generated method stub
		this.prjname=prjname;
	}


	public Integer getStoreent_id() {
		return storeent_id;
	}


	public void setStoreent_id(Integer storeent_id) {
		this.storeent_id = storeent_id;
	}


	public static String getCopyright() {
		return COPYRIGHT;
	}


	public Integer getTime() {
		return time;
	}


	public Integer getDifficulty() {
		return difficulty;
	}


	public String getPrjname() {
		return prjname;
	}


	public void setXproject_id(Long xproject_id) {
		this.xproject_id = xproject_id;
	}

	/**
	 * Can be removed or customization the access control part
	 */
	@Override
	public boolean checkPermission() throws ECException {
		// TODO Auto-generated method stub
		return true;
	}

	@Override
	public boolean accessControlCheck() throws ECException {
		// TODO Auto-generated method stub
		return true;
	}

	@Override
	public void checkResourcePermission() throws ECException {
		// TODO Auto-generated method stub
		// do nothing
	}
}
