package com.ibm.commerce.sample.objsrc;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2015
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */
import com.ibm.commerce.common.objects.StoreAccessBean;
import com.ibm.commerce.common.objects.StoreEntityAccessBean;
import com.ibm.commerce.copyright.IBMCopyright;
import com.ibm.commerce.registry.StoreRegistry;
import com.ibm.commerce.sample.objects.Contact;
import com.ibm.commerce.security.AccessHelper;
import com.ibm.ws.batch.xJCL.beans.returnCodeExpression;

/*
 * Contact access helper for access control as a sample.
 */
public class ContactAccessHelper extends AccessHelper {
	/**
	 * Copyright.
	 */
	public static final String COPYRIGHT = IBMCopyright.SHORT_COPYRIGHT;

	public ContactAccessHelper() {
	}

	public Long getOwner(Object obj) throws Exception {
		Contact bean = (Contact) obj;
		Integer storeEntId = bean.getStoreId();
		StoreAccessBean storeAB = StoreRegistry
				.singleton().find(storeEntId);
		if (storeAB != null) {
			return storeAB.getMemberIdInEntityType();
		} else {
			StoreEntityAccessBean storeEntAB = new StoreEntityAccessBean();
			storeEntAB.setInitKey_storeEntityId(storeEntId.toString());
			return storeEntAB.getMemberIdInEntityType();
		}
	}

	public boolean fulfills(Object obj, Long member, String relationship) throws Exception {
		boolean result=false;
		Contact contact=(Contact)obj;
		if ("creator".equalsIgnoreCase(relationship)) {
			result = member.equals(contact.getMemberId());
		}
		//return result;
		return true;
	}
}
