package com.mycompany.commerce.project.facade.server.commands;

import com.ibm.commerce.foundation.common.datatypes.CommerceFoundationFactory;
import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.server.command.bod.AbstractInsertMoreNounDataCmdImpl;
import com.mycompany.commerce.project.facade.datatypes.ProjectFactory;

/**
 * The command used to insert more Project data based on MyCompany_Admin_Details
 * access profile. 
 * It gets catentry name by invoke catalog services
 * /CatalogEntry[CatalogEntryIdentifier[(UniqueID='catentryID')]]+IBM_Admin_CatalogEntryDescription
 * The services is provided by catalog services as a SOA interface.
 */
public class InsertMoreProjectDataAdminCmdImpl extends
		AbstractInsertMoreNounDataCmdImpl {

	private static final java.util.logging.Logger LOGGER = com.ibm.commerce.foundation.common.util.logging.LoggingHelper
			.getLogger(InsertMoreProjectDataAdminCmdImpl.class);

	private static final String CLASSNAME = InsertMoreProjectDataAdminCmdImpl.class
			.getName();

	/**
	 * 
	 * @see com.ibm.websphere.command.TargetableCommand#performExecute()
	 */
	public void performExecute() throws Exception {

		final String METHODNAME = "performExecute";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME);
		}

	/*	List projectNouns = getNouns();
		Iterator projectIterator = projectNouns.iterator();

		*/
		

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}

	}



	/**
	 * Getter method which returns the <code>ProjectFactory</code>.
	 * 
	 * @return an object of type <code>ProjectFactory</code>
	 */
	protected ProjectFactory getProjectFactory() {
		return ProjectFactory.eINSTANCE;
	}

	/**
	 * This method will return the default instance of the Commerce Foundation
	 * Factory. This factory can be used to create objects defined by the
	 * Commerce Foundation.
	 * 
	 * @return The default Commerce Foundation Factory.
	 */
	protected CommerceFoundationFactory getCommerceFoundationFactory() {
		return CommerceFoundationFactory.eINSTANCE;
	}

}
