package com.mycompany.commerce.project.facade.server.commands;

/**
 * This is the interface for the Get Project web service command. This interface is to be implemented by the class
 * that provides the Project get service. This interface defines a method to set the <code>GetProjectType</code>
 * object which contains the xpath request. It also defines a method to get the <code>ShowProjectType</code> object
 * which contains the information used to compose the show business object document.
 */
public interface GetProjectCmd extends com.ibm.commerce.foundation.server.command.bod.BusinessObjectDocumentCmd {

	
	/**
	 * This method sets the <code>GetProjectType</code> business object document that this command will process.
	 * @param getProject The <code>GetProjectType</code> business object document.
	 */
	public void setGetProject(com.mycompany.commerce.project.facade.datatypes.GetProjectType getProject);

	/**
	 * This method gets the <code>ShowProjectType</code> business object document result.
	 * @return This method returns the <code>ShowProjectType</code> business object document result to the client.
	 */
	public com.mycompany.commerce.project.facade.datatypes.ShowProjectType getShowProject();
}
