package com.mycompany.commerce.project.facade.server.authorization;

import java.rmi.RemoteException;
import java.util.logging.Level;


import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.security.AbstractProtectableProxy;
import com.ibm.commerce.security.Protectable;

/**
 * This class represents a protectable proxy object that is the bridge between
 * any Java object and the policy manager access control engine that is part of
 * WebSphere Commerce.
 */
public class ProjectTypeProtectableProxy extends AbstractProtectableProxy {


	private static final String CLASSNAME = ProjectTypeProtectableProxy.class
			.getName();

	private static final java.util.logging.Logger LOGGER = com.ibm.commerce.foundation.common.util.logging.LoggingHelper
			.getLogger(ProjectTypeProtectableProxy.class);

	/**
	 * Creates an instance of the protectable proxy object.
	 */
	public ProjectTypeProtectableProxy() {
		super();
	}

	/**
	 * This method determines if a given member fulfills a given relationship
	 * with the resource.
	 * 
	 * @param member
	 *            This is the member id of the member.
	 * @param relationship
	 *            This is the relationship the member has with to the resource.
	 * @return This method will always return <code>true</code>.
	 * @exception RemoteException
	 * @exception Exception
	 */
	public boolean fulfills(Long member, String relationship)
			throws RemoteException, Exception {
		final String METHODNAME = "fulfills(Long, String)";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper
				.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME);
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}

		return super.fulfills(member, relationship);
	}

	/**
	 * This method will return the owner of the protectable object. If the owner
	 * has not been specified on the proxy object, then the owner will be the
	 * owner of the store that can be resolved from the command context.
	 * 
	 * @return The owner of the protectable proxy.
	 * @exception Exception
	 *                A problem occurred while resolving the owner.
	 * @exception RemoteException
	 *                A problem occurred while accessing a remote resource.
	 * @see com.ibm.commerce.security.Protectable#getOwner()
	 */
	public Long getOwner() throws Exception, RemoteException {
		final String METHODNAME = "getOwner()";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper
				.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME);
		}
			
		// TODO: return the owner of this protectable proxy object, the default behaviour will return the owner of the store in the command context.
		// If the Project contains a storeId, the owner can be determined by the following:
		// StoreAccessBean abStore = StoreRegistry.singleton().find(storeIdFromNoun);
		//	if (abStore != null) {
		//		oOwner = abStore.getOwner();
		//	} else {
		//		// this is site level
		//		oOwner = super.getOwner();
		//	}
		// If the Project does not contain a storeId, use the default behaviour.
				
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper
				.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}

		return super.getOwner();
	}

}
