package com.mycompany.commerce.project.facade.client;
/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2008
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */
import java.text.MessageFormat;

import com.ibm.commerce.foundation.client.facade.bod.AbstractBusinessObjectDocumentFacadeClient;
import com.ibm.commerce.foundation.client.util.oagis.SelectionCriteriaHelper;
import com.mycompany.commerce.project.facade.ProjectFacadeConstants;
import com.mycompany.commerce.project.facade.datatypes.AcknowledgeProjectType;
import com.mycompany.commerce.project.facade.datatypes.ChangeProjectType;
import com.mycompany.commerce.project.facade.datatypes.GetProjectType;
import com.mycompany.commerce.project.facade.datatypes.ProcessProjectType;
import com.mycompany.commerce.project.facade.datatypes.ProjectDifficultyType;
import com.mycompany.commerce.project.facade.datatypes.ProjectExternalIdentifierType;
import com.mycompany.commerce.project.facade.datatypes.ProjectFactory;
import com.mycompany.commerce.project.facade.datatypes.ProjectIdentifierType;
import com.mycompany.commerce.project.facade.datatypes.ProjectType;
import com.mycompany.commerce.project.facade.datatypes.RespondProjectType;
import com.mycompany.commerce.project.facade.datatypes.ShowProjectType;



/**
 * <p>This class provides common methods that this and other utility class to the Project
 * facade can use.  This class also provides a set of convenient Java API to represent
 * particular Project operations.  This set of Java API also include APIs for Web based requests
 * to transform the name value pair request into the appropriate request documents.</p> 
 */
public class ProjectFacadeClient extends AbstractProjectFacadeClient {


	
	// ==============================================================================
	// Constants for logging and tracing.
	// ==============================================================================

	// uncommnent it when implement the code
	// private static final String CLASSNAME = ProjectFacadeClient.class.getName();
	// private static final java.util.logging.Logger LOGGER = com.ibm.commerce.foundation.common.util.logging.LoggingHelper.getLogger(ProjectFacadeClient.class);	
	
	// ==============================================================================
	// Constructors for the client to the Project facade.
	// ==============================================================================
	
	/**
	 * Creates an instance of the client to communicate with the Project facade.
	 */
	public ProjectFacadeClient() {
		super();
	}
	/**
	 * Creates an instance of the client to communicate with the Project facade.
	 * @param businessContext The default business context to associate with the messages
	 * when making requests.
	 * @param callbackHandler Used for authentication purposes so the controller can give
	 * the authentication information to the transport when required.
	 */
	public ProjectFacadeClient(com.ibm.commerce.foundation.common.datatypes.BusinessContextType businessContext,
			javax.security.auth.callback.CallbackHandler callbackHandler) {
		super(businessContext, callbackHandler);
	}	

	/**
	 * Get a Project noun by providing project name id And returns show BOD contains
	 * the Project noun
	 * 
	 * @param name
	 *            name of the project
	 * @param accessProfile
	 *            the accessprofile is selected
	 * @return ShowProjectType the show BOD contains the Project noun
	 */
	public ShowProjectType getProjectByName(String name, String accessProfile) {

		// construct the verb
		GetProjectType getProject = ProjectFactory.eINSTANCE
				.createGetProjectType();
		getProject.setDataArea(ProjectFactory.eINSTANCE
				.createGetProjectDataAreaType());
		getProject
				.getDataArea()
				.setGet(
						AbstractBusinessObjectDocumentFacadeClient
								.createGetVerb(
										SelectionCriteriaHelper.STR_XPATH_LANG,
										"{"
												+ SelectionCriteriaHelper.STR_ACCESS_PROFILE_PARAMETER
												+ "="
												+ accessProfile
												+ "}"
												+ "/Project[search(contains(ProjectIdentifier/ExternalIdentifier/Name,'"
												+ name + "'))]"));

		

		// send the "get" request and get the "show" response
		ShowProjectType showProject = getProject(getProject);

		

		return showProject;
	}
	
	/**
	 * Get a Project noun by providing  unique id And returns show BOD contains
	 * the Project noun
	 * 
	 * @param projectUID
	 *            an unique id of the project
	 * @param accessProfile
	 *            the accessprofile is selected
	 * @return ShowProjectType the show BOD contains the Project noun
	 */
	public ShowProjectType getProjectByUID(String projectUID,
			String accessProfile) {

		// construct the verb
		GetProjectType getProject = ProjectFactory.eINSTANCE
				.createGetProjectType();
		getProject.setDataArea(ProjectFactory.eINSTANCE
				.createGetProjectDataAreaType());
		getProject
				.getDataArea()
				.setGet(
						AbstractBusinessObjectDocumentFacadeClient
								.createGetVerb(
										SelectionCriteriaHelper.STR_XPATH_LANG,
										"{"
												+ SelectionCriteriaHelper.STR_ACCESS_PROFILE_PARAMETER
												+ "="
												+ accessProfile
												+ "}"
												+ MessageFormat
														.format(
																ProjectFacadeConstants.XPATH_PROJECT_IDEXPRESSION,
																new String[] { projectUID })));

		
		// send the "get" request and get the "show" response
		ShowProjectType showProject = getProject(getProject);

		

		return showProject;
	}

	/**
	 * Create a new Project noun by providing name and description And returns
	 * an acknowledge BOD
	 * 
	 * @param projectName
	 *            the name of the noun Project
	 * @param description
	 *            the description of the noun Project
	 * @return AcknowledgeProjectType the acknowledge BOD after creating a
	 *         Project noun
	 */
	public AcknowledgeProjectType createProject(String projectName,
			String description) {
		ProcessProjectType processProject = ProjectFactory.eINSTANCE
				.createProcessProjectType();
		processProject.setDataArea(ProjectFactory.eINSTANCE
				.createProcessProjectDataAreaType());

		// Create the action and XPath
		java.util.List actions = new java.util.ArrayList();
		actions
				.add(AbstractBusinessObjectDocumentFacadeClient
						.createActionExpression(
								ProjectFacadeConstants.PROCESS_VERB_ACTION_CREATE_PROJECT,
								SelectionCriteriaHelper.STR_XPATH_LANG,
								ProjectFacadeConstants.XPATH_PROJECT + "1"
										+ ProjectFacadeConstants.CLOSE_XPATH));
		com.ibm.commerce.oagis9.datatypes.ProcessType processVerb = AbstractBusinessObjectDocumentFacadeClient
				.createProcessVerb(actions);
		processProject.getDataArea().setProcess(processVerb);

		// Create the noun
		ProjectType project = ProjectFactory.eINSTANCE.createProjectType();
		//	Add new noun into the BOD
		processProject.getDataArea().getProject().add(project);
		// Insert projectname
		ProjectExternalIdentifierType projectExID = ProjectFactory.eINSTANCE
				.createProjectExternalIdentifierType();
		projectExID.setName(projectName);
	
		ProjectIdentifierType projectID = ProjectFactory.eINSTANCE
				.createProjectIdentifierType();
		projectID.setExternalIdentifier(projectExID);
		project.setProjectIdentifier(projectID);

		
		

		// =========================
		// Send the BOD request
		// =========================

		// Send the request
		AcknowledgeProjectType acknowledgeProject = processProject(processProject);		

		return acknowledgeProject;

	}
	/**
	 * Change a Project noun by providing external id (name) And returns a
	 * repond BOD contains the Project noun
	 * 
	 * @param uid
	 *            an unique id of the noun Project
	 * @param name
	 *            an external id(name) of the noun Project
	 * @return RespondProject the respond BOD contains the Project noun
	 */
	public RespondProjectType changeProjectName(String uid, String name) {
		ChangeProjectType changeProject = ProjectFactory.eINSTANCE
				.createChangeProjectType();
		changeProject.setDataArea(ProjectFactory.eINSTANCE
				.createChangeProjectDataAreaType());

		// create the verb
		java.util.List actions = new java.util.ArrayList();
		actions
				.add(AbstractBusinessObjectDocumentFacadeClient
						.createActionExpression(
								AbstractBusinessObjectDocumentFacadeClient.CHANGE_VERB_ACTION_CHANGE,
								SelectionCriteriaHelper.STR_XPATH_LANG,
								MessageFormat
										.format(
												ProjectFacadeConstants.XPATH_CHANGE_PROJECT,
												new String[] { String
														.valueOf(1) })));
		com.ibm.commerce.oagis9.datatypes.ChangeType changeVerb = AbstractBusinessObjectDocumentFacadeClient
				.createChangeVerb(actions);
		changeProject.getDataArea().setChange(changeVerb);

		// create the noun
		ProjectType project = ProjectFactory.eINSTANCE.createProjectType();
		changeProject.getDataArea().getProject().add(project);
		ProjectIdentifierType idType = ProjectFactory.eINSTANCE
				.createProjectIdentifierType();
		project.setProjectIdentifier(idType);

		// set uid
		if (uid != null) {
			idType.setUniqueID(uid);
		}

		// set name
		if (name != null) {
			ProjectExternalIdentifierType extIDType = ProjectFactory.eINSTANCE
					.createProjectExternalIdentifierType();
			idType.setExternalIdentifier(extIDType);
			extIDType.setName(name);
		}

		
		project.setDifficulty(ProjectDifficultyType.DIFFICULT_LITERAL);

		

		// send the request
		RespondProjectType respondProject = changeProject(changeProject);

		

		return respondProject;

	}



}
