package com.mycompany.commerce.project.facade.client;

import java.util.List;

import javax.security.auth.callback.CallbackHandler;

import com.ibm.commerce.foundation.common.datatypes.BusinessContextType;
import com.mycompany.commerce.project.facade.ProjectFacadeConstants;
import com.mycompany.commerce.project.facade.datatypes.ProjectFactory;
import com.mycompany.commerce.project.facade.datatypes.DocumentRoot;


import com.mycompany.commerce.project.facade.datatypes.GetProjectDataAreaType;
import com.mycompany.commerce.project.facade.datatypes.GetProjectType;
import com.mycompany.commerce.project.facade.datatypes.ShowProjectDataAreaType;
import com.mycompany.commerce.project.facade.datatypes.ShowProjectType;


import com.mycompany.commerce.project.facade.datatypes.AcknowledgeProjectDataAreaType;
import com.mycompany.commerce.project.facade.datatypes.AcknowledgeProjectType;
import com.mycompany.commerce.project.facade.datatypes.ProcessProjectType;

import com.mycompany.commerce.project.facade.datatypes.ChangeProjectType;
import com.mycompany.commerce.project.facade.datatypes.RespondProjectDataAreaType;
import com.mycompany.commerce.project.facade.datatypes.RespondProjectType;



/**
 * <p>This class provides a set of methods that can be used to communicate with the
 * Project facade.  This class represents a library of Project operations that can be performed.
 * The purpose of this class is to hide the details about constructing the business
 * object document that represents the service request into simple Java methods.  The
 * complexity of building the request document and making the request is all managed
 * by this client class of the Project facade.</p>
 */
public abstract class AbstractProjectFacadeClient extends com.ibm.commerce.foundation.client.facade.bod.AbstractBusinessObjectDocumentFacadeClient {

	
	// ==============================================================================
	// Constants for logging and tracing.
	// ==============================================================================
	private static final String CLASSNAME = AbstractProjectFacadeClient.class.getName();
	private static final java.util.logging.Logger LOGGER = com.ibm.commerce.foundation.common.util.logging.LoggingHelper.getLogger(AbstractProjectFacadeClient.class);
	
	// ==============================================================================
	// Constructors for the client to the Project facade.
	// ==============================================================================
	
	/**
	 * Creates an instance of the client to communicate with the Project facade.
	 */
	public AbstractProjectFacadeClient() {
		super();
	}
	/**
	 * Creates an instance of the client to communicate with the Project facade.
	 * @param businessContext The default business context to associate with the messages
	 * when making requests.
	 * @param callbackHandler Used for authentication purposes so the controller can give
	 * the authentication information to the transport when required.
	 */
	public AbstractProjectFacadeClient(BusinessContextType businessContext,
			CallbackHandler callbackHandler) {
		super(businessContext, callbackHandler);
	}	
	
	/**
	 * This method will return the default instance of the Project Factory.
	 * This factory can be used to create objects defined by the Project.
	 * @return The default Project Factory.
	 */
	protected ProjectFactory getProjectFactory() {
		return ProjectFactory.eINSTANCE;		
	}
	
	
	// ==============================================================================
	// The high level service operations that make the request to the Project facade.
	// These operations are for Project.
	// ==============================================================================
	
	/**
	 * This method will communicate with the Project facade and send the specified
	 * GetProject. request.
	 * @param aGetProject The GetProject request document.
	 * @return The resulting <code>ShowProject</code> response document.
	 */
	public ShowProjectType 
				getProject(GetProjectType aGetProject) {
		final String METHODNAME = "getProject(GetProjectType)";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.entering(CLASSNAME, METHODNAME, aGetProject);
		}
		
		DocumentRoot docRoot = getProjectFactory().createDocumentRoot();
		docRoot.setGetProject(aGetProject);
		aGetProject.setVersionID(docRoot.getProjectBODVersion());
		
		ShowProjectType response = 
			(ShowProjectType) sendBusinessObjectDocument(
					com.mycompany.commerce.project.facade.ProjectFacade.class, ProjectFacadeConstants.COMPONENT_NAME, aGetProject);
		
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.exiting(CLASSNAME, METHODNAME, response);
		}
		return response;
	}
	
	/**
	 * This method will communicate with the Project facade and send the specified
	 * ProcessProject request.
	 * @param aProcessProject The ProcessProject request document.
	 * @return The resulting AcknowledgeProject response document.
	 */
	public AcknowledgeProjectType 
			processProject(ProcessProjectType aProcessProject) {
		final String METHODNAME = "processProject(ProcessProjectType)";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.entering(CLASSNAME, METHODNAME, aProcessProject);
		}
		
		DocumentRoot docRoot = getProjectFactory().createDocumentRoot();
		docRoot.setProcessProject(aProcessProject);
		aProcessProject.setVersionID(docRoot.getProjectBODVersion());
		
		AcknowledgeProjectType response = 
			(AcknowledgeProjectType) sendBusinessObjectDocument(
					com.mycompany.commerce.project.facade.ProjectFacade.class, ProjectFacadeConstants.COMPONENT_NAME, aProcessProject);
		
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.exiting(CLASSNAME, METHODNAME, response);
		}
		return response;
	}
	
	/**
	 * This method will communicate with the Project facade and send the specified
	 * ChangeProject request.
	 * @param aChangeProject The ChangeProject request document.
	 * @return The resulting RespondProject response document.
	 */
	public RespondProjectType 
			changeProject(ChangeProjectType aChangeProject) {
		final String METHODNAME = "changeProject(ChangeProjectType)";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.entering(CLASSNAME, METHODNAME, aChangeProject);
		}
		
		DocumentRoot docRoot = getProjectFactory().createDocumentRoot();
		docRoot.setChangeProject(aChangeProject);
		aChangeProject.setVersionID(docRoot.getProjectBODVersion());		
		
		RespondProjectType response = 
			(RespondProjectType) sendBusinessObjectDocument(
					com.mycompany.commerce.project.facade.ProjectFacade.class, ProjectFacadeConstants.COMPONENT_NAME, aChangeProject);
		
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.exiting(CLASSNAME, METHODNAME, response);
		}
		return response;
	}
	
	
	// ==============================================================================
	// Standard utility methods most client API will create for the purpose of
	// providing common APIs which custom utility methods will call.  This
	// also includes methods required to fit in with different runtime controllers.
	// These operations are for Project
	// ==============================================================================
	
	/**
	 * This method will examine the AcknowledgeProjectDataArea to see if there is any 
	 * error information reported.  If there is, then the <code>ProjectException</code>
	 * will be thrown to represent the error.  This method should be used by those
	 * methods that are performing a Process operation on a single Project.
	 * @param acknowledgeProjectDataArea The acknowledge Project data area to inspect.
	 * @return The specified AcknowledgeProjectDataArea if no error information is found.
	 * @exception ProjectException The <code>ProjectException</code> is thrown if error
	 * information is found in the specified <code>AcknowledgeProjectDataArea</code>.
	 * This will represent that there was a problem when performing the operation.
	 */
	protected AcknowledgeProjectDataAreaType 
			checkAcknowledgeProject(AcknowledgeProjectDataAreaType acknowledgeProjectDataArea) throws ProjectException {
		final String METHODNAME = "checkAcknowledgeProject(AcknowledgeProjectDataAreaType)";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.entering(CLASSNAME, METHODNAME, acknowledgeProjectDataArea);
		}
		
		if (acknowledgeProjectDataArea.getAcknowledge()!= null && acknowledgeProjectDataArea.getAcknowledge().getResponseCriteria() != null && acknowledgeProjectDataArea.getAcknowledge().getResponseCriteria().size() > 0) {
			com.ibm.commerce.oagis9.datatypes.ResponseActionCriteriaType response = (com.ibm.commerce.oagis9.datatypes.ResponseActionCriteriaType) acknowledgeProjectDataArea.getAcknowledge().getResponseCriteria().get(0);
			com.ibm.commerce.oagis9.datatypes.ChangeStatusType changeStatus = response.getChangeStatus();
			if (changeStatus != null) {
				throw new ProjectException(changeStatus, acknowledgeProjectDataArea.getAcknowledge(), acknowledgeProjectDataArea.getProject());
			}
		}
		AcknowledgeProjectDataAreaType response = acknowledgeProjectDataArea;
		
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.exiting(CLASSNAME, METHODNAME, response);
		}
		return response;
	}
	
	/**
	 * This method will examine the RespondProjectDataArea to see if there is any 
	 * error information reported.  If there is, then the <code>ProjectException</code>
	 * will be thrown to represent the error.  This method should be used by those
	 * methods that are performing a Process operation on a single Project.
	 * @param respondProjectDataArea The respond Project data area to inspect.
	 * @return The specified RespondProjectDataArea if no error information is found.
	 * @exception ProjectException The <code>ProjectException</code> is thrown if error
	 * information is found in the specified <code>RespondProjectDataArea</code>.
	 * This will represent that there was a problem when performing the operation.
	 */
	protected RespondProjectDataAreaType 
			checkRespondProject(RespondProjectDataAreaType respondProjectDataArea) throws ProjectException {
		final String METHODNAME = "checkRespondProject(RespondProjectDataAreaType)";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.entering(CLASSNAME, METHODNAME, respondProjectDataArea);
		}
		
		if (respondProjectDataArea.getRespond() != null && respondProjectDataArea.getRespond().getResponseCriteria() != null && respondProjectDataArea.getRespond().getResponseCriteria().size() > 0) {
			com.ibm.commerce.oagis9.datatypes.ResponseActionCriteriaType response = (com.ibm.commerce.oagis9.datatypes.ResponseActionCriteriaType) respondProjectDataArea.getRespond().getResponseCriteria().get(0);
			com.ibm.commerce.oagis9.datatypes.ChangeStatusType changeStatus = response.getChangeStatus();
			if (changeStatus != null) {
				throw new ProjectException(changeStatus, respondProjectDataArea.getRespond(), respondProjectDataArea.getProject());
			}
		}
		RespondProjectDataAreaType response = respondProjectDataArea;
		
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.exiting(CLASSNAME, METHODNAME, response);
		}
		return response;
	}
	
	/**
	 * This method will examine the ShowProjectDataArea to see if there is any 
	 * error information reported.  If there is, then the <code>ProjectException</code>
	 * will be thrown to represent the error.  This method should be used by those
	 * methods that are performing a Process operation on a single Project.
	 * @param showProjectDataArea The show Project data area to inspect.
	 * @return The specified ShowProjectDataArea if no error information is found.
	 * @exception ProjectException The <code>ProjectException</code> is thrown if error
	 * information is found in the specified <code>ShowProjectDataArea</code>.
	 * This will represent that there was a problem when performing the operation.
	 */
	protected ShowProjectDataAreaType 
			checkShowProject(ShowProjectDataAreaType showProjectDataArea) throws ProjectException {
		final String METHODNAME = "checkShowProject(ShowProjectDataAreaType)";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.entering(CLASSNAME, METHODNAME, showProjectDataArea);
		}
		
		if (showProjectDataArea.getShow() != null && showProjectDataArea.getShow().getResponseCriteria() != null && showProjectDataArea.getShow().getResponseCriteria().size() > 0) {
			com.ibm.commerce.oagis9.datatypes.ResponseActionCriteriaType response = (com.ibm.commerce.oagis9.datatypes.ResponseActionCriteriaType) showProjectDataArea.getShow().getResponseCriteria().get(0);
			com.ibm.commerce.oagis9.datatypes.ChangeStatusType changeStatus = response.getChangeStatus();
			if (changeStatus != null) {
				throw new ProjectException(changeStatus, showProjectDataArea.getShow(), showProjectDataArea.getProject());
			}
		}
		ShowProjectDataAreaType response = showProjectDataArea;
		
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.exiting(CLASSNAME, METHODNAME, response);
		}
		return response;
	}
	/**
	 * This method returns the <code>ShowProjectDataArea</code> when issuing the specified
	 * get expression to fetch Projects.  This method will be used by other framworks or
	 * methods that constructs the get expression.
	 * @param getVerb The get expression to execute.
	 * @return The <code>ShowProjectDataArea</code> response when issuing the get expression.
	 * @exception ProjectException The <code>ProjectException</code> is thrown if error
	 * information is found in the specified <code>ShowProjectDataArea</code>.
	 * This will represent that there was a problem when performing the operation.
	 */
	public ShowProjectDataAreaType 
			getProject(com.ibm.commerce.oagis9.datatypes.GetType getVerb)  throws ProjectException {
		final String METHODNAME = "getProject(GetType)";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.entering(CLASSNAME, METHODNAME, getVerb);
		}
		
		GetProjectType getProject = getProjectFactory().createGetProjectType();		
		GetProjectDataAreaType dataArea = getProjectFactory().createGetProjectDataAreaType();
		getProject.setDataArea(dataArea);
		dataArea.setGet(getVerb);
		ShowProjectDataAreaType response = checkShowProject(getProject(getProject).getDataArea());
		
		
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.exiting(CLASSNAME, METHODNAME, response);
		}
		return response;
	}
	/**
	 * This method returns a list of Projects based on the expression specified.
	 * @param expressionLanguage The expression lanaguage.
	 * @param expression The expression to return a list of Projects.
	 * @return The list of Projects that matches the expression specified.
	 * @exception ProjectException The <code>ProjectException</code> is thrown if error
	 * information is found in the specified <code>ShowProjectDataArea</code>.
	 * This will represent that there was a problem when performing the operation.
	 */
	public List getProject(String expressionLanguage, String expression)  throws ProjectException {
		final String METHODNAME = "getProject(String, String)";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.entering(CLASSNAME, METHODNAME, 
					new Object[] { expressionLanguage, expression }
			);
		}
		
		com.ibm.commerce.oagis9.datatypes.GetType getVerb = createGetVerb(expressionLanguage, expression);
		List response = getProject(getVerb).getProject();
		
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.exiting(CLASSNAME, METHODNAME, response);
		}
		return response;
	}
	
	
}
