<%--
 =================================================================
  Licensed Materials - Property of IBM

  WebSphere Commerce

  (C) Copyright IBM Corp. 2011, 2016 All Rights Reserved.

  US Government Users Restricted Rights - Use, duplication or
  disclosure restricted by GSA ADP Schedule Contract with
  IBM Corp.
 =================================================================
--%>


<%-- 
  *****
  * SEOSitemap.jsp generates all the SEO URLs for static pages that a store admin want to be indexed by Google search engine.
  * This JSP is invoked by the SiteMapGenerateCmd, when 'SEO' feature is enabled for the particular store.
  * This file does not generate the catalog related SEO URLs.
  * parameters:
  * storeId: the storeId of the store to which the sitemap file is generated.
  *	catalogIds: list of catalog Ids that belong to this store.
  * storeId=12101&catalogId=11051&useSearchKeywordForCategoryURL=false&HostName=localhost&PortNumber=4200
  *****
--%>

<%@ page import="com.ibm.commerce.datatype.TypedProperty" %>
<%@ page import="java.util.*" %>
<%@ page import="java.net.URLEncoder"%>
<%@ page contentType="text/xml" pageEncoding="UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://commerce.ibm.com/base" prefix="wcbase"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib uri="http://commerce.ibm.com/foundation" prefix="wcf" %>
<%@ taglib uri="flow.tld" prefix="flow" %>

<%@ include file="Common/RestConfigSetup.jspf" %>
<%--
***
* Retrieve parameters for deciding how many URLs to create and the beginning index for the current iteration.
***
--%>
<c:set var="numberUrlsToGenerate" value="${param.numberUrlsToGenerate}" />
<c:if test="${empty numberUrlsToGenerate}">
	<c:set var="numberUrlsToGenerate" value="50000"/>
</c:if>

<c:set var="beginIndex" value="${param.beginIndex}" />
<c:if test="${empty beginIndex}">
	<c:set var="beginIndex" value="0"/>
</c:if>

<c:set var="maxUrlsToGenerate" value="${beginIndex+numberUrlsToGenerate}" />
<c:set var="urlCounter" value="0" />
<c:set var="constructedUrlCounter" value="0" />

<%--
***
* If the sitemapGenerate command is executed on a staging server, then the command need pass hostName to the jsp, where
* hostName is the serverName which will be hosting the sitemap xml file to be generated.
***
--%>

<c:set var="replaceHost" value="false"/>

<c:if test="${!empty param.hostName || !empty param.HostName}">
	<c:choose>
		<c:when test="${!empty param.hostName}">
			<c:set var="hostName" value="${param.hostName}"/>
		</c:when>
		<c:otherwise>
			<c:set var="hostName" value="${param.HostName}"/>
		</c:otherwise>
	</c:choose>
	<c:set var="contextHostName" value="${pageContext.request.serverName}"/>
	<c:set var="replaceHost" value="true"/>
</c:if>


<c:set var="replacePort" value="false"/>

<c:if test="${!empty param.portNumber || !empty param.PortNumber}">
	<c:choose>
		<c:when test="${!empty param.portNumber}">
			<c:set var="portNumber" value="${param.portNumber}"/>
		</c:when>
		<c:otherwise>
			<c:set var="portNumber" value="${param.PortNumber}"/>
		</c:otherwise>
	</c:choose>
	<c:set var="contextPortNumber" value="${pageContext.request.serverPort}"/>
	<c:set var="replacePort" value="true"/>
</c:if>

<wcf:useBean var="hardcodedSPAURLs" classname="java.util.ArrayList" />
<wcf:set target="${hardcodedSPAURLs}" value="https://localhost:4200/home" />
<wcf:set target="${hardcodedSPAURLs}" value="https://localhost:4200/contact-us" />
<wcf:set target="${hardcodedSPAURLs}" value="https://localhost:4200/our-story" />
<wcf:set target="${hardcodedSPAURLs}" value="https://localhost:4200/privacy-policy" />
<wcf:set target="${hardcodedSPAURLs}" value="https://localhost:4200/careers" />

<c:forEach var="anUrl" items="${hardcodedSPAURLs}">
	<c:set var="url" value="${anUrl}"/>
	<c:if test="${urlCounter >= beginIndex && urlCounter < maxUrlsToGenerate}">
		<c:if test="${replaceHost eq 'true'}">
			<c:set var="url" value="${fn:replace(anUrl,'localhost',hostName)}"/>
		</c:if>
		<c:if test="${replacePort eq 'true'}">			
			<c:set var="url" value="${fn:replace(anUrl,'4200',portNumber)}"/>
		</c:if>
		<url>
			<loc><c:out value="${url}" /></loc>
		</url>
		<c:set var="constructedUrlCounter" value="${constructedUrlCounter + 1}" />
	</c:if>
	<c:set var="urlCounter" value="${urlCounter + 1}" />
</c:forEach>

<!-- ResponseProperties?totalUrlCount=${constructedUrlCounter} -->

<%-- End - JSP File Name:  SEOSitemap.jsp --%>