package com.mycompany.search.internal.expression.postprocessor;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.persistence.EntityManager;
import javax.persistence.Query;

import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.search.exception.SearchApplicationException;
import com.ibm.commerce.search.expression.SearchCriteria;
import com.ibm.commerce.search.expression.SearchExpressionConstants;
import com.ibm.commerce.search.expression.processor.SearchQueryPostprocessor;
import com.ibm.commerce.search.internal.config.ValueMappingService;
import com.ibm.commerce.search.internal.database.SearchEntityManagerHelper;
import com.ibm.commerce.search.internal.expression.postprocessor.AbstractSearchQueryPostprocessor;

public class CustomizedGiftPostprocessor extends
AbstractSearchQueryPostprocessor implements SearchQueryPostprocessor{

	private static final String CLASSNAME = CustomizedGiftPostprocessor.class
			.getName();
	private static final Logger LOGGER = LoggingHelper
			.getLogger(CustomizedGiftPostprocessor.class);
	
	private static final String ISGIFT = "isGift";
	private static final String GIFTDESC = "giftDesc";
	
	public void invoke(SearchCriteria searchCriteria,
			Object... queryResponseObjects) throws SearchApplicationException {
		final String METHODNAME = "invoke(SearchCriteria, Object[])";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] {
					searchCriteria, queryResponseObjects });
		}

		super.invoke(searchCriteria, queryResponseObjects);
		
		ValueMappingService mappingService = ValueMappingService.getInstance();
		String resourceName = searchCriteria
				.getControlParameterValue(SearchExpressionConstants.CTRL_PARAM_SEARCH_INTERNAL_SERVICE_RESOURCE);
		
		String catalogEntryViewMapper = getMapperName(searchCriteria, resourceName,
				SearchExpressionConstants.CATALOG_ENTRY_VIEW);		
		// CatalogEntryView mapping
		String catalogEntryViewName = getExternalFieldName(mappingService,
				catalogEntryViewMapper,
				SearchExpressionConstants.INTERNAL_CATALOG_ENTRY_VIEW_NAME);
		String catalogEntryIdName = getExternalFieldName(mappingService,
				catalogEntryViewMapper,
				SearchExpressionConstants.CATENTRY_ID_SOLR_FIELD_NAME);
		
		List<Map<String, Object>> catalogEntryViews = (LinkedList<Map<String, Object>>) iSearchResponseObject
				.getResponse().get(catalogEntryViewName);
		
		if (catalogEntryViews != null && !catalogEntryViews.isEmpty()) {
			
			for (Map<String, Object> catalogEntryView : catalogEntryViews) {
				String catentryId = (String) catalogEntryView.get(catalogEntryIdName);
				
				List<Object[]> giftDataList = getDataFromGiftTable(catentryId);
				
				if(giftDataList!= null && giftDataList.size()>0){
					for(int i=0; i<giftDataList.size(); i++){
					Object[] giftData = giftDataList.get(i);
					Integer isGiftInt = (Integer) giftData[2];
					boolean isGift = "1".equals(isGiftInt.toString());
					Object giftDesc = giftData[3];					
					catalogEntryView.put(ISGIFT, isGift);					
					catalogEntryView.put(GIFTDESC, giftDesc);
					}
				}else{
					catalogEntryView.put(ISGIFT, false);
					catalogEntryView.put(GIFTDESC, null);
				}
			}
		}
		
		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}
	
	private List<Object[]> getDataFromGiftTable(String catentryId){
	
		final String METHODNAME = "getDataFromGiftTable()";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME);
		}
		String sqlQuery = "select * from XGIFT where CATENTRY_ID=" + catentryId;
		EntityManager em = SearchEntityManagerHelper.getInstance()
				.getEntityManager();
		Query query = em.createNativeQuery(sqlQuery);
		
		List resultList = query.getResultList();
		
		int len = resultList == null ? 0 : resultList.size();
		List<Object[]> results = new ArrayList<Object[]>(len);
		for (int j = 0; j < len; ++j) {
			Object row = resultList.get(j);
			if (row instanceof Object[]) {
				results.add((Object[]) row);
			} else {
				results.add(new Object[] { row });
			}
		}
	
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
		return results;
	}
	
}
