# wc-jpa-modeler

This project can be used to migrate your WebSphere Commerce Version 8 EJBs to Version 9 JPA Entities, and convert the code that depends on those changes, including class references, method references, and exceptions.

# Overview
  WebSphere Commerce Version 9 requires a migration from Enterprise Java Bean entities to Java Persistence API entities. In order to make this mandatory migration faster and more accurate, a tool is available to automatically perform this conversion via an Eclipse plugin.  The tool will convert EJB entities as well as access beans.  This document will provide instructions on how to install and configure this plugin, as well as how to execute the various steps to perform the migration of these entities.

# Installation
  The tool is provided in the format of an Eclipse plugin.  Eclipse plugins are packaged as jars and can be installed by placing the jar file in a monitored directory called "dropins".  Complete the following steps to install and configure the plugin in a WebSphere Commerce Developer Version 8 or Version 9 environment:
  1. Download the [WCJPA_plugin.zip](WCJPA_plugin.zip) package. 
  2. Extract the package to a temporary directory.
  3. Copy the plug-in JAR file to the following directory. If a subdirectory does not exist, create it. 
     ```
     SDP\dropins\jpamodeler\eclipse\plugins
     ```
  4. Restart the WC Toolkit
  5. Notice the new menu item "WCE JPA Tool"

# Configuration
  If you are using WebSphere Commerce Version 9, you can skip this section and proceed to generating and replacing the JPA entities.
  
  The tool will generate JPA entities within the same project and package as the matching EJB entity.  It is very important that everything compile before and during the generation process. Add the WebSphere Commerce JPA entity base classes to the classpath of ALL projects that contain EJB entity beans:

  1. Right click on the project in the Navigator/Project Explorer/Enterprise Explorer and select Properties
  2. Select Java Build Path from the Properties tree on the left side.
  3. Select the Libraries tab.
  4. Click on the "Add External JARs..." button.
  5. Navigate to the location of the WebSphere Commerce Version 9 version of the Enablement-BaseComponentsData.jar file. Select the jar and click on OK.
  6. Click on the Order and Export tab.  
  7. Select the Enablement-BaseComponentsData.jar file from the list and click on the Up button to move it to the very top of the list.
  8. Check the box next to the Enablement-BaseComponentsData.jar file to export the jar file to including projects.
  9. Repeat these steps for each project that contains entity EJB’s.

# Generate and Replace JPA Entities
  There JPA migration is broken down into two steps.
  
  1. *Generate the JPA entities*  The _generation_ can be invoked by selecting the WCE JPA Tool -> Generate JPA Entities menu item. JPA entities and access beans will be generated and placed in the same package as the matching EJB entity.  They will be named identical to the EJB entity, but will have a suffix of "JPA" initially.  After this step is complete, you should verify that all of the generated code compiled cleanly.  

  If there are errors in your EJB metadata, or your EJBs do not follow WC best practices, manual updates to the generated code may be necessary.  You may see a warning dialog popup during the execution of the generation step.  The tool attempts to display warnings in this dialog about discrepancies found in the EJB and DB schema metadata files that could impact the generated code.  If you see this warning, it is highly recommended to resolve the issues noted in the warning and run this step again before proceeding.

  2. *Delete and Rename* The _delete and rename_ can be invoked by selecting the WCE JPA Tool -> Replace Entity Beans. The EJBs and access beans will be removed and JPA entities will be renamed by removing the "JPA" suffix that added. When this step completes, verify that your entities are now JPA entities instead of EJB entities and that everything compiles cleanly.  

  You can now copy the generated JPA entities into a v9 WC Toolkit.

# Restore

  The tool tracks modified and generated files via metadata XML files that are saved at the root of each modified project.  At any point, you can use the WCE JPA Tool → Restore menu item to remove all generated JPA entities and access beans and replace them with the original EJB entities and access beans.  Do not alter or delete the metadata files or you will lose your ability to use this restore feature!

