/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.updaters;

import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.util.BackupUtil;
import com.ibm.commerce.jpa.updaters.EjbJarXmlUpdater;
import com.ibm.commerce.jpa.updaters.IbmEjbAccessBeanXmiUpdater;
import com.ibm.commerce.jpa.updaters.IbmEjbJarBndXmiUpdater;
import com.ibm.commerce.jpa.updaters.IbmEjbJarExtXmiUpdater;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

public class ModuleUpdater {
    private static final String META_INF = "META-INF";
    private static final String EJB_JAR_XML = "ejb-jar.xml";
    private static final String IBM_EJB_ACCESS_BEAN_XMI = "ibm-ejb-access-bean.xmi";
    private static final String IBM_EJB_JAR_EXT_XMI = "ibm-ejb-jar-ext.xmi";
    private static final String IBM_EJB_JAR_BND_XMI = "ibm-ejb-jar-bnd.xmi";
    private static final String USER_DEFINED_CONVERTERS_CMI = "UserDefinedConverters.xmi";
    private static final String TABLE_DDL = "Table.ddl";
    private static final String INDEX_DDL = "Index.ddl";
    private static final String DROP_TABLES_DDL = "dropTables.ddl";
    private static final String BACKENDS = "backends";
    private IWorkspace iWorkspace;
    private ModuleInfo iModuleInfo;
    private BackupUtil iBackupUtil;
    private IJavaProject iJavaProject;

    public ModuleUpdater(IWorkspace workspace, ModuleInfo moduleInfo) {
        this.iWorkspace = workspace;
        this.iModuleInfo = moduleInfo;
        this.iJavaProject = moduleInfo.getJavaProject();
        this.iBackupUtil = moduleInfo.getApplicationInfo().getBackupUtil(this.iJavaProject.getProject());
    }

    public IStatus update(IProgressMonitor progressMonitor) {
        IStatus status = Status.OK_STATUS;
        try {
            try {
                IClasspathEntry[] classpathEntries;
                progressMonitor.beginTask("update " + this.iJavaProject.getProject().getName(), 1400);
                IClasspathEntry[] iClasspathEntryArray = classpathEntries = this.iJavaProject.getResolvedClasspath(true);
                int n = classpathEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (progressMonitor.isCanceled()) {
                        status = Status.CANCEL_STATUS;
                        break;
                    }
                    if (entry.getEntryKind() == 3) {
                        IFolder backends;
                        IFile dropTablesDdlFile;
                        IFile indexDdlFile;
                        IFile tableDdlFile;
                        IFile userDefinedCreatorsFile;
                        IFile ibmEjbJarBndXmiFile;
                        IFile ibmEjbAccessBeanXmiFile;
                        IFile ibmEjbJarExtXmiFile;
                        IPath path = entry.getPath();
                        IFile ejbJarXmlFile = this.iWorkspace.getRoot().getFile(path.append(META_INF).append(EJB_JAR_XML));
                        if (ejbJarXmlFile.exists()) {
                            EjbJarXmlUpdater updater = new EjbJarXmlUpdater(ejbJarXmlFile, this.iModuleInfo);
                            updater.update((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                        }
                        if ((ibmEjbJarExtXmiFile = this.iWorkspace.getRoot().getFile(path.append(META_INF).append(IBM_EJB_JAR_EXT_XMI))).exists()) {
                            IbmEjbJarExtXmiUpdater updater = new IbmEjbJarExtXmiUpdater(ibmEjbJarExtXmiFile, this.iModuleInfo);
                            updater.update((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                        }
                        if ((ibmEjbAccessBeanXmiFile = this.iWorkspace.getRoot().getFile(path.append(META_INF).append(IBM_EJB_ACCESS_BEAN_XMI))).exists()) {
                            IbmEjbAccessBeanXmiUpdater updater = new IbmEjbAccessBeanXmiUpdater(ibmEjbAccessBeanXmiFile, this.iModuleInfo);
                            updater.update((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                        }
                        if ((ibmEjbJarBndXmiFile = this.iWorkspace.getRoot().getFile(path.append(META_INF).append(IBM_EJB_JAR_BND_XMI))).exists()) {
                            IbmEjbJarBndXmiUpdater updater = new IbmEjbJarBndXmiUpdater(ibmEjbJarBndXmiFile, this.iModuleInfo);
                            updater.update((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                        }
                        if ((userDefinedCreatorsFile = this.iWorkspace.getRoot().getFile(path.append(META_INF).append(USER_DEFINED_CONVERTERS_CMI))).exists()) {
                            this.iBackupUtil.backupFile3(userDefinedCreatorsFile, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                            userDefinedCreatorsFile.delete(true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                            this.iModuleInfo.getApplicationInfo().incrementDeleteCount();
                        }
                        if ((tableDdlFile = this.iWorkspace.getRoot().getFile(path.append(META_INF).append(TABLE_DDL))).exists()) {
                            this.iBackupUtil.backupFile3(tableDdlFile, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                            tableDdlFile.delete(true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                            this.iModuleInfo.getApplicationInfo().incrementDeleteCount();
                        }
                        if ((indexDdlFile = this.iWorkspace.getRoot().getFile(path.append(META_INF).append(INDEX_DDL))).exists()) {
                            this.iBackupUtil.backupFile3(indexDdlFile, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                            indexDdlFile.delete(true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                            this.iModuleInfo.getApplicationInfo().incrementDeleteCount();
                        }
                        if ((dropTablesDdlFile = this.iWorkspace.getRoot().getFile(path.append(META_INF).append(DROP_TABLES_DDL))).exists()) {
                            this.iBackupUtil.backupFile3(dropTablesDdlFile, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                            dropTablesDdlFile.delete(true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                            this.iModuleInfo.getApplicationInfo().incrementDeleteCount();
                        }
                        if ((backends = this.iWorkspace.getRoot().getFolder(path.append(META_INF).append(BACKENDS))).exists()) {
                            this.iBackupUtil.backupFolder3(backends, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                            backends.delete(true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                            this.iModuleInfo.getApplicationInfo().incrementDeleteCount();
                        }
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
                progressMonitor.done();
            }
            catch (CoreException e) {
                e.printStackTrace();
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
        return status;
    }
}

