/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.updaters;

import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.util.JavaUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class GeneratedTypeUpdater {
    private ASTParser iASTParser;
    private ApplicationInfo iApplicationInfo;
    private IType iType;
    private boolean iModified;

    public GeneratedTypeUpdater(ASTParser astParser, ApplicationInfo applicationInfo, IType type) {
        this.iASTParser = astParser;
        this.iApplicationInfo = applicationInfo;
        this.iType = type;
    }

    public void update(IProgressMonitor progressMonitor) {
        try {
            progressMonitor.beginTask("generated type update " + this.iType.getFullyQualifiedName('.'), -1);
            this.updateGeneratedType(progressMonitor);
        }
        finally {
            progressMonitor.done();
        }
    }

    public void updateGeneratedType(IProgressMonitor progressMonitor) {
        try {
            this.iASTParser.setProject(this.iType.getJavaProject());
            this.iASTParser.setSource(this.iType.getCompilationUnit());
            this.iASTParser.setResolveBindings(true);
            CompilationUnit astCompilationUnit = (CompilationUnit)this.iASTParser.createAST((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            astCompilationUnit.recordModifications();
            astCompilationUnit.accept((ASTVisitor)new GeneratedTypeUpdateVisitor());
            if (this.iModified) {
                IFile file = (IFile)this.iType.getCompilationUnit().getResource();
                this.iApplicationInfo.getBackupUtil(this.iType.getJavaProject().getProject()).backupFile2(file, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                IDocument document = JavaUtil.getDocument(this.iType);
                TextEdit edits = astCompilationUnit.rewrite(document, null);
                edits.apply(document);
                this.iType.getPackageFragment().createCompilationUnit(String.valueOf(this.iType.getTypeQualifiedName()) + ".java", document.get(), true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                this.iApplicationInfo.incrementGeneratedAssetCount();
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private class GeneratedTypeUpdateVisitor
    extends ASTVisitor {
        private GeneratedTypeUpdateVisitor() {
        }

        public boolean visit(SimpleName simpleName) {
            IBinding binding;
            if (!simpleName.isDeclaration() && (binding = simpleName.resolveBinding()) != null && binding.getKind() == 2) {
                ITypeBinding typeBinding = (ITypeBinding)binding;
                String qualifiedTypeName = typeBinding.getQualifiedName();
                String newTypeName = GeneratedTypeUpdater.this.iApplicationInfo.getTypeMapping(qualifiedTypeName);
                if (newTypeName != null) {
                    int index = newTypeName.lastIndexOf(".JPA");
                    if (index == -1) {
                        index = newTypeName.lastIndexOf(".$JPA");
                    }
                    if (index != -1 && (newTypeName = newTypeName.substring(index + 1)).indexOf(46) == -1) {
                        GeneratedTypeUpdater.this.iModified = true;
                        JavaUtil.replaceASTNode((ASTNode)simpleName, (ASTNode)simpleName.getAST().newName(newTypeName));
                    }
                }
            }
            return true;
        }

        public boolean visit(QualifiedName qualifiedName) {
            IBinding binding = qualifiedName.resolveBinding();
            if (binding != null && binding.getKind() == 2) {
                ITypeBinding typeBinding = (ITypeBinding)binding;
                String qualifiedTypeName = typeBinding.getQualifiedName();
                String newTypeName = GeneratedTypeUpdater.this.iApplicationInfo.getTypeMapping(qualifiedTypeName);
                if (newTypeName != null) {
                    GeneratedTypeUpdater.this.iModified = true;
                    JavaUtil.replaceASTNode((ASTNode)qualifiedName, (ASTNode)qualifiedName.getAST().newName(newTypeName));
                }
            }
            return false;
        }
    }
}

