/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.util;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.generators.PortVisitor;
import com.ibm.commerce.jpa.port.info.AccessBeanSubclassInfo;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.FieldInfo;
import com.ibm.commerce.jpa.port.info.FinderInfo;
import com.ibm.commerce.jpa.port.info.TargetExceptionInfo;
import com.ibm.commerce.jpa.port.info.UserMethodInfo;
import com.ibm.commerce.jpa.port.util.AccessBeanUtil;
import com.ibm.commerce.jpa.port.util.FinderResultCacheUtil;
import com.ibm.commerce.jpa.port.util.JavaUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;

public class TargetExceptionUtil {
    private static final Logger LOGGER = LoggerHelper.getLogger(TargetExceptionUtil.class);
    public static final String PERSISTENCE_EXCEPTION = "javax.persistence.PersistenceException";
    private static final String PROP_HANDLED_TARGET_EXCEPTIONS = "handledTargetExceptions";
    private static final String PROP_HANDLED_SOURCE_EXCEPTIONS = "handledSourceExceptions";
    private static final String PROP_PROMOTED_VARIABLE_DECLARATIONS = "promotedVariableDeclarations";
    private static final String PROP_TARGET_EXCEPTION = "targetException";
    private static final String PROP_SESSION_BEAN = "sessionBean";
    private static final String PROP_DISCARDED_CATCH_CLAUSE = "discardedCatchClause";
    private static final String EJB_OBJECT = "javax.ejb.EJBObject";
    private static final String EJB_LOCAL_OBJECT = "javax.ejb.EJBLocalObject";
    private static final String ABSTRACT_ACCESS_BEAN = "com.ibm.ivj.ejb.runtime.AbstractAccessBean";
    private static final String ABSTRACT_ENTITY_ACCESS_BEAN = "com.ibm.ivj.ejb.runtime.AbstractEntityAccessBean";
    private static final String EC_ENTITY_BEAN = "com.ibm.commerce.base.objects.ECEntityBean";
    private static final String REFRESH_ONCE_ACCESS_BEAN_HELPER = "com.ibm.commerce.datatype.RefreshOnceAccessBeanHelper";
    private static final String PRE_REFRESH_COPY_HELPER = "preRefreshCopyHelper";
    private static final String FIND = "find";
    private static final String FIND_BY_PRIMARY_KEY = "findByPrimaryKey";
    private static final String USING_JDBC = "UsingJDBC";
    private static final String SET = "set";
    private static final String GET = "get";
    private static final String GET_KEY = "__getKey";
    private static final String SET_INIT_KEY = "setInitKey_";
    private static final String IN_EJB_TYPE = "InEJBType";
    private static final String REFRESH_COPY_HELPER = "refreshCopyHelper";
    private static final String COMMIT_COPY_HELPER = "commitCopyHelper";
    private static final String GET_EJB_REF = "getEJBRef";
    private static final String REMOVE = "remove";
    private static final String GET_FALLBACK_DESCRIPTION = "getFallbackDescription";
    private static final String FULFILLS = "fulfills";
    private static final String FULFILLS_KEY = "fulfills+java.lang.Long+java.lang.String";
    private static final String GET_OWNER = "getOwner";
    private static final String GET_GROUPING_ATTRIBUTE_VALUE = "getGroupingAttributeValue";
    private static final String GET_GROUPING_ATTRIBUTE_VALUE_KEY = "getGroupingAttributeValue+java.lang.String+com.ibm.commerce.grouping.GroupingContext";
    private static final String REMOTE_EXCEPTION = "java.rmi.RemoteException";
    private static final String REMOTE_EXCEPTION_SIMPLE_NAME = "RemoteException";
    private static final String EJB_EXCEPTION = "javax.ejb.EJBException";
    private static final String EJB_EXCEPTION_SIMPLE_NAME = "EJBException";
    private static final String FINDER_EXCEPTION = "javax.ejb.FinderException";
    private static final String FINDER_EXCEPTION_SIMPLE_NAME = "FinderException";
    private static final String OBJECT_NOT_FOUND_EXCEPTION = "javax.ejb.ObjectNotFoundException";
    private static final String OBJECT_NOT_FOUND_EXCEPTION_SIMPLE_NAME = "ObjectNotFoundException";
    private static final String CREATE_EXCEPTION = "javax.ejb.CreateException";
    private static final String CREATE_EXCEPTION_SIMPLE_NAME = "CreateException";
    private static final String NAMING_EXCEPTION = "javax.naming.NamingException";
    private static final String DUPLICATE_KEY_EXCEPTION = "javax.ejb.DuplicateKeyException";
    private static final String DUPLICATE_KEY_EXCEPTION_SIMPLE_NAME = "DuplicateKeyException";
    private static final String THROWABLE = "java.lang.Throwable";
    private static final String EXCEPTION = "java.lang.Exception";
    private static final String RUNTIME_EXCEPTION = "java.lang.RuntimeException";
    private static final String ILLEGAL_ARGUMENT_EXCEPTION = "java.lang.IllegalArgumentException";
    private static final String NUMBER_FORMAT_EXCEPTION = "java.lang.NumberFormatException";
    private static final String SECURITY_EXCEPTION = "java.lang.SecurityException";
    private static final String ENTITY_EXISTS_EXCEPTION = "javax.persistence.EntityExistsException";
    private static final String ENTITY_NOT_FOUND_EXCEPTION = "javax.persistence.EntityNotFoundException";
    private static final String DOM_EXCEPTION = "org.w3c.dom.DOMException";
    private static final String TERM_COND_CREATE_EXCEPTION = "com.ibm.commerce.contract.helper.TermCondCreateException";
    private static final String NO_RESULT_EXCEPTION = "javax.persistence.NoResultException";
    private static final String IO_EXCEPTION = "java.io.IOException";
    private static final String SAX_EXCEPTION = "org.xml.sax.SAXException";
    private static final String SQL_EXCEPTION = "java.sql.SQLException";
    private static final String CLASS_CAST_EXCEPTION = "java.lang.ClassCastException";
    private static final String PARSE_CONFIGURATION_EXCEPTION = "javax.xml.parsers.ParserConfigurationException";
    private static final Map<String, String> EXCEPTION_SUPERTYPE_MAP = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> SIMPLE_NAME_EXCEPTION_MAP;
    private static final Map<String, Map<String, TargetExceptionInfo>> UNHANDLED_TARGET_EXCEPTIONS_MAP;

    static {
        EXCEPTION_SUPERTYPE_MAP.put(ENTITY_NOT_FOUND_EXCEPTION, PERSISTENCE_EXCEPTION);
        EXCEPTION_SUPERTYPE_MAP.put(ENTITY_EXISTS_EXCEPTION, PERSISTENCE_EXCEPTION);
        EXCEPTION_SUPERTYPE_MAP.put(NO_RESULT_EXCEPTION, PERSISTENCE_EXCEPTION);
        EXCEPTION_SUPERTYPE_MAP.put(PERSISTENCE_EXCEPTION, RUNTIME_EXCEPTION);
        EXCEPTION_SUPERTYPE_MAP.put(EJB_EXCEPTION, RUNTIME_EXCEPTION);
        EXCEPTION_SUPERTYPE_MAP.put(ILLEGAL_ARGUMENT_EXCEPTION, RUNTIME_EXCEPTION);
        EXCEPTION_SUPERTYPE_MAP.put(RUNTIME_EXCEPTION, EXCEPTION);
        EXCEPTION_SUPERTYPE_MAP.put(DUPLICATE_KEY_EXCEPTION, CREATE_EXCEPTION);
        EXCEPTION_SUPERTYPE_MAP.put(CREATE_EXCEPTION, EXCEPTION);
        EXCEPTION_SUPERTYPE_MAP.put(OBJECT_NOT_FOUND_EXCEPTION, FINDER_EXCEPTION);
        EXCEPTION_SUPERTYPE_MAP.put(FINDER_EXCEPTION, EXCEPTION);
        EXCEPTION_SUPERTYPE_MAP.put(EXCEPTION, THROWABLE);
        EXCEPTION_SUPERTYPE_MAP.put(NUMBER_FORMAT_EXCEPTION, ILLEGAL_ARGUMENT_EXCEPTION);
        EXCEPTION_SUPERTYPE_MAP.put(SECURITY_EXCEPTION, RUNTIME_EXCEPTION);
        EXCEPTION_SUPERTYPE_MAP.put(TERM_COND_CREATE_EXCEPTION, CREATE_EXCEPTION);
        EXCEPTION_SUPERTYPE_MAP.put(DOM_EXCEPTION, RUNTIME_EXCEPTION);
        EXCEPTION_SUPERTYPE_MAP.put(IO_EXCEPTION, EXCEPTION);
        EXCEPTION_SUPERTYPE_MAP.put(SAX_EXCEPTION, EXCEPTION);
        EXCEPTION_SUPERTYPE_MAP.put(SQL_EXCEPTION, EXCEPTION);
        EXCEPTION_SUPERTYPE_MAP.put(CLASS_CAST_EXCEPTION, RUNTIME_EXCEPTION);
        EXCEPTION_SUPERTYPE_MAP.put(NAMING_EXCEPTION, EXCEPTION);
        EXCEPTION_SUPERTYPE_MAP.put(REMOTE_EXCEPTION, IO_EXCEPTION);
        EXCEPTION_SUPERTYPE_MAP.put(PARSE_CONFIGURATION_EXCEPTION, EXCEPTION);
        SIMPLE_NAME_EXCEPTION_MAP = new HashMap<String, String>();
        SIMPLE_NAME_EXCEPTION_MAP.put(OBJECT_NOT_FOUND_EXCEPTION_SIMPLE_NAME, OBJECT_NOT_FOUND_EXCEPTION);
        SIMPLE_NAME_EXCEPTION_MAP.put(DUPLICATE_KEY_EXCEPTION_SIMPLE_NAME, DUPLICATE_KEY_EXCEPTION);
        SIMPLE_NAME_EXCEPTION_MAP.put(EJB_EXCEPTION_SIMPLE_NAME, EJB_EXCEPTION);
        SIMPLE_NAME_EXCEPTION_MAP.put(CREATE_EXCEPTION_SIMPLE_NAME, CREATE_EXCEPTION);
        SIMPLE_NAME_EXCEPTION_MAP.put(FINDER_EXCEPTION_SIMPLE_NAME, FINDER_EXCEPTION);
        SIMPLE_NAME_EXCEPTION_MAP.put(REMOTE_EXCEPTION_SIMPLE_NAME, REMOTE_EXCEPTION);
        UNHANDLED_TARGET_EXCEPTIONS_MAP = new HashMap<String, Map<String, TargetExceptionInfo>>();
        TargetExceptionInfo unhandledTargetExceptions = new TargetExceptionInfo();
        unhandledTargetExceptions.addTargetException(ENTITY_NOT_FOUND_EXCEPTION);
        unhandledTargetExceptions.addSourceException(OBJECT_NOT_FOUND_EXCEPTION);
        HashMap<String, TargetExceptionInfo> unhandledTargetExceptionsMethodMap = new HashMap<String, TargetExceptionInfo>();
        unhandledTargetExceptionsMethodMap.put("getFile+java.lang.String", unhandledTargetExceptions);
        unhandledTargetExceptionsMethodMap.put("setFile+byte[]+java.lang.String", new TargetExceptionInfo());
        UNHANDLED_TARGET_EXCEPTIONS_MAP.put("ManagedFile", unhandledTargetExceptionsMethodMap);
    }

    public static Collection<String> getFilteredExceptions(IJavaProject javaProject, Collection<String> exceptions) {
        HashSet<String> filteredExceptions = new HashSet<String>();
        for (String exception : exceptions) {
            boolean add = false;
            if (!TargetExceptionUtil.isRuntimeException(javaProject, exception)) {
                add = true;
                for (String filteredException : filteredExceptions) {
                    if (TargetExceptionUtil.catchHandlesException(javaProject, exception, filteredException)) {
                        filteredExceptions.remove(filteredException);
                        filteredExceptions.add(exception);
                        add = false;
                        break;
                    }
                    if (!TargetExceptionUtil.catchHandlesException(javaProject, filteredException, exception)) continue;
                    add = false;
                    break;
                }
            }
            if (!add) continue;
            filteredExceptions.add(exception);
        }
        return filteredExceptions;
    }

    public static TargetExceptionInfo getUnhandledTargetExceptions(ApplicationInfo applicationInfo, IJavaProject javaProject, ASTNode astNode) {
        ExceptionVisitor exceptionVisitor = new ExceptionVisitor(applicationInfo, javaProject);
        if (astNode != null) {
            astNode.accept((ASTVisitor)exceptionVisitor);
        }
        return exceptionVisitor.getUnhandledTargetExceptions();
    }

    public static TargetExceptionInfo getEntityReferencingTypeUnhandledTargetExceptions(ApplicationInfo applicationInfo, IJavaProject javaProject, ASTNode astNode) {
        ExceptionVisitor exceptionVisitor = new ExceptionVisitor(applicationInfo, javaProject, true);
        if (astNode != null) {
            astNode.accept((ASTVisitor)exceptionVisitor);
        }
        return exceptionVisitor.getUnhandledTargetExceptions();
    }

    public static TargetExceptionInfo getEjbMethodUnhandledTargetExceptions(EntityInfo entityInfo, String methodKey) {
        TargetExceptionInfo unhandledTargetExceptions = entityInfo.getEjbMethodUnhandledTargetExceptions(methodKey);
        if (unhandledTargetExceptions == null) {
            if (UNHANDLED_TARGET_EXCEPTIONS_MAP.get(entityInfo.getEjbName()) != null && UNHANDLED_TARGET_EXCEPTIONS_MAP.get(entityInfo.getEjbName()).containsKey(methodKey)) {
                unhandledTargetExceptions = UNHANDLED_TARGET_EXCEPTIONS_MAP.get(entityInfo.getEjbName()).get(methodKey);
            } else if (entityInfo.getSupertype() != null && entityInfo.getSupertype().getEjbMethodDeclarations(methodKey) != null) {
                unhandledTargetExceptions = TargetExceptionUtil.getEjbMethodUnhandledTargetExceptions(entityInfo.getSupertype(), methodKey);
            } else if (entityInfo.getSubtypes() != null) {
                unhandledTargetExceptions = new TargetExceptionInfo();
                Set<EntityInfo> subtypes = entityInfo.getSubtypes();
                for (EntityInfo subtype : subtypes) {
                    List<MethodDeclaration> methodDeclarations = subtype.getEjbMethodDeclarations(methodKey);
                    if (methodDeclarations != null) {
                        for (MethodDeclaration methodDeclaration : methodDeclarations) {
                            unhandledTargetExceptions.addAll(TargetExceptionUtil.getUnhandledTargetExceptions(subtype.getModuleInfo().getApplicationInfo(), subtype.getModuleInfo().getJavaProject(), (ASTNode)methodDeclaration.getBody()));
                        }
                    }
                    subtype.setEjbMethodUnhandledTargetExceptions(methodKey, unhandledTargetExceptions);
                }
            } else {
                unhandledTargetExceptions = new TargetExceptionInfo();
                List<MethodDeclaration> methodDeclarations = entityInfo.getEjbMethodDeclarations(methodKey);
                if (methodDeclarations != null) {
                    for (MethodDeclaration methodDeclaration : methodDeclarations) {
                        unhandledTargetExceptions.addAll(TargetExceptionUtil.getUnhandledTargetExceptions(entityInfo.getModuleInfo().getApplicationInfo(), entityInfo.getModuleInfo().getJavaProject(), (ASTNode)methodDeclaration.getBody()));
                    }
                }
            }
            entityInfo.setEjbMethodUnhandledTargetExceptions(methodKey, unhandledTargetExceptions);
        }
        return unhandledTargetExceptions;
    }

    public static TargetExceptionInfo getAccessBeanMethodUnhandledTargetExceptions(EntityInfo entityInfo, String methodKey) {
        TargetExceptionInfo unhandledTargetExceptions = new TargetExceptionInfo();
        String methodName = JavaUtil.getMethodName(methodKey);
        String[] parameterTypes = JavaUtil.getParameterTypes(methodKey);
        UserMethodInfo userMethodInfo = entityInfo.getUserMethodInfo(methodKey);
        if (userMethodInfo != null) {
            unhandledTargetExceptions.addAll(TargetExceptionUtil.getEjbMethodUnhandledTargetExceptions(entityInfo, methodKey));
        } else if (JavaUtil.isConstructor(methodKey)) {
            if (parameterTypes.length > 1 || parameterTypes.length == 1 && !EJB_OBJECT.equals(parameterTypes[0])) {
                unhandledTargetExceptions.addTargetException(ENTITY_EXISTS_EXCEPTION);
            }
        } else if (methodName.startsWith(FIND)) {
            FinderInfo finderInfo = entityInfo.getFinderInfo(methodKey);
            if (finderInfo != null) {
                unhandledTargetExceptions.addAll(finderInfo.getTargetExceptions());
            }
        } else if (entityInfo.getProtectable() && (GET_OWNER.equals(methodKey) || FULFILLS_KEY.equals(methodKey))) {
            unhandledTargetExceptions.addTargetException(EXCEPTION);
        } else if (entityInfo.getGroupable() && GET_GROUPING_ATTRIBUTE_VALUE_KEY.equals(methodKey)) {
            unhandledTargetExceptions.addTargetException(EXCEPTION);
        } else if (methodName.startsWith(GET) && parameterTypes.length == 0 && entityInfo.getFieldInfoByGetterName(methodName) != null || methodName.endsWith(IN_EJB_TYPE)) {
            FieldInfo fieldInfo = entityInfo.getFieldInfoByGetterName(methodName);
            if (fieldInfo == null && methodName.endsWith(IN_EJB_TYPE)) {
                fieldInfo = entityInfo.getFieldInfoByGetterName(methodName.substring(0, methodName.lastIndexOf(IN_EJB_TYPE)));
            }
            if (fieldInfo != null && !fieldInfo.getIsKeyField()) {
                unhandledTargetExceptions.addTargetException(ENTITY_NOT_FOUND_EXCEPTION);
            }
        } else if (!(methodName.startsWith(SET) && parameterTypes.length == 1 && entityInfo.getFieldInfoBySetterName(methodName) != null || methodName.startsWith(SET_INIT_KEY))) {
            if (REFRESH_COPY_HELPER.equals(methodName)) {
                unhandledTargetExceptions.addTargetException(ENTITY_NOT_FOUND_EXCEPTION);
            } else if (!COMMIT_COPY_HELPER.equals(methodName) && !GET_KEY.equals(methodName)) {
                LOGGER.info("unknown access bean method: " + methodKey);
            }
        }
        return unhandledTargetExceptions;
    }

    public static TargetExceptionInfo getAccessBeanSubclassMethodUnhandledTargetExceptions(AccessBeanSubclassInfo accessBeanSubclassInfo, String methodKey) {
        TargetExceptionInfo unhandledTargetExceptions;
        if ("com.ibm.commerce.catalog.beans.CatalogEntryDataBean".equals(accessBeanSubclassInfo.getName()) && methodKey.equals("populate")) {
            LOGGER.info("com.ibm.commerce.catalog.beans.CatalogEntryDataBean");
        }
        if ("com.ibm.commerce.giftregistry.beans.GiftRegistryCatalogEntryDataBean".equals(accessBeanSubclassInfo.getName()) && methodKey.equals("populate")) {
            LOGGER.info("com.ibm.commerce.giftregistry.beans.GiftRegistryCatalogEntryDataBean");
        }
        if ((unhandledTargetExceptions = accessBeanSubclassInfo.getMethodUnhandledTargetExceptions(methodKey)) == null && accessBeanSubclassInfo.hasMethod(methodKey)) {
            MethodDeclaration methodDeclaration;
            TargetExceptionInfo currentUnhandledTargetExceptions;
            HashSet<AccessBeanSubclassInfo> newAccessBeanSubclasses;
            EntityInfo entityInfo = accessBeanSubclassInfo.getEntityInfo();
            boolean isAccessBeanMethod = entityInfo.isEjbAccessBeanMethod(methodKey);
            AccessBeanSubclassInfo baseAccessBeanSubclassInfo = accessBeanSubclassInfo;
            AccessBeanSubclassInfo current = accessBeanSubclassInfo.getSuperclass();
            while (current != null) {
                if (current.hasMethod(methodKey)) {
                    baseAccessBeanSubclassInfo = current;
                }
                current = current.getSuperclass();
            }
            HashSet<AccessBeanSubclassInfo> accessBeanSubclasses = new HashSet<AccessBeanSubclassInfo>();
            accessBeanSubclasses.add(baseAccessBeanSubclassInfo);
            while (!accessBeanSubclasses.isEmpty()) {
                newAccessBeanSubclasses = new HashSet<AccessBeanSubclassInfo>();
                for (AccessBeanSubclassInfo current2 : accessBeanSubclasses) {
                    if (current2.hasMethod(methodKey)) {
                        currentUnhandledTargetExceptions = new TargetExceptionInfo();
                        current2.setMethodUnhandledTargetExceptions(methodKey, currentUnhandledTargetExceptions);
                        methodDeclaration = current2.getMethodDeclaration(methodKey);
                        if (methodDeclaration != null) {
                            if (isAccessBeanMethod) {
                                currentUnhandledTargetExceptions.addAll(TargetExceptionUtil.getAccessBeanMethodUnhandledTargetExceptions(entityInfo, methodKey));
                            } else {
                                currentUnhandledTargetExceptions.addAll(TargetExceptionUtil.getUnhandledTargetExceptions(current2.getProjectInfo().getApplicationInfo(), current2.getProjectInfo().getJavaProject(), (ASTNode)methodDeclaration));
                                if (!JavaUtil.isConstructor(methodKey)) {
                                    AccessBeanSubclassInfo base = current2.getSuperclass();
                                    while (base != null) {
                                        if (base.hasMethod(methodKey)) {
                                            base.getMethodUnhandledTargetExceptions(methodKey).addAll(currentUnhandledTargetExceptions);
                                        }
                                        base = base.getSuperclass();
                                    }
                                }
                            }
                        }
                    }
                    newAccessBeanSubclasses.addAll(current2.getSubclasses());
                }
                accessBeanSubclasses = newAccessBeanSubclasses;
            }
            accessBeanSubclasses.clear();
            accessBeanSubclasses.add(baseAccessBeanSubclassInfo);
            while (!accessBeanSubclasses.isEmpty()) {
                newAccessBeanSubclasses = new HashSet();
                for (AccessBeanSubclassInfo current2 : accessBeanSubclasses) {
                    if (current2.hasMethod(methodKey)) {
                        currentUnhandledTargetExceptions = current2.getMethodUnhandledTargetExceptions(methodKey);
                        methodDeclaration = current2.getMethodDeclaration(methodKey);
                        if (methodDeclaration != null) {
                            if (!isAccessBeanMethod) {
                                currentUnhandledTargetExceptions.addAll(TargetExceptionUtil.getUnhandledTargetExceptions(current2.getProjectInfo().getApplicationInfo(), current2.getProjectInfo().getJavaProject(), (ASTNode)methodDeclaration));
                            }
                            current2.releaseMethodDeclaration(methodKey);
                        }
                    }
                    newAccessBeanSubclasses.addAll(current2.getSubclasses());
                }
                accessBeanSubclasses = newAccessBeanSubclasses;
            }
            unhandledTargetExceptions = accessBeanSubclassInfo.getMethodUnhandledTargetExceptions(methodKey);
        }
        return unhandledTargetExceptions;
    }

    public static void portTryStatement(IJavaProject javaProject, TryStatement tryStatement, PortVisitor portVisitor, boolean entityReferencingType) {
        block47: {
            List catchClauses;
            boolean dropsThrough;
            block48: {
                String exceptionType;
                AST ast = tryStatement.getAST();
                dropsThrough = false;
                Block tryStatementBlock = tryStatement.getBody();
                if (TargetExceptionUtil.isDropThroughStatement((Statement)tryStatementBlock)) {
                    dropsThrough = true;
                }
                if ((catchClauses = tryStatement.catchClauses()).size() <= 0) break block47;
                int i = 0;
                while (i < catchClauses.size()) {
                    CatchClause catchClause = (CatchClause)catchClauses.get(i);
                    SingleVariableDeclaration exceptionDeclaration = catchClause.getException();
                    ITypeBinding exceptionTypeBinding = exceptionDeclaration.getType().resolveBinding();
                    exceptionType = exceptionTypeBinding != null ? exceptionTypeBinding.getQualifiedName() : exceptionDeclaration.getType().toString();
                    Collection handledTargetExceptions = (Collection)catchClause.getProperty(PROP_HANDLED_TARGET_EXCEPTIONS);
                    Collection handledSourceExceptions = (Collection)catchClause.getProperty(PROP_HANDLED_SOURCE_EXCEPTIONS);
                    if (handledTargetExceptions == null || handledTargetExceptions.isEmpty()) {
                        if (!entityReferencingType || !TargetExceptionUtil.isRuntimeException(javaProject, exceptionType) && (!EXCEPTION.equals(exceptionType) && !THROWABLE.equals(exceptionType) || handledSourceExceptions != null && !handledSourceExceptions.isEmpty())) {
                            catchClauses.remove(i);
                            --i;
                        }
                    } else if (handledTargetExceptions.size() == 1) {
                        for (String handledException : handledTargetExceptions) {
                            if (portVisitor.getTypeMapping(handledException) != null) {
                                handledException = portVisitor.getTypeMapping(handledException);
                            }
                            if (TargetExceptionUtil.catchHandlesException(javaProject, exceptionType, handledException)) continue;
                            SingleVariableDeclaration newExceptionDeclaration = ast.newSingleVariableDeclaration();
                            newExceptionDeclaration.setType((Type)ast.newSimpleType(ast.newName(handledException)));
                            newExceptionDeclaration.setName(ast.newSimpleName(exceptionDeclaration.getName().getIdentifier()));
                            portVisitor.replaceASTNode((ASTNode)exceptionDeclaration, (ASTNode)newExceptionDeclaration);
                            catchClause.getBody().accept((ASTVisitor)new CatchClauseVisitor(handledTargetExceptions));
                        }
                    } else {
                        boolean catchUsed = false;
                        HashSet<String> unhandledExceptions = new HashSet<String>();
                        for (String handledException : handledTargetExceptions) {
                            if (TargetExceptionUtil.catchHandlesException(javaProject, exceptionType, handledException)) {
                                catchUsed = true;
                                continue;
                            }
                            unhandledExceptions.add(handledException);
                        }
                        if (unhandledExceptions.size() > 0) {
                            String targetExceptionType = null;
                            String secondTargetExceptionType = null;
                            if (FINDER_EXCEPTION.equals(exceptionType) || OBJECT_NOT_FOUND_EXCEPTION.equals(exceptionType)) {
                                if (unhandledExceptions.size() == 2 && unhandledExceptions.contains(NO_RESULT_EXCEPTION) && unhandledExceptions.contains(ENTITY_NOT_FOUND_EXCEPTION)) {
                                    targetExceptionType = NO_RESULT_EXCEPTION;
                                    secondTargetExceptionType = ENTITY_NOT_FOUND_EXCEPTION;
                                } else if (unhandledExceptions.size() == 1) {
                                    Iterator iterator = unhandledExceptions.iterator();
                                    while (iterator.hasNext()) {
                                        String unhandledException;
                                        targetExceptionType = unhandledException = (String)iterator.next();
                                    }
                                }
                            } else if (CREATE_EXCEPTION.equals(exceptionType) || DUPLICATE_KEY_EXCEPTION.equals(exceptionType)) {
                                targetExceptionType = ENTITY_EXISTS_EXCEPTION;
                            } else if (REMOTE_EXCEPTION.equals(exceptionType) || EJB_EXCEPTION.equals(exceptionType)) {
                                targetExceptionType = PERSISTENCE_EXCEPTION;
                            }
                            if (targetExceptionType == null) {
                                LOGGER.info("unhandledExceptions but could not determine target exception :");
                                for (String unhandledException : unhandledExceptions) {
                                    LOGGER.info("\t" + unhandledException);
                                }
                            } else {
                                Block newCatchBody;
                                SingleVariableDeclaration newExceptionDeclaration;
                                CatchClause newCatchClause;
                                if (!catchUsed) {
                                    exceptionDeclaration.setType((Type)ast.newSimpleType(ast.newName(targetExceptionType)));
                                } else {
                                    newCatchClause = ast.newCatchClause();
                                    newExceptionDeclaration = ast.newSingleVariableDeclaration();
                                    newExceptionDeclaration.setType((Type)ast.newSimpleType(ast.newName(targetExceptionType)));
                                    newExceptionDeclaration.setName(ast.newSimpleName(exceptionDeclaration.getName().getIdentifier()));
                                    newCatchClause.setException(newExceptionDeclaration);
                                    newCatchBody = (Block)ASTNode.copySubtree((AST)ast, (ASTNode)catchClause.getBody());
                                    newCatchClause.setBody(newCatchBody);
                                    catchClauses.add(++i, newCatchClause);
                                    newCatchClause.getBody().accept((ASTVisitor)new CatchClauseVisitor(unhandledExceptions));
                                }
                                if (secondTargetExceptionType != null) {
                                    newCatchClause = ast.newCatchClause();
                                    newExceptionDeclaration = ast.newSingleVariableDeclaration();
                                    newExceptionDeclaration.setType((Type)ast.newSimpleType(ast.newName(secondTargetExceptionType)));
                                    newExceptionDeclaration.setName(ast.newSimpleName(exceptionDeclaration.getName().getIdentifier()));
                                    newCatchClause.setException(newExceptionDeclaration);
                                    newCatchBody = (Block)ASTNode.copySubtree((AST)ast, (ASTNode)catchClause.getBody());
                                    newCatchClause.setBody(newCatchBody);
                                    catchClauses.add(++i, newCatchClause);
                                    newCatchClause.getBody().accept((ASTVisitor)new CatchClauseVisitor(unhandledExceptions));
                                }
                            }
                        }
                    }
                    ++i;
                }
                int persistenceExceptionPosition = -1;
                int i2 = 0;
                while (i2 < catchClauses.size()) {
                    CatchClause catchClause = (CatchClause)catchClauses.get(i2);
                    SingleVariableDeclaration exceptionDeclaration = catchClause.getException();
                    exceptionType = exceptionDeclaration.getType().toString();
                    if (PERSISTENCE_EXCEPTION.equals(exceptionType)) {
                        persistenceExceptionPosition = i2;
                    } else if (persistenceExceptionPosition != -1 && (ENTITY_EXISTS_EXCEPTION.equals(exceptionType) || NO_RESULT_EXCEPTION.equals(exceptionType) || ENTITY_NOT_FOUND_EXCEPTION.equals(exceptionType))) {
                        catchClause.delete();
                        CatchClause persistenceExceptionCatchClause = (CatchClause)catchClauses.get(persistenceExceptionPosition);
                        persistenceExceptionCatchClause.delete();
                        catchClauses.add(persistenceExceptionPosition, catchClause);
                        catchClauses.add(i2, persistenceExceptionCatchClause);
                    }
                    ++i2;
                }
                if (catchClauses.size() != 0 || tryStatement.getFinally() != null) break block48;
                List statements = tryStatementBlock.statements();
                if (tryStatement.getParent().getNodeType() == 8) {
                    int i3 = 0;
                    while (i3 < statements.size()) {
                        Statement statement = (Statement)statements.get(i3);
                        if (statement.getNodeType() == 60) {
                            VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)statement;
                            List variableDeclarationFragments = variableDeclarationStatement.fragments();
                            int j = 0;
                            while (j < variableDeclarationFragments.size()) {
                                VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)variableDeclarationFragments.get(j);
                                String variableName = variableDeclarationFragment.getName().getIdentifier();
                                if (TargetExceptionUtil.isPromotedVariable(tryStatement.getParent(), variableName)) {
                                    variableDeclarationFragments.remove(j);
                                    --j;
                                    if (variableDeclarationFragment.getInitializer() != null) {
                                        Expression initializer = variableDeclarationFragment.getInitializer();
                                        initializer.delete();
                                        Assignment assignment = ast.newAssignment();
                                        assignment.setLeftHandSide((Expression)ast.newName(variableName));
                                        assignment.setOperator(Assignment.Operator.ASSIGN);
                                        assignment.setRightHandSide(initializer);
                                        ExpressionStatement expressionStatement = ast.newExpressionStatement((Expression)assignment);
                                        statements.add(i3, expressionStatement);
                                        ++i3;
                                    }
                                } else {
                                    HashSet<String> promotedVariableDeclarationStatements = (HashSet<String>)tryStatement.getParent().getProperty(PROP_PROMOTED_VARIABLE_DECLARATIONS);
                                    if (promotedVariableDeclarationStatements == null) {
                                        promotedVariableDeclarationStatements = new HashSet<String>();
                                        tryStatement.getParent().setProperty(PROP_PROMOTED_VARIABLE_DECLARATIONS, promotedVariableDeclarationStatements);
                                    }
                                    promotedVariableDeclarationStatements.add(variableName);
                                }
                                ++j;
                            }
                            if (variableDeclarationFragments.size() == 0) {
                                statements.remove(i3);
                                --i3;
                            }
                        }
                        ++i3;
                    }
                }
                if (tryStatementBlock.getProperty(PROP_PROMOTED_VARIABLE_DECLARATIONS) != null) {
                    Collection promotedVariableDeclarationStatements = (Collection)tryStatementBlock.getProperty(PROP_PROMOTED_VARIABLE_DECLARATIONS);
                    Collection parentPromotedVariableDeclarationStatements = (Collection)tryStatement.getParent().getProperty(PROP_PROMOTED_VARIABLE_DECLARATIONS);
                    if (parentPromotedVariableDeclarationStatements == null) {
                        tryStatement.getParent().setProperty(PROP_PROMOTED_VARIABLE_DECLARATIONS, (Object)promotedVariableDeclarationStatements);
                    } else {
                        parentPromotedVariableDeclarationStatements.addAll(promotedVariableDeclarationStatements);
                    }
                }
                Statement lastStatement = statements.size() > 0 ? (Statement)statements.get(statements.size() - 1) : null;
                portVisitor.replaceStatement((Statement)tryStatement, statements);
                if (lastStatement == null || !TargetExceptionUtil.isReturnStatement(lastStatement) || lastStatement.getParent().getNodeType() != 8) break block47;
                Block parentBlock = (Block)lastStatement.getParent();
                List parentBlockStatements = parentBlock.statements();
                while (parentBlockStatements.size() > 0 && parentBlockStatements.get(parentBlockStatements.size() - 1) != lastStatement) {
                    parentBlockStatements.remove(parentBlockStatements.size() - 1);
                }
                break block47;
            }
            for (CatchClause catchClause : catchClauses) {
                if (dropsThrough || !TargetExceptionUtil.isDropThroughStatement((Statement)catchClause.getBody())) continue;
                dropsThrough = true;
            }
            if (!dropsThrough && tryStatement.getParent().getNodeType() == 8) {
                Block parentBlock = (Block)tryStatement.getParent();
                List parentBlockStatements = parentBlock.statements();
                while (parentBlockStatements.size() > 1 && parentBlockStatements.get(parentBlockStatements.size() - 1) != tryStatement) {
                    parentBlockStatements.remove(parentBlockStatements.size() - 1);
                }
            }
        }
    }

    private static boolean isReturnStatement(Statement statement) {
        boolean result = false;
        switch (statement.getNodeType()) {
            case 41: {
                result = true;
                break;
            }
            case 8: {
                Block block = (Block)statement;
                List statements = block.statements();
                if (statements.size() <= 0) break;
                result = TargetExceptionUtil.isReturnStatement((Statement)statements.get(statements.size() - 1));
                break;
            }
            case 25: {
                IfStatement ifStatement = (IfStatement)statement;
                if (ifStatement.getElseStatement() == null) break;
                result = TargetExceptionUtil.isReturnStatement(ifStatement.getThenStatement()) && TargetExceptionUtil.isReturnStatement(ifStatement.getElseStatement());
            }
        }
        return result;
    }

    private static boolean isPromotedVariable(ASTNode astNode, String variableName) {
        boolean result = false;
        while (astNode != null && astNode.getNodeType() != 31 && astNode.getNodeType() != 28) {
            Collection promotedVariableDeclarations = (Collection)astNode.getProperty(PROP_PROMOTED_VARIABLE_DECLARATIONS);
            if (promotedVariableDeclarations != null && promotedVariableDeclarations.contains(variableName)) {
                result = true;
                break;
            }
            astNode = astNode.getParent();
        }
        return result;
    }

    public static boolean portVariableDeclarationStatement(VariableDeclarationStatement variableDeclarationStatement, PortVisitor childVisitor) {
        boolean visitChildren = true;
        AST ast = variableDeclarationStatement.getAST();
        ArrayList<ExpressionStatement> newStatements = null;
        List variableDeclarationFragments = variableDeclarationStatement.fragments();
        int j = 0;
        while (j < variableDeclarationFragments.size()) {
            VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)variableDeclarationFragments.get(j);
            String variableName = variableDeclarationFragment.getName().getIdentifier();
            if (TargetExceptionUtil.isPromotedVariable(variableDeclarationStatement.getParent(), variableName)) {
                variableDeclarationFragments.remove(j);
                --j;
                if (variableDeclarationFragment.getInitializer() != null) {
                    Expression initializer = variableDeclarationFragment.getInitializer();
                    initializer.accept((ASTVisitor)childVisitor);
                    initializer.delete();
                    Assignment assignment = ast.newAssignment();
                    assignment.setLeftHandSide((Expression)ast.newName(variableName));
                    assignment.setOperator(Assignment.Operator.ASSIGN);
                    assignment.setRightHandSide(initializer);
                    ExpressionStatement expressionStatement = ast.newExpressionStatement((Expression)assignment);
                    if (newStatements == null) {
                        newStatements = new ArrayList<ExpressionStatement>();
                    }
                    newStatements.add(expressionStatement);
                }
            }
            ++j;
        }
        if (newStatements != null) {
            visitChildren = false;
            if (variableDeclarationFragments.size() > 0) {
                variableDeclarationStatement.accept((ASTVisitor)childVisitor);
                newStatements.add((ExpressionStatement)((Statement)ASTNode.copySubtree((AST)ast, (ASTNode)variableDeclarationStatement)));
            }
            childVisitor.replaceStatement((Statement)variableDeclarationStatement, newStatements);
        }
        return visitChildren;
    }

    public static void portThrowStatement(ThrowStatement throwStatement, boolean entityReferencingType) {
        Expression throwExpression = throwStatement.getExpression();
        ITypeBinding typeBinding = throwExpression.resolveTypeBinding();
        if (typeBinding != null) {
            String exception = typeBinding.getQualifiedName();
            String targetException = null;
            if (OBJECT_NOT_FOUND_EXCEPTION.equals(exception) || FINDER_EXCEPTION.equals(exception)) {
                targetException = ENTITY_NOT_FOUND_EXCEPTION;
            } else if (DUPLICATE_KEY_EXCEPTION.equals(exception) || CREATE_EXCEPTION.equals(exception)) {
                targetException = ENTITY_EXISTS_EXCEPTION;
            } else if (EJB_EXCEPTION.equals(exception) || REMOTE_EXCEPTION.equals(exception)) {
                targetException = PERSISTENCE_EXCEPTION;
            }
            if (targetException != null && (!entityReferencingType || targetException.equals(throwStatement.getProperty(PROP_TARGET_EXCEPTION))) && throwExpression.getNodeType() == 14) {
                ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)throwExpression;
                classInstanceCreation.setType((Type)classInstanceCreation.getAST().newSimpleType(classInstanceCreation.getAST().newName(targetException)));
            }
        }
    }

    public static boolean catchHandlesException(IJavaProject javaProject, String catchException, String exception) {
        boolean handlesException = false;
        while (exception != null) {
            if (exception.equals(catchException)) {
                handlesException = true;
                break;
            }
            exception = TargetExceptionUtil.getExceptionSupertype(javaProject, exception);
        }
        return handlesException;
    }

    public static boolean catchHandlesTargetException(IJavaProject javaProject, String catchException, String targetException) {
        boolean handlesException = TargetExceptionUtil.catchHandlesException(javaProject, catchException, targetException);
        if (!handlesException) {
            if ((targetException.equals(NO_RESULT_EXCEPTION) || targetException.equals(ENTITY_NOT_FOUND_EXCEPTION)) && (catchException.equals(FINDER_EXCEPTION) || catchException.equals(OBJECT_NOT_FOUND_EXCEPTION))) {
                handlesException = true;
            } else if (targetException.equals(ENTITY_EXISTS_EXCEPTION) && (catchException.equals(CREATE_EXCEPTION) || catchException.equals(DUPLICATE_KEY_EXCEPTION))) {
                handlesException = true;
            } else if (targetException.equals(PERSISTENCE_EXCEPTION) && (catchException.equals(REMOTE_EXCEPTION) || catchException.equals(EJB_EXCEPTION))) {
                handlesException = true;
            }
        }
        return handlesException;
    }

    public static boolean isRuntimeException(IJavaProject javaProject, String exception) {
        boolean runtimeException = false;
        while (exception != null) {
            if (RUNTIME_EXCEPTION.equals(exception)) {
                runtimeException = true;
                break;
            }
            exception = TargetExceptionUtil.getExceptionSupertype(javaProject, exception);
        }
        return runtimeException;
    }

    public static boolean isDropThroughStatement(Statement statement) {
        boolean dropsThrough = true;
        if (statement != null) {
            switch (statement.getNodeType()) {
                case 25: {
                    IfStatement ifStatement = (IfStatement)statement;
                    if (TargetExceptionUtil.isDropThroughStatement(ifStatement.getThenStatement()) || TargetExceptionUtil.isDropThroughStatement(ifStatement.getElseStatement())) break;
                    dropsThrough = false;
                    break;
                }
                case 41: {
                    dropsThrough = false;
                    break;
                }
                case 53: {
                    dropsThrough = false;
                    break;
                }
                case 8: {
                    Statement lastStatement;
                    Block block = (Block)statement;
                    List statements = block.statements();
                    if (statements.size() <= 0 || TargetExceptionUtil.isDropThroughStatement(lastStatement = (Statement)statements.get(statements.size() - 1))) break;
                    dropsThrough = false;
                }
            }
        }
        return dropsThrough;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getExceptionSupertype(IJavaProject javaProject, String exception) {
        String exceptionSupertype = null;
        if (THROWABLE.equals(exception)) return exceptionSupertype;
        if (EXCEPTION_SUPERTYPE_MAP.containsKey(exception)) return EXCEPTION_SUPERTYPE_MAP.get(exception);
        try {
            IType exceptionType = javaProject.findType(exception);
            if (exceptionType == null) {
                LOGGER.info("unable to find exception type " + exception);
                return EXCEPTION_SUPERTYPE_MAP.get(exception);
            } else {
                while (exceptionType.getSuperclassName() != null && !EXCEPTION_SUPERTYPE_MAP.containsKey(exceptionType.getFullyQualifiedName())) {
                    IType superClassType = exceptionType.isBinary() ? exceptionType.getJavaProject().findType(exceptionType.getSuperclassName()) : JavaUtil.resolveType(exceptionType, exceptionType.getSuperclassName());
                    EXCEPTION_SUPERTYPE_MAP.put(exceptionType.getFullyQualifiedName(), superClassType.getFullyQualifiedName());
                    exceptionType = superClassType;
                }
            }
            return EXCEPTION_SUPERTYPE_MAP.get(exception);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return EXCEPTION_SUPERTYPE_MAP.get(exception);
    }

    private static class CatchClauseVisitor
    extends ASTVisitor {
        private Collection<String> iHandledTargetExceptions;

        public CatchClauseVisitor(Collection<String> handledTargetExceptions) {
            this.iHandledTargetExceptions = handledTargetExceptions;
        }

        public boolean visit(SimpleName simpleName) {
            String targetExceptionType;
            String exceptionType = (String)SIMPLE_NAME_EXCEPTION_MAP.get(simpleName.getIdentifier());
            if (exceptionType != null && (targetExceptionType = this.getTargetExceptionType(exceptionType)) != null) {
                JavaUtil.replaceASTNode((ASTNode)simpleName, (ASTNode)simpleName.getAST().newName(targetExceptionType));
            }
            return false;
        }

        public boolean visit(QualifiedName qualifiedName) {
            String targetExceptionType = this.getTargetExceptionType(qualifiedName.getFullyQualifiedName());
            if (targetExceptionType != null) {
                JavaUtil.replaceASTNode((ASTNode)qualifiedName, (ASTNode)qualifiedName.getAST().newName(targetExceptionType));
            }
            return false;
        }

        private String getTargetExceptionType(String exceptionType) {
            String targetExceptionType = null;
            if (TargetExceptionUtil.FINDER_EXCEPTION.equals(exceptionType) || TargetExceptionUtil.OBJECT_NOT_FOUND_EXCEPTION.equals(exceptionType)) {
                if (this.iHandledTargetExceptions.contains(TargetExceptionUtil.NO_RESULT_EXCEPTION) && this.iHandledTargetExceptions.contains(TargetExceptionUtil.ENTITY_NOT_FOUND_EXCEPTION)) {
                    targetExceptionType = TargetExceptionUtil.PERSISTENCE_EXCEPTION;
                } else if (this.iHandledTargetExceptions.contains(TargetExceptionUtil.NO_RESULT_EXCEPTION)) {
                    targetExceptionType = TargetExceptionUtil.NO_RESULT_EXCEPTION;
                } else if (this.iHandledTargetExceptions.contains(TargetExceptionUtil.ENTITY_NOT_FOUND_EXCEPTION)) {
                    targetExceptionType = TargetExceptionUtil.ENTITY_NOT_FOUND_EXCEPTION;
                }
            } else if (TargetExceptionUtil.CREATE_EXCEPTION.equals(exceptionType) || TargetExceptionUtil.DUPLICATE_KEY_EXCEPTION.equals(exceptionType)) {
                targetExceptionType = TargetExceptionUtil.ENTITY_EXISTS_EXCEPTION;
            }
            return targetExceptionType;
        }
    }

    private static class ExceptionVisitor
    extends ASTVisitor {
        private ApplicationInfo iApplicationInfo;
        private IJavaProject iJavaProject;
        private boolean iEntityReferencingType = false;
        private TargetExceptionInfo iTargetExceptionInfo = new TargetExceptionInfo();
        private Deque<TryStatement> iTryStatementStack = new ArrayDeque<TryStatement>();
        private Deque<CatchClause> iCatchClauseStack = new ArrayDeque<CatchClause>();

        public ExceptionVisitor(ApplicationInfo applicationInfo, IJavaProject javaProject) {
            this.iApplicationInfo = applicationInfo;
            this.iJavaProject = javaProject;
        }

        public ExceptionVisitor(ApplicationInfo applicationInfo, IJavaProject javaProject, boolean entityReferencingType) {
            this.iApplicationInfo = applicationInfo;
            this.iJavaProject = javaProject;
            this.iEntityReferencingType = true;
        }

        public boolean visit(Block block) {
            if (block.getParent().getNodeType() == 54) {
                TryStatement tryStatement = (TryStatement)block.getParent();
                if (tryStatement.getBody() == block) {
                    this.iTryStatementStack.push(tryStatement);
                }
            } else if (block.getParent().getNodeType() == 12) {
                CatchClause catchClause = (CatchClause)block.getParent();
                this.iCatchClauseStack.push(catchClause);
            }
            return true;
        }

        public void endVisit(Block node) {
            if (this.iTryStatementStack.size() > 0 && this.iTryStatementStack.peek().getBody() == node) {
                this.iTryStatementStack.pop();
            }
            if (this.iCatchClauseStack.size() > 0 && this.iCatchClauseStack.peek().getBody() == node) {
                this.iCatchClauseStack.pop();
            }
        }

        public boolean visit(ClassInstanceCreation classInstanceCreation) {
            IMethodBinding methodBinding = classInstanceCreation.resolveConstructorBinding();
            if (methodBinding != null) {
                this.processUnhandledExceptions(methodBinding, null, null);
            }
            return true;
        }

        public boolean visit(MethodInvocation methodInvocation) {
            IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
            if (methodBinding != null) {
                MethodInvocation methodExpressionMethodInvocation;
                Expression methodExpression = methodInvocation.getExpression();
                if (methodExpression != null && methodExpression.getNodeType() == 32 && (methodExpressionMethodInvocation = (MethodInvocation)methodExpression).getExpression() != null && TargetExceptionUtil.GET_EJB_REF.equals(methodExpressionMethodInvocation.getName().getIdentifier()) && !AccessBeanUtil.isAccessBeanType(this.iApplicationInfo, methodExpressionMethodInvocation.getExpression())) {
                    methodExpression.setProperty(TargetExceptionUtil.PROP_SESSION_BEAN, (Object)Boolean.TRUE);
                    methodExpressionMethodInvocation.getExpression().setProperty(TargetExceptionUtil.PROP_SESSION_BEAN, (Object)Boolean.TRUE);
                }
                this.processUnhandledExceptions(methodBinding, methodInvocation, methodExpression);
            }
            return true;
        }

        public boolean visit(SuperMethodInvocation superMethodInvocation) {
            String declaringClassType;
            IMethodBinding methodBinding = superMethodInvocation.resolveMethodBinding();
            if (methodBinding != null && !this.iApplicationInfo.isEntityType(declaringClassType = methodBinding.getDeclaringClass().getQualifiedName())) {
                this.processUnhandledExceptions(methodBinding, null, null);
            }
            return true;
        }

        public boolean visit(CatchClause catchClause) {
            String exceptionType;
            boolean visitChildren = true;
            Block block = catchClause.getBody();
            if (this.iEntityReferencingType && block.statements().size() == 0 && catchClause.getProperty(TargetExceptionUtil.PROP_HANDLED_TARGET_EXCEPTIONS) == null) {
                String exceptionType2;
                SingleVariableDeclaration exceptionDeclaration = catchClause.getException();
                ITypeBinding exceptionTypeBinding = exceptionDeclaration.getType().resolveBinding();
                String string = exceptionType2 = exceptionTypeBinding != null ? exceptionTypeBinding.getQualifiedName() : exceptionDeclaration.getType().toString();
                if (TargetExceptionUtil.OBJECT_NOT_FOUND_EXCEPTION.equals(exceptionType2) || TargetExceptionUtil.FINDER_EXCEPTION.equals(exceptionType2)) {
                    this.addHandledTargetException(catchClause, TargetExceptionUtil.ENTITY_NOT_FOUND_EXCEPTION);
                }
            }
            Collection handledTargetExceptions = (Collection)catchClause.getProperty(TargetExceptionUtil.PROP_HANDLED_TARGET_EXCEPTIONS);
            Collection handledSourceExceptions = (Collection)catchClause.getProperty(TargetExceptionUtil.PROP_HANDLED_SOURCE_EXCEPTIONS);
            SingleVariableDeclaration exceptionDeclaration = catchClause.getException();
            ITypeBinding exceptionTypeBinding = exceptionDeclaration.getType().resolveBinding();
            String string = exceptionType = exceptionTypeBinding != null ? exceptionTypeBinding.getQualifiedName() : exceptionDeclaration.getType().toString();
            if (!(handledTargetExceptions != null && !handledTargetExceptions.isEmpty() || this.iEntityReferencingType && (TargetExceptionUtil.isRuntimeException(this.iJavaProject, exceptionType) || (TargetExceptionUtil.EXCEPTION.equals(exceptionType) || TargetExceptionUtil.THROWABLE.equals(exceptionType)) && (handledSourceExceptions == null || handledSourceExceptions.isEmpty())))) {
                catchClause.setProperty(TargetExceptionUtil.PROP_DISCARDED_CATCH_CLAUSE, (Object)Boolean.TRUE);
                visitChildren = false;
            }
            return visitChildren;
        }

        public boolean visit(ThrowStatement throwStatement) {
            Expression throwExpression = throwStatement.getExpression();
            ITypeBinding exceptionTypeBinding = throwExpression.resolveTypeBinding();
            if (exceptionTypeBinding != null) {
                String sourceExceptionType;
                String targetExceptionType = sourceExceptionType = exceptionTypeBinding.getQualifiedName();
                if (throwExpression.getNodeType() == 14 && !this.iEntityReferencingType) {
                    if (TargetExceptionUtil.OBJECT_NOT_FOUND_EXCEPTION.equals(sourceExceptionType) || TargetExceptionUtil.FINDER_EXCEPTION.equals(sourceExceptionType)) {
                        targetExceptionType = TargetExceptionUtil.ENTITY_NOT_FOUND_EXCEPTION;
                    } else if (TargetExceptionUtil.DUPLICATE_KEY_EXCEPTION.equals(sourceExceptionType) || TargetExceptionUtil.CREATE_EXCEPTION.equals(sourceExceptionType)) {
                        targetExceptionType = TargetExceptionUtil.ENTITY_EXISTS_EXCEPTION;
                    } else if (TargetExceptionUtil.EJB_EXCEPTION.equals(sourceExceptionType) || TargetExceptionUtil.REMOTE_EXCEPTION.equals(sourceExceptionType)) {
                        targetExceptionType = TargetExceptionUtil.PERSISTENCE_EXCEPTION;
                    }
                } else if (this.iCatchClauseStack.size() > 0) {
                    CatchClause catchClause = this.iCatchClauseStack.peek();
                    Collection handledTargetExceptions = (Collection)catchClause.getProperty(TargetExceptionUtil.PROP_HANDLED_TARGET_EXCEPTIONS);
                    if (TargetExceptionUtil.OBJECT_NOT_FOUND_EXCEPTION.equals(sourceExceptionType) || TargetExceptionUtil.FINDER_EXCEPTION.equals(sourceExceptionType)) {
                        if (handledTargetExceptions.contains(TargetExceptionUtil.ENTITY_NOT_FOUND_EXCEPTION)) {
                            targetExceptionType = TargetExceptionUtil.ENTITY_NOT_FOUND_EXCEPTION;
                        } else if (handledTargetExceptions.contains(TargetExceptionUtil.NO_RESULT_EXCEPTION)) {
                            targetExceptionType = TargetExceptionUtil.NO_RESULT_EXCEPTION;
                        }
                    } else if ((TargetExceptionUtil.DUPLICATE_KEY_EXCEPTION.equals(sourceExceptionType) || TargetExceptionUtil.CREATE_EXCEPTION.equals(sourceExceptionType)) && handledTargetExceptions.contains(TargetExceptionUtil.ENTITY_EXISTS_EXCEPTION)) {
                        targetExceptionType = TargetExceptionUtil.ENTITY_EXISTS_EXCEPTION;
                    }
                }
                if (this.isUnhandledTargetException(targetExceptionType)) {
                    this.iTargetExceptionInfo.addTargetException(targetExceptionType);
                } else {
                    throwStatement.setProperty(TargetExceptionUtil.PROP_TARGET_EXCEPTION, (Object)targetExceptionType);
                }
                if (this.isUnhandledSourceException(sourceExceptionType)) {
                    this.iTargetExceptionInfo.addSourceException(sourceExceptionType);
                }
            }
            return true;
        }

        private void processUnhandledExceptions(IMethodBinding methodBinding, MethodInvocation methodInvocation, Expression methodExpression) {
            block14: {
                ITypeBinding[] sourceExceptionTypes;
                block27: {
                    String declaringClassType;
                    String methodName;
                    block26: {
                        String methodKey;
                        block24: {
                            block25: {
                                block23: {
                                    block22: {
                                        block21: {
                                            block20: {
                                                block17: {
                                                    ITypeBinding returnTypeBinding;
                                                    block19: {
                                                        block18: {
                                                            block16: {
                                                                EntityInfo entityInfo;
                                                                block15: {
                                                                    if (methodBinding == null) break block14;
                                                                    sourceExceptionTypes = methodBinding.getExceptionTypes();
                                                                    if (sourceExceptionTypes != null) {
                                                                        ITypeBinding[] iTypeBindingArray = sourceExceptionTypes;
                                                                        int n = sourceExceptionTypes.length;
                                                                        int n2 = 0;
                                                                        while (n2 < n) {
                                                                            ITypeBinding sourceExceptionType = iTypeBindingArray[n2];
                                                                            if (this.isUnhandledSourceException(sourceExceptionType)) {
                                                                                this.iTargetExceptionInfo.addSourceException(sourceExceptionType.getQualifiedName());
                                                                            }
                                                                            ++n2;
                                                                        }
                                                                    }
                                                                    methodName = methodBinding.getName();
                                                                    methodKey = JavaUtil.getMethodKey(methodBinding);
                                                                    declaringClassType = methodBinding.getDeclaringClass().getQualifiedName();
                                                                    entityInfo = this.iApplicationInfo.getEntityInfoForType(declaringClassType);
                                                                    if (!this.iApplicationInfo.isAccessBeanType(declaringClassType)) break block15;
                                                                    TargetExceptionInfo targetExceptionInfo = TargetExceptionUtil.getAccessBeanMethodUnhandledTargetExceptions(entityInfo, methodKey);
                                                                    Collection<String> targetExceptions = targetExceptionInfo.getTargetExceptions();
                                                                    for (String targetException : targetExceptions) {
                                                                        if (!this.isUnhandledTargetException(targetException)) continue;
                                                                        this.iTargetExceptionInfo.addTargetException(targetException);
                                                                    }
                                                                    Collection<String> sourceExceptions = targetExceptionInfo.getSourceExceptions();
                                                                    for (String string : sourceExceptions) {
                                                                        if (!this.isUnhandledSourceException(string)) continue;
                                                                        this.iTargetExceptionInfo.addSourceException(string);
                                                                    }
                                                                    break block14;
                                                                }
                                                                if (!this.iApplicationInfo.isEntityType(declaringClassType)) break block16;
                                                                TargetExceptionInfo targetExceptionInfo = TargetExceptionUtil.getEjbMethodUnhandledTargetExceptions(entityInfo, methodKey);
                                                                Collection<String> targetExceptions = targetExceptionInfo.getTargetExceptions();
                                                                for (String targetException : targetExceptions) {
                                                                    if (!this.isUnhandledTargetException(targetException)) continue;
                                                                    this.iTargetExceptionInfo.addTargetException(targetException);
                                                                }
                                                                Collection<String> sourceExceptions = targetExceptionInfo.getSourceExceptions();
                                                                for (String string : sourceExceptions) {
                                                                    if (!this.isUnhandledSourceException(string)) continue;
                                                                    this.iTargetExceptionInfo.addSourceException(string);
                                                                }
                                                                break block14;
                                                            }
                                                            if (this.iApplicationInfo.isHomeInterfaceType(declaringClassType)) break block14;
                                                            if (!FinderResultCacheUtil.isFinderResultCacheUtil(methodBinding.getDeclaringClass())) break block17;
                                                            if (FinderResultCacheUtil.isNewAccessBeanMethod(methodName)) break block14;
                                                            if (!methodName.startsWith(TargetExceptionUtil.FIND) || !methodName.endsWith(TargetExceptionUtil.USING_JDBC)) break block18;
                                                            if (sourceExceptionTypes == null) break block14;
                                                            ITypeBinding[] iTypeBindingArray = sourceExceptionTypes;
                                                            int sourceExceptions = sourceExceptionTypes.length;
                                                            int targetExceptions = 0;
                                                            while (targetExceptions < sourceExceptions) {
                                                                ITypeBinding exceptionType = iTypeBindingArray[targetExceptions];
                                                                if (this.isUnhandledTargetException(exceptionType)) {
                                                                    this.iTargetExceptionInfo.addTargetException(exceptionType.getQualifiedName());
                                                                }
                                                                ++targetExceptions;
                                                            }
                                                            break block14;
                                                        }
                                                        if (!methodName.equals(TargetExceptionUtil.FIND_BY_PRIMARY_KEY)) break block19;
                                                        ITypeBinding returnTypeBinding2 = methodBinding.getReturnType();
                                                        if (returnTypeBinding2 == null || !this.iApplicationInfo.isAccessBeanType(returnTypeBinding2.getQualifiedName()) || !this.isUnhandledTargetException(TargetExceptionUtil.ENTITY_NOT_FOUND_EXCEPTION)) break block14;
                                                        this.iTargetExceptionInfo.addTargetException(TargetExceptionUtil.ENTITY_NOT_FOUND_EXCEPTION);
                                                        break block14;
                                                    }
                                                    if (!methodName.startsWith(TargetExceptionUtil.FIND) || (returnTypeBinding = methodBinding.getReturnType()) == null || !this.iApplicationInfo.isAccessBeanType(returnTypeBinding.getQualifiedName()) || !this.isUnhandledTargetException(TargetExceptionUtil.NO_RESULT_EXCEPTION)) break block14;
                                                    this.iTargetExceptionInfo.addTargetException(TargetExceptionUtil.NO_RESULT_EXCEPTION);
                                                    break block14;
                                                }
                                                if (!TargetExceptionUtil.EJB_OBJECT.equals(declaringClassType) || methodExpression != null && methodExpression.getProperty(TargetExceptionUtil.PROP_SESSION_BEAN) != null) break block20;
                                                methodName.equals(TargetExceptionUtil.REMOVE);
                                                break block14;
                                            }
                                            if (!TargetExceptionUtil.EJB_LOCAL_OBJECT.equals(declaringClassType)) break block21;
                                            methodName.equals(TargetExceptionUtil.REMOVE);
                                            break block14;
                                        }
                                        if (!TargetExceptionUtil.ABSTRACT_ACCESS_BEAN.equals(declaringClassType) || methodExpression != null && methodExpression.getProperty(TargetExceptionUtil.PROP_SESSION_BEAN) != null) break block22;
                                        methodName.equals(TargetExceptionUtil.GET_EJB_REF);
                                        break block14;
                                    }
                                    if (!TargetExceptionUtil.ABSTRACT_ENTITY_ACCESS_BEAN.equals(declaringClassType)) break block23;
                                    methodName.equals(TargetExceptionUtil.GET_KEY);
                                    break block14;
                                }
                                if (!TargetExceptionUtil.EC_ENTITY_BEAN.equals(declaringClassType)) break block24;
                                if (!methodName.equals(TargetExceptionUtil.GET_FALLBACK_DESCRIPTION)) break block25;
                                if (!this.isUnhandledTargetException(TargetExceptionUtil.ENTITY_NOT_FOUND_EXCEPTION)) break block14;
                                this.iTargetExceptionInfo.addTargetException(TargetExceptionUtil.ENTITY_NOT_FOUND_EXCEPTION);
                                break block14;
                            }
                            if (!methodName.equals(TargetExceptionUtil.FULFILLS) && !methodName.equals(TargetExceptionUtil.GET_OWNER) && !methodName.equals(TargetExceptionUtil.GET_GROUPING_ATTRIBUTE_VALUE) || !this.isUnhandledTargetException(TargetExceptionUtil.EXCEPTION)) break block14;
                            this.iTargetExceptionInfo.addTargetException(TargetExceptionUtil.EXCEPTION);
                            break block14;
                        }
                        if (!this.iApplicationInfo.isAccessBeanSubclass(declaringClassType)) break block26;
                        TargetExceptionInfo targetExceptionInfo = TargetExceptionUtil.getAccessBeanSubclassMethodUnhandledTargetExceptions(this.iApplicationInfo.getAccessBeanSubclassInfoForType(declaringClassType), methodKey);
                        if (targetExceptionInfo == null) break block14;
                        Collection<String> targetExceptions = targetExceptionInfo.getTargetExceptions();
                        for (String targetException : targetExceptions) {
                            if (!this.isUnhandledTargetException(targetException)) continue;
                            this.iTargetExceptionInfo.addTargetException(targetException);
                        }
                        Collection<String> sourceExceptions = targetExceptionInfo.getSourceExceptions();
                        for (String string : sourceExceptions) {
                            if (!this.isUnhandledSourceException(string)) continue;
                            this.iTargetExceptionInfo.addSourceException(string);
                        }
                        break block14;
                    }
                    if (!TargetExceptionUtil.REFRESH_ONCE_ACCESS_BEAN_HELPER.equals(declaringClassType)) break block27;
                    if (!methodName.equals(TargetExceptionUtil.PRE_REFRESH_COPY_HELPER) || !this.isUnhandledTargetException(TargetExceptionUtil.ENTITY_NOT_FOUND_EXCEPTION)) break block14;
                    this.iTargetExceptionInfo.addTargetException(TargetExceptionUtil.ENTITY_NOT_FOUND_EXCEPTION);
                    break block14;
                }
                if (sourceExceptionTypes != null) {
                    ITypeBinding[] iTypeBindingArray = sourceExceptionTypes;
                    int n = sourceExceptionTypes.length;
                    int n3 = 0;
                    while (n3 < n) {
                        ITypeBinding exceptionType = iTypeBindingArray[n3];
                        if (this.isUnhandledTargetException(exceptionType)) {
                            this.iTargetExceptionInfo.addTargetException(exceptionType.getQualifiedName());
                        }
                        ++n3;
                    }
                }
            }
        }

        private boolean isUnhandledSourceException(ITypeBinding exceptionTypeBinding) {
            boolean handled = false;
            if (exceptionTypeBinding != null) {
                for (TryStatement tryStatement : this.iTryStatementStack) {
                    List catchClauses = tryStatement.catchClauses();
                    for (CatchClause catchClause : catchClauses) {
                        SingleVariableDeclaration exceptionDeclaration = catchClause.getException();
                        ITypeBinding handledException = exceptionDeclaration.getType().resolveBinding();
                        if (handledException == null) {
                            LOGGER.info("handledException is null");
                        }
                        if (exceptionTypeBinding.equals((Object)handledException) || exceptionTypeBinding.isSubTypeCompatible(handledException)) {
                            this.addHandledSourceException(catchClause, exceptionTypeBinding.getQualifiedName());
                            handled = true;
                            break;
                        }
                        if (!handledException.isSubTypeCompatible(exceptionTypeBinding)) continue;
                        this.addHandledSourceException(catchClause, handledException.getQualifiedName());
                    }
                    if (handled) break;
                }
            }
            return !handled;
        }

        private boolean isUnhandledSourceException(String exception) {
            boolean handled = false;
            for (TryStatement tryStatement : this.iTryStatementStack) {
                List catchClauses = tryStatement.catchClauses();
                for (CatchClause catchClause : catchClauses) {
                    SingleVariableDeclaration exceptionDeclaration = catchClause.getException();
                    String handledException = exceptionDeclaration.getType().resolveBinding().getQualifiedName();
                    if (TargetExceptionUtil.catchHandlesException(this.iJavaProject, handledException, exception)) {
                        this.addHandledSourceException(catchClause, exception);
                        handled = true;
                        break;
                    }
                    if (!TargetExceptionUtil.catchHandlesException(this.iJavaProject, exception, handledException)) continue;
                    this.addHandledSourceException(catchClause, handledException);
                }
                if (handled) break;
            }
            return !handled;
        }

        private void addHandledSourceException(CatchClause catchClause, String exception) {
            HashSet<String> handledExceptions = (HashSet<String>)catchClause.getProperty(TargetExceptionUtil.PROP_HANDLED_SOURCE_EXCEPTIONS);
            if (handledExceptions == null) {
                handledExceptions = new HashSet<String>();
                catchClause.setProperty(TargetExceptionUtil.PROP_HANDLED_SOURCE_EXCEPTIONS, handledExceptions);
            }
            handledExceptions.add(exception);
        }

        private boolean isUnhandledTargetException(ITypeBinding exceptionTypeBinding) {
            boolean handled = false;
            if (exceptionTypeBinding != null) {
                for (TryStatement tryStatement : this.iTryStatementStack) {
                    List catchClauses = tryStatement.catchClauses();
                    for (CatchClause catchClause : catchClauses) {
                        SingleVariableDeclaration exceptionDeclaration = catchClause.getException();
                        ITypeBinding handledException = exceptionDeclaration.getType().resolveBinding();
                        if (handledException == null) {
                            LOGGER.info("handledException is null");
                        }
                        if (exceptionTypeBinding.equals((Object)handledException) || exceptionTypeBinding.isSubTypeCompatible(handledException)) {
                            this.addHandledTargetException(catchClause, exceptionTypeBinding.getQualifiedName());
                            handled = true;
                            break;
                        }
                        if (!handledException.isSubTypeCompatible(exceptionTypeBinding)) continue;
                        this.addHandledTargetException(catchClause, handledException.getQualifiedName());
                    }
                    if (handled) break;
                }
            }
            return !handled;
        }

        private boolean isUnhandledTargetException(String exception) {
            boolean handled = false;
            for (TryStatement tryStatement : this.iTryStatementStack) {
                List catchClauses = tryStatement.catchClauses();
                for (CatchClause catchClause : catchClauses) {
                    SingleVariableDeclaration exceptionDeclaration = catchClause.getException();
                    String handledException = exceptionDeclaration.getType().resolveBinding().getQualifiedName();
                    if (TargetExceptionUtil.catchHandlesTargetException(this.iJavaProject, handledException, exception)) {
                        this.addHandledTargetException(catchClause, exception);
                        handled = true;
                        break;
                    }
                    if (!TargetExceptionUtil.catchHandlesTargetException(this.iJavaProject, exception, handledException)) continue;
                    this.addHandledTargetException(catchClause, handledException);
                }
                if (handled) break;
            }
            return !handled;
        }

        private void addHandledTargetException(CatchClause catchClause, String exception) {
            HashSet<String> handledExceptions = (HashSet<String>)catchClause.getProperty(TargetExceptionUtil.PROP_HANDLED_TARGET_EXCEPTIONS);
            if (handledExceptions == null) {
                handledExceptions = new HashSet<String>();
                catchClause.setProperty(TargetExceptionUtil.PROP_HANDLED_TARGET_EXCEPTIONS, handledExceptions);
            }
            handledExceptions.add(exception);
        }

        public TargetExceptionInfo getUnhandledTargetExceptions() {
            return this.iTargetExceptionInfo;
        }
    }
}

