/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.util;

import com.ibm.commerce.jpa.port.Activator;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.osgi.framework.Bundle;

public class JPASeederUtilBase {
    private ApplicationInfo iApplicationInfo;
    private Collection<IProject> iBuildPendingProjects;
    private String iSourceDirectoryName;
    private boolean iMarkAsGenerated;
    private Activator iPlugin;

    public JPASeederUtilBase(ApplicationInfo applicationInfo, Collection<IProject> buildPendingProjects, String sourceDirectoryName, boolean markAsGenerated) {
        this.iApplicationInfo = applicationInfo;
        this.iBuildPendingProjects = buildPendingProjects;
        this.iSourceDirectoryName = sourceDirectoryName;
        this.iMarkAsGenerated = markAsGenerated;
        this.iPlugin = Activator.getDefault();
    }

    public void seedNewClasses(IProgressMonitor progressMonitor) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            File projectsDirectory;
            File[] projects;
            File pluginLocation = FileLocator.getBundleFile((Bundle)this.iPlugin.getBundle());
            if (pluginLocation.isDirectory() && (projects = (projectsDirectory = new File(pluginLocation, this.iSourceDirectoryName)).listFiles()) != null) {
                File[] fileArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    File projectSourceDirectory = fileArray[n2];
                    IProject project = root.getProject(projectSourceDirectory.getName());
                    if (project != null) {
                        this.seedProject(project, projectSourceDirectory, progressMonitor);
                        this.iBuildPendingProjects.add(project);
                    }
                    ++n2;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void seedProject(IProject project, File sourceDirectory, IProgressMonitor progressMonitor) throws CoreException {
        File[] files;
        File[] fileArray = files = sourceDirectory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder folder;
            File file = fileArray[n2];
            if (file.isDirectory() && (folder = project.getFolder(file.getName())).exists()) {
                this.seedFolder(project, folder, file, progressMonitor);
            }
            ++n2;
        }
    }

    private void seedFolder(IProject project, IFolder targetFolder, File sourceDirectory, IProgressMonitor progressMonitor) throws CoreException {
        File[] files;
        File[] fileArray = files = sourceDirectory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                IFolder folder = targetFolder.getFolder(file.getName());
                if (!folder.exists()) {
                    folder.create(true, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                }
                this.seedFolder(project, folder, file, progressMonitor);
            } else {
                this.seedFile(project, targetFolder, file, progressMonitor);
            }
            ++n2;
        }
    }

    private void seedFile(IProject project, IFolder targetFolder, File sourceFile, IProgressMonitor progressMonitor) throws CoreException {
        try {
            IFile file = targetFolder.getFile(sourceFile.getName());
            FileInputStream inputStream = new FileInputStream(sourceFile);
            if (file.exists()) {
                if (!this.iMarkAsGenerated) {
                    this.saveGeneratedFile(project, file, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                }
                file.setContents((InputStream)inputStream, true, false, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            } else {
                file.create((InputStream)inputStream, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            }
            if (this.iMarkAsGenerated) {
                this.iApplicationInfo.getBackupUtil(project).addGeneratedFile(file, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void saveGeneratedFile(IProject project, IFile generatedFile, IProgressMonitor progressMonitor) {
        try {
            try {
                IFile backupFile;
                progressMonitor.beginTask("backup2 " + generatedFile.getName(), 200);
                IFolder generatedFilesBackupFolder = project.getFolder(".jpaGeneratedFilesBackupFolder");
                if (!generatedFilesBackupFolder.exists()) {
                    generatedFilesBackupFolder.create(true, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                }
                if (!(backupFile = generatedFilesBackupFolder.getFile(generatedFile.getProjectRelativePath())).exists()) {
                    IFolder parentFolder = (IFolder)backupFile.getParent();
                    this.createFolder(parentFolder, progressMonitor);
                    backupFile.create(generatedFile.getContents(), true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private void createFolder(IFolder folder, IProgressMonitor progressMonitor) throws CoreException {
        if (!folder.exists()) {
            IFolder parentFolder = (IFolder)folder.getParent();
            this.createFolder(parentFolder, progressMonitor);
            folder.create(true, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
        }
    }
}

