/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.util;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.util.JavaUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class ImportUtil {
    private static final Logger LOGGER = LoggerHelper.getLogger(ImportUtil.class);
    private static String[] IMPORT_ORDER = new String[]{"java", "javax", "org", "com"};

    public static void appendImports(List<ImportDeclaration> importDeclarations, StringBuilder sb) {
        for (ImportDeclaration importDeclaration : importDeclarations) {
            sb.append("import ");
            sb.append(importDeclaration.getName().getFullyQualifiedName());
            if (importDeclaration.isOnDemand()) {
                sb.append(".*");
            }
            sb.append(";\r\n");
        }
    }

    public static void appendImports(Expression expression, StringBuilder sb) {
        expression.accept((ASTVisitor)new StringBuilderImportTypeVisitor(sb));
    }

    /*
     * Loose catch block
     */
    public static void resolveImports(ASTParser astParser, ICompilationUnit compilationUnit, IProgressMonitor progressMonitor) {
        try {
            try {
                progressMonitor.beginTask("resolve imports for " + compilationUnit.getElementName(), 1200);
                compilationUnit.becomeWorkingCopy((IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
                HashMap<String, String> declaredTypes = new HashMap<String, String>();
                IType[] compilationUnitTypes = compilationUnit.getTypes();
                HashSet<IType> currentTypes = new HashSet<IType>();
                IType[] iTypeArray = compilationUnitTypes;
                int n = compilationUnitTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    currentTypes.add(type);
                    declaredTypes.put(type.getElementName(), type.getFullyQualifiedName('.'));
                    ++n2;
                }
                boolean memberTypesAreLocal = true;
                while (!currentTypes.isEmpty()) {
                    HashSet<IType> newTypes = new HashSet<IType>();
                    for (IType type : currentTypes) {
                        String superclassName;
                        IType superclassType;
                        String[] superInterfaceNames;
                        IType[] memberTypes;
                        HashSet<IType> currentMemberTypes = new HashSet<IType>();
                        IType[] iTypeArray2 = memberTypes = type.getTypes();
                        int n3 = memberTypes.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IType memberType = iTypeArray2[n4];
                            currentMemberTypes.add(memberType);
                            ++n4;
                        }
                        while (!currentMemberTypes.isEmpty()) {
                            HashSet<IType> newMemberTypes = new HashSet<IType>();
                            for (IType memberType : currentMemberTypes) {
                                if (memberTypesAreLocal || !Flags.isPrivate((int)memberType.getFlags())) {
                                    declaredTypes.put(memberType.getElementName(), memberType.getFullyQualifiedName('.'));
                                }
                                IType[] iTypeArray3 = memberTypes = memberType.getTypes();
                                int n5 = memberTypes.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    IType nestedMemberType = iTypeArray3[n6];
                                    newMemberTypes.add(nestedMemberType);
                                    ++n6;
                                }
                            }
                            currentMemberTypes = newMemberTypes;
                        }
                        String[] stringArray = superInterfaceNames = type.getSuperInterfaceNames();
                        int n7 = superInterfaceNames.length;
                        n3 = 0;
                        while (n3 < n7) {
                            String superInterfaceName = stringArray[n3];
                            IType interfaceType = JavaUtil.resolveType(type, superInterfaceName);
                            if (interfaceType != null) {
                                newTypes.add(interfaceType);
                            }
                            ++n3;
                        }
                        if (type.getSuperclassName() == null || (superclassType = JavaUtil.resolveType(type, superclassName = type.getSuperclassName())) == null) continue;
                        newTypes.add(superclassType);
                    }
                    memberTypesAreLocal = false;
                    currentTypes = newTypes;
                }
                Document document = new Document(compilationUnit.getSource());
                ImportRewrite importRewrite = ImportRewrite.create((ICompilationUnit)compilationUnit, (boolean)false);
                importRewrite.setImportOrder(IMPORT_ORDER);
                astParser.setSource(compilationUnit);
                astParser.setResolveBindings(true);
                CompilationUnit astCompilationUnit = (CompilationUnit)astParser.createAST((IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
                astCompilationUnit.recordModifications();
                ImportRewriteTypeVisitor typeVisitor = new ImportRewriteTypeVisitor(importRewrite, declaredTypes);
                List typeDeclarations = astCompilationUnit.types();
                for (TypeDeclaration typeDeclaration : typeDeclarations) {
                    typeDeclaration.accept((ASTVisitor)typeVisitor);
                }
                TextEdit edits = astCompilationUnit.rewrite((IDocument)document, null);
                compilationUnit.applyTextEdit(edits, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
                edits = importRewrite.rewriteImports((IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
                compilationUnit.applyTextEdit(edits, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
                compilationUnit.commitWorkingCopy(true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
                compilationUnit.discardWorkingCopy();
            }
            catch (JavaModelException e) {
                e.printStackTrace();
                LOGGER.info("Import util problem with " + compilationUnit.getElementName());
                progressMonitor.done();
            }
            catch (CoreException e) {
                e.printStackTrace();
                LOGGER.info("Import util problem with " + compilationUnit.getElementName());
                progressMonitor.done();
            }
            catch (StringIndexOutOfBoundsException e) {
                e.printStackTrace();
                LOGGER.info("Import util problem with " + compilationUnit.getElementName());
                throw e;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private static class ImportRewriteTypeVisitor
    extends ASTVisitor {
        private ImportRewrite iImportRewrite;
        private Map<String, String> iDeclaredTypes;
        private Collection<String> iTypeNames = new HashSet<String>();

        public ImportRewriteTypeVisitor(ImportRewrite importRewrite, Map<String, String> declaredTypes) {
            this.iImportRewrite = importRewrite;
            this.iDeclaredTypes = declaredTypes;
        }

        public boolean preVisit2(ASTNode node) {
            if (node.toString().endsWith("KEYS.STORE_DEFAULT_LANGUAGE_ID")) {
                LOGGER.info("KEYS.STORE_DEFAULT_LANGUAGE_ID");
            }
            if (node.toString().equals("com.ibm.commerce.rest.order.handler.JPACartHandler.AddOrderItemBodyDescription.OrderItemBodyDescription.ItemAttributesBodyDescription")) {
                LOGGER.info("com.ibm.commerce.rest.order.handler.JPACartHandler.AddOrderItemBodyDescription.OrderItemBodyDescription.ItemAttributesBodyDescription");
            }
            return true;
        }

        public boolean visit(TypeDeclaration typeDeclaration) {
            ITypeBinding typeBinding = typeDeclaration.resolveBinding();
            if (typeBinding != null) {
                this.iTypeNames.add(typeBinding.getQualifiedName());
            }
            return true;
        }

        public void endVisit(TypeDeclaration typeDeclaration) {
            ITypeBinding typeBinding = typeDeclaration.resolveBinding();
            if (typeBinding != null) {
                this.iTypeNames.remove(typeBinding.getQualifiedName());
            }
        }

        public boolean visit(SimpleType node) {
            ITypeBinding typeBinding = node.resolveBinding();
            if (typeBinding != null) {
                boolean declaredName = false;
                if (node.getName().getNodeType() == 40) {
                    QualifiedName qualifiedName = (QualifiedName)node.getName();
                    String simpleName = qualifiedName.getName().getIdentifier();
                    if (this.iDeclaredTypes.containsKey(simpleName) && !this.iDeclaredTypes.get(simpleName).equals(typeBinding.getQualifiedName())) {
                        qualifiedName.getQualifier().accept((ASTVisitor)this);
                        declaredName = true;
                    } else if (this.iTypeNames.contains(qualifiedName.getQualifier().getFullyQualifiedName())) {
                        JavaUtil.replaceASTNode((ASTNode)node, (ASTNode)node.getAST().newSimpleType((Name)node.getAST().newSimpleName(simpleName)));
                        declaredName = true;
                    }
                }
                if (!declaredName) {
                    Type newType = this.iImportRewrite.addImport(typeBinding, node.getAST());
                    JavaUtil.replaceASTNode((ASTNode)node, (ASTNode)newType);
                }
            }
            return false;
        }

        public boolean visit(ParameterizedType node) {
            ITypeBinding typeBinding = node.resolveBinding();
            if (typeBinding != null) {
                Type newType = this.iImportRewrite.addImport(typeBinding, node.getAST());
                JavaUtil.replaceASTNode((ASTNode)node, (ASTNode)newType);
            }
            return false;
        }

        public boolean visit(SimpleName name) {
            String type;
            IBinding binding;
            if (!name.isDeclaration() && (binding = name.resolveBinding()) != null && binding.getKind() == 2 && !(type = this.iImportRewrite.addImport((ITypeBinding)binding)).equals(name.getIdentifier())) {
                Name newName = name.getAST().newName(type);
                JavaUtil.replaceASTNode((ASTNode)name, (ASTNode)newName);
            }
            return false;
        }

        public boolean visit(QualifiedName node) {
            boolean visitChildren = true;
            IBinding binding = node.resolveBinding();
            if (binding != null && binding.getKind() == 2) {
                String simpleName;
                ITypeBinding typeBinding = (ITypeBinding)binding;
                if (typeBinding.getQualifiedName().equals("com.ibm.commerce.rest.order.handler.JPACartHandler.AddOrderItemBodyDescription.OrderItemBodyDescription.ItemAttributesBodyDescription")) {
                    LOGGER.info("com.ibm.commerce.rest.order.handler.JPACartHandler.AddOrderItemBodyDescription.OrderItemBodyDescription.ItemAttributesBodyDescription");
                }
                if (this.iDeclaredTypes.containsKey(simpleName = node.getName().getIdentifier()) && !this.iDeclaredTypes.get(simpleName).equals(typeBinding.getQualifiedName())) {
                    node.getQualifier().accept((ASTVisitor)this);
                    visitChildren = false;
                } else {
                    String type = this.iImportRewrite.addImport(typeBinding);
                    if (!type.equals(node.getFullyQualifiedName())) {
                        Name newName = node.getAST().newName(type);
                        JavaUtil.replaceASTNode((ASTNode)node, (ASTNode)newName);
                    }
                    visitChildren = false;
                }
            }
            return visitChildren;
        }

        public boolean visit(QualifiedType qualifiedType) {
            boolean visitChildren = true;
            ITypeBinding typeBinding = qualifiedType.resolveBinding();
            if (typeBinding != null) {
                String simpleName;
                if (typeBinding.getQualifiedName().equals("com.ibm.commerce.rest.order.handler.JPACartHandler.AddOrderItemBodyDescription.OrderItemBodyDescription.ItemAttributesBodyDescription")) {
                    LOGGER.info("com.ibm.commerce.rest.order.handler.JPACartHandler.AddOrderItemBodyDescription.OrderItemBodyDescription.ItemAttributesBodyDescription");
                }
                if (this.iDeclaredTypes.containsKey(simpleName = qualifiedType.getName().getIdentifier()) && !this.iDeclaredTypes.get(simpleName).equals(typeBinding.getQualifiedName())) {
                    qualifiedType.getQualifier().accept((ASTVisitor)this);
                    visitChildren = false;
                } else if (this.iTypeNames.contains(typeBinding.getQualifiedName())) {
                    JavaUtil.replaceASTNode((ASTNode)qualifiedType, (ASTNode)qualifiedType.getAST().newSimpleType((Name)qualifiedType.getAST().newSimpleName(simpleName)));
                    visitChildren = false;
                }
            }
            return visitChildren;
        }

        public boolean visit(ImportDeclaration node) {
            return false;
        }
    }

    private static class StringBuilderImportTypeVisitor
    extends ASTVisitor {
        private StringBuilder iStringBuilder;

        public StringBuilderImportTypeVisitor(StringBuilder stringBuilder) {
            this.iStringBuilder = stringBuilder;
        }

        public boolean visit(SimpleType node) {
            ITypeBinding typeBinding = node.resolveBinding();
            if (typeBinding != null) {
                this.iStringBuilder.append("import ");
                this.iStringBuilder.append(typeBinding.getQualifiedName());
                this.iStringBuilder.append(";\r\n");
            }
            return false;
        }

        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (binding != null && binding.getKind() == 2) {
                this.iStringBuilder.append("import ");
                this.iStringBuilder.append(((ITypeBinding)binding).getQualifiedName());
                this.iStringBuilder.append(";\r\n");
            }
            return false;
        }

        public boolean visit(QualifiedName node) {
            boolean visitChildren = true;
            IBinding binding = node.resolveBinding();
            if (binding != null && binding.getKind() == 2) {
                visitChildren = false;
            }
            return visitChildren;
        }
    }
}

