/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.util;

import com.ibm.commerce.jpa.port.util.TargetExceptionUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class ExceptionUtil {
    private static Set<ITypeBinding> getFilteredExceptions(Set<ITypeBinding> unhandledExceptions) {
        HashSet<ITypeBinding> filteredExceptions = new HashSet<ITypeBinding>();
        for (ITypeBinding exception : unhandledExceptions) {
            boolean add = true;
            HashSet<ITypeBinding> removeTypes = new HashSet<ITypeBinding>();
            for (ITypeBinding currentException : filteredExceptions) {
                if (exception.isSubTypeCompatible(currentException)) {
                    add = false;
                    break;
                }
                if (!currentException.isSubTypeCompatible(exception)) continue;
                removeTypes.add(currentException);
            }
            if (add) {
                filteredExceptions.add(exception);
            }
            for (ITypeBinding type : removeTypes) {
                filteredExceptions.remove(type);
            }
        }
        return filteredExceptions;
    }

    public static void suppressExceptions(ASTParser astParser, ICompilationUnit compilationUnit, IProgressMonitor progressMonitor) {
        try {
            try {
                progressMonitor.beginTask("suppress exceptions in " + compilationUnit.getElementName(), 1000);
                Document document = new Document(compilationUnit.getSource());
                astParser.setSource(compilationUnit);
                astParser.setResolveBindings(true);
                CompilationUnit astCompilationUnit = (CompilationUnit)astParser.createAST((IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
                astCompilationUnit.recordModifications();
                List typeDeclarations = astCompilationUnit.types();
                for (TypeDeclaration typeDeclaration : typeDeclarations) {
                    ExceptionUtil.suppressExceptions(compilationUnit.getJavaProject(), typeDeclaration);
                }
                progressMonitor.worked(200);
                TextEdit edits = astCompilationUnit.rewrite((IDocument)document, null);
                if (!progressMonitor.isCanceled()) {
                    compilationUnit.becomeWorkingCopy((IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
                    if (!progressMonitor.isCanceled()) {
                        compilationUnit.applyTextEdit(edits, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
                        if (!progressMonitor.isCanceled()) {
                            compilationUnit.commitWorkingCopy(true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
                        }
                        compilationUnit.discardWorkingCopy();
                    }
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private static void suppressExceptions(IJavaProject javaProject, TypeDeclaration typeDeclaration) {
        List bodyDeclarations = typeDeclaration.bodyDeclarations();
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            switch (bodyDeclaration.getNodeType()) {
                case 31: {
                    ExceptionUtil.suppressExceptions(javaProject, (MethodDeclaration)bodyDeclaration);
                    break;
                }
            }
        }
    }

    public static void suppressExceptions(IJavaProject javaProject, MethodDeclaration methodDeclaration) {
        ExceptionVisitor exceptionVisitor = new ExceptionVisitor(javaProject);
        methodDeclaration.accept((ASTVisitor)exceptionVisitor);
        List methodExceptions = methodDeclaration.thrownExceptions();
        methodExceptions.clear();
        Set<ITypeBinding> unhandledExceptions = exceptionVisitor.getUnhandledExceptions();
        if (unhandledExceptions.size() > 0) {
            Set<ITypeBinding> filteredExceptions = ExceptionUtil.getFilteredExceptions(unhandledExceptions);
            AST ast = methodDeclaration.getAST();
            TryStatement tryStatement = ast.newTryStatement();
            List tryStatements = tryStatement.getBody().statements();
            List methodStatements = methodDeclaration.getBody().statements();
            while (methodStatements.size() > 0) {
                tryStatements.add((Statement)methodStatements.remove(0));
            }
            List catchClauses = tryStatement.catchClauses();
            for (ITypeBinding exception : filteredExceptions) {
                CatchClause catchClause = ast.newCatchClause();
                SingleVariableDeclaration exceptionDeclaration = ast.newSingleVariableDeclaration();
                exceptionDeclaration.setType((Type)ast.newSimpleType(ast.newName(exception.getQualifiedName())));
                exceptionDeclaration.setName(ast.newSimpleName("e"));
                catchClause.setException(exceptionDeclaration);
                Block catchBlock = ast.newBlock();
                ThrowStatement throwStatement = ast.newThrowStatement();
                ClassInstanceCreation newRuntimeExceptionExpression = ast.newClassInstanceCreation();
                newRuntimeExceptionExpression.setType((Type)ast.newSimpleType(ast.newName("java.lang.RuntimeException")));
                List newRuntimeExceptionExpressionArguments = newRuntimeExceptionExpression.arguments();
                newRuntimeExceptionExpressionArguments.add(ast.newName("e"));
                throwStatement.setExpression((Expression)newRuntimeExceptionExpression);
                List catchBlockStatements = catchBlock.statements();
                catchBlockStatements.add(throwStatement);
                catchClause.setBody(catchBlock);
                catchClauses.add(catchClause);
            }
            methodStatements.add(tryStatement);
        }
    }

    private static class ExceptionVisitor
    extends ASTVisitor {
        private Set<ITypeBinding> iUnhandledExceptions = new HashSet<ITypeBinding>();
        private Deque<TryStatement> iTryStatementStack = new ArrayDeque<TryStatement>();
        private IJavaProject iJavaProject;

        public ExceptionVisitor(IJavaProject javaProject) {
            this.iJavaProject = javaProject;
        }

        public boolean visit(Block node) {
            if (node.getParent().getNodeType() == 54) {
                this.iTryStatementStack.push((TryStatement)node.getParent());
            }
            return true;
        }

        public void endVisit(Block node) {
            if (this.iTryStatementStack.size() > 0 && this.iTryStatementStack.peek().getBody() == node) {
                this.iTryStatementStack.pop();
            }
        }

        public boolean visit(MethodInvocation node) {
            ITypeBinding[] exceptionTypes;
            IMethodBinding methodBinding;
            if (node.getExpression() != null && (methodBinding = node.resolveMethodBinding()) != null && (exceptionTypes = methodBinding.getExceptionTypes()) != null) {
                ITypeBinding[] iTypeBindingArray = exceptionTypes;
                int n = exceptionTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding exceptionType = iTypeBindingArray[n2];
                    if (this.isUnhandledException(exceptionType)) {
                        this.iUnhandledExceptions.add(exceptionType);
                    }
                    ++n2;
                }
            }
            return true;
        }

        public boolean visit(ThrowStatement node) {
            ITypeBinding exceptionType = node.getExpression().resolveTypeBinding();
            if (!TargetExceptionUtil.isRuntimeException(this.iJavaProject, exceptionType.getQualifiedName()) && this.isUnhandledException(exceptionType)) {
                this.iUnhandledExceptions.add(exceptionType);
            }
            return true;
        }

        private boolean isUnhandledException(ITypeBinding exceptionTypeBinding) {
            boolean handled = false;
            for (TryStatement tryStatement : this.iTryStatementStack) {
                List catchClauses = tryStatement.catchClauses();
                for (CatchClause catchClause : catchClauses) {
                    SingleVariableDeclaration exceptionDeclaration = catchClause.getException();
                    ITypeBinding handledException = exceptionDeclaration.getType().resolveBinding();
                    if (!exceptionTypeBinding.equals((Object)handledException) && !exceptionTypeBinding.isSubTypeCompatible(handledException)) continue;
                    handled = true;
                    break;
                }
                if (handled) break;
            }
            return !handled;
        }

        public Set<ITypeBinding> getUnhandledExceptions() {
            return this.iUnhandledExceptions;
        }
    }
}

