/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.util;

import com.ibm.commerce.jpa.port.generators.PortVisitor;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.FieldInfo;
import com.ibm.commerce.jpa.port.info.RelatedEntityInfo;
import com.ibm.commerce.jpa.port.info.UserMethodInfo;
import com.ibm.commerce.jpa.port.util.JavaUtil;
import com.ibm.commerce.jpa.port.util.TargetExceptionUtil;
import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;

public class EntityUtil {
    private static final String GET = "get";
    private static final String EJB_OBJECT = "javax.ejb.EJBObject";
    private static final String OBJECT = "java.lang.Object";

    public static boolean isEntityType(ApplicationInfo applicationInfo, Expression expression) {
        String qualifiedTypeName;
        boolean result = false;
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        if (typeBinding != null && applicationInfo.isEntityType(qualifiedTypeName = typeBinding.getQualifiedName())) {
            result = true;
        }
        return result;
    }

    public static boolean isEntityMethodInvocation(ApplicationInfo applicationInfo, MethodInvocation methodInvocation) {
        boolean result = false;
        Expression methodExpression = methodInvocation.getExpression();
        if (methodExpression != null && EntityUtil.isEntityType(applicationInfo, methodExpression)) {
            result = true;
        }
        return result;
    }

    public static boolean portEntityMethodInvocation(ApplicationInfo applicationInfo, MethodInvocation methodInvocation, PortVisitor portVisitor) {
        boolean visitChildren = true;
        AST ast = methodInvocation.getAST();
        Expression methodExpression = methodInvocation.getExpression();
        String entityType = methodExpression.resolveTypeBinding().getQualifiedName();
        EntityInfo entityInfo = applicationInfo.getEntityInfoForType(entityType);
        IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
        if (methodBinding != null) {
            FieldInfo fieldInfo = null;
            String methodKey = JavaUtil.getMethodKey(methodBinding);
            UserMethodInfo userMethodInfo = entityInfo.getUserMethodInfo(methodKey);
            if (userMethodInfo != null && userMethodInfo.getFieldInfo() != null) {
                fieldInfo = userMethodInfo.getFieldInfo();
            } else if (methodKey.startsWith(GET)) {
                fieldInfo = entityInfo.getFieldInfoByGetterName(methodKey);
            }
            if (fieldInfo != null) {
                RelatedEntityInfo relatedEntityInfo = fieldInfo.getRelatedEntityInfo();
                if (fieldInfo.getRelatedEntityInfo() != null && methodKey.startsWith(GET)) {
                    String relatedEntityGetterName = relatedEntityInfo.getGetterName();
                    if (relatedEntityGetterName == null) {
                        relatedEntityGetterName = GET + Character.toUpperCase(relatedEntityInfo.getFieldName().charAt(0)) + relatedEntityInfo.getFieldName().substring(1);
                    }
                    String referencedFieldGetterName = fieldInfo.getReferencedFieldInfo().getRelatedEntityInfo() == null ? fieldInfo.getReferencedFieldInfo().getTargetGetterName() : fieldInfo.getReferencedFieldInfo().getRelatedEntityInfo().getGetterName();
                    ConditionalExpression conditionalExpression = ast.newConditionalExpression();
                    MethodInvocation getterMethodInvocation = ast.newMethodInvocation();
                    getterMethodInvocation.setName(ast.newSimpleName(relatedEntityGetterName));
                    methodExpression.accept((ASTVisitor)portVisitor);
                    getterMethodInvocation.setExpression((Expression)ASTNode.copySubtree((AST)ast, (ASTNode)methodInvocation.getExpression()));
                    InfixExpression infixExpression = ast.newInfixExpression();
                    infixExpression.setLeftOperand((Expression)getterMethodInvocation);
                    infixExpression.setOperator(InfixExpression.Operator.EQUALS);
                    infixExpression.setRightOperand((Expression)ast.newNullLiteral());
                    conditionalExpression.setExpression((Expression)infixExpression);
                    conditionalExpression.setThenExpression((Expression)ast.newNullLiteral());
                    getterMethodInvocation = (MethodInvocation)ASTNode.copySubtree((AST)ast, (ASTNode)getterMethodInvocation);
                    MethodInvocation fieldMethodInvocation = ast.newMethodInvocation();
                    fieldMethodInvocation.setExpression((Expression)getterMethodInvocation);
                    fieldMethodInvocation.setName(ast.newSimpleName(referencedFieldGetterName));
                    if (fieldInfo.getReferencedFieldInfo().getRelatedEntityInfo() == null) {
                        conditionalExpression.setElseExpression((Expression)fieldMethodInvocation);
                    } else {
                        MethodInvocation relatedFieldMethodInvocation = ast.newMethodInvocation();
                        relatedFieldMethodInvocation.setExpression((Expression)fieldMethodInvocation);
                        relatedFieldMethodInvocation.setName(ast.newSimpleName(fieldInfo.getReferencedFieldInfo().getReferencedFieldInfo().getTargetGetterName()));
                        conditionalExpression.setElseExpression((Expression)relatedFieldMethodInvocation);
                    }
                    portVisitor.replaceASTNode((ASTNode)methodInvocation, (ASTNode)conditionalExpression);
                    visitChildren = false;
                }
            }
        }
        return visitChildren;
    }

    public static String getJpaName(IType type) {
        String typeName = type.getTypeQualifiedName('.');
        String packageName = type.getPackageFragment().getElementName();
        return String.valueOf(packageName) + ".JPA" + typeName;
    }

    public static String getJpaStubName(IType type) {
        String typeName = type.getTypeQualifiedName('.');
        String packageName = type.getPackageFragment().getElementName();
        return String.valueOf(packageName) + ".$JPA" + typeName;
    }

    public static boolean isEjbObjectVariableDeclarationStatement(VariableDeclarationStatement variableDeclarationStatement) {
        ITypeBinding typeBinding;
        boolean result = false;
        Type type = variableDeclarationStatement.getType();
        if (type != null && (typeBinding = type.resolveBinding()) != null && typeBinding.getQualifiedName().equals(EJB_OBJECT)) {
            result = true;
        }
        return result;
    }

    public static boolean portEjbObjectVariableDeclarationStatement(VariableDeclarationStatement variableDeclarationStatement, PortVisitor portVisitor) {
        boolean visitChildren = false;
        List fragments = variableDeclarationStatement.fragments();
        for (VariableDeclarationFragment fragment : fragments) {
            fragment.accept((ASTVisitor)portVisitor);
        }
        AST ast = variableDeclarationStatement.getAST();
        variableDeclarationStatement.setType((Type)ast.newSimpleType(ast.newName(OBJECT)));
        TargetExceptionUtil.portVariableDeclarationStatement(variableDeclarationStatement, portVisitor);
        return visitChildren;
    }
}

