/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.util;

import com.ibm.commerce.jpa.port.generators.PortVisitor;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.FieldInfo;
import com.ibm.commerce.jpa.port.info.KeyClassConstructorInfo;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Type;

public class DataClassUtil {
    private static final String GET_PRIMARY_KEY = "getPrimaryKey";

    public static boolean isDataClassType(ApplicationInfo applicationInfo, Expression expression) {
        String qualifiedTypeName;
        boolean result = false;
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        if (typeBinding != null && applicationInfo.isDataClassType(qualifiedTypeName = typeBinding.getQualifiedName())) {
            result = true;
        }
        return result;
    }

    public static boolean isGetPrimaryKeyMethodInvocation(ApplicationInfo applicationInfo, MethodInvocation methodInvocation) {
        boolean result = false;
        Expression methodExpression = methodInvocation.getExpression();
        if (methodExpression != null && DataClassUtil.isDataClassType(applicationInfo, methodExpression) && GET_PRIMARY_KEY.equals(methodInvocation.getName().getIdentifier())) {
            result = true;
        }
        return result;
    }

    public static boolean portGetPrimaryKeyMethodInvocation(ApplicationInfo applicationInfo, MethodInvocation methodInvocation, PortVisitor portVisitor) {
        String dataClassType = methodInvocation.getExpression().resolveTypeBinding().getQualifiedName();
        EntityInfo entityInfo = applicationInfo.getEntityInfoForType(dataClassType);
        return DataClassUtil.portGetPrimaryKeyMethodInvocation(entityInfo, methodInvocation, portVisitor);
    }

    public static boolean portGetPrimaryKeyMethodInvocation(EntityInfo entityInfo, MethodInvocation methodInvocation, ASTNode replacementNode, PortVisitor portVisitor) {
        boolean visitChildren = false;
        AST ast = methodInvocation.getAST();
        if (entityInfo.getEntityKeyClassInfo() != null) {
            Expression dataClassExpression = null;
            if (methodInvocation.getExpression() != null) {
                methodInvocation.getExpression().accept((ASTVisitor)portVisitor);
                dataClassExpression = methodInvocation.getExpression();
                methodInvocation.setExpression(null);
            }
            ClassInstanceCreation classInstanceCreation = ast.newClassInstanceCreation();
            classInstanceCreation.setType((Type)ast.newSimpleType(ast.newName(entityInfo.getEntityKeyClassInfo().getQualifiedClassName())));
            List arguments = classInstanceCreation.arguments();
            List<KeyClassConstructorInfo> keyClassConstructors = entityInfo.getKeyClassConstructors();
            for (KeyClassConstructorInfo keyClassConstructorInfo : keyClassConstructors) {
                if (keyClassConstructorInfo.getFields().size() <= 0) continue;
                List<FieldInfo> fields = keyClassConstructorInfo.getFields();
                for (FieldInfo fieldInfo : fields) {
                    MethodInvocation fieldGetterMethodInvocation = ast.newMethodInvocation();
                    fieldGetterMethodInvocation.setName(ast.newSimpleName(fieldInfo.getTargetGetterName()));
                    if (dataClassExpression != null) {
                        fieldGetterMethodInvocation.setExpression((Expression)ASTNode.copySubtree((AST)ast, (ASTNode)dataClassExpression));
                    }
                    arguments.add(fieldGetterMethodInvocation);
                }
            }
            portVisitor.replaceASTNode(replacementNode, (ASTNode)classInstanceCreation);
            visitChildren = false;
        } else if (entityInfo.getKeyFields().size() == 1) {
            FieldInfo fieldInfo = entityInfo.getKeyFields().get(0);
            MethodInvocation newMethodInvocation = ast.newMethodInvocation();
            newMethodInvocation.setName(ast.newSimpleName(fieldInfo.getTargetGetterName()));
            if (methodInvocation.getExpression() != null) {
                methodInvocation.getExpression().accept((ASTVisitor)portVisitor);
                Expression dataClassExpression = methodInvocation.getExpression();
                methodInvocation.setExpression(null);
                newMethodInvocation.setExpression(dataClassExpression);
            }
            portVisitor.replaceASTNode(replacementNode, (ASTNode)newMethodInvocation);
            visitChildren = false;
        }
        return visitChildren;
    }

    public static boolean portGetPrimaryKeyMethodInvocation(EntityInfo entityInfo, MethodInvocation methodInvocation, PortVisitor portVisitor) {
        return DataClassUtil.portGetPrimaryKeyMethodInvocation(entityInfo, methodInvocation, (ASTNode)methodInvocation, portVisitor);
    }

    public static boolean isGetPrimaryKeyCastExpression(ApplicationInfo applicationInfo, CastExpression castExpression) {
        boolean result = false;
        if (castExpression.getExpression().getNodeType() == 32) {
            MethodInvocation methodInvocation = (MethodInvocation)castExpression.getExpression();
            result = DataClassUtil.isGetPrimaryKeyMethodInvocation(applicationInfo, methodInvocation);
        }
        return result;
    }

    public static boolean portGetPrimaryKeyCastExpression(EntityInfo entityInfo, CastExpression castExpression, PortVisitor portVisitor) {
        return DataClassUtil.portGetPrimaryKeyMethodInvocation(entityInfo, (MethodInvocation)castExpression.getExpression(), (ASTNode)castExpression, portVisitor);
    }

    public static boolean portGetPrimaryKeyCastExpression(ApplicationInfo applicationInfo, CastExpression castExpression, PortVisitor portVisitor) {
        MethodInvocation methodInvocation = (MethodInvocation)castExpression.getExpression();
        String dataClassType = methodInvocation.getExpression().resolveTypeBinding().getQualifiedName();
        EntityInfo entityInfo = applicationInfo.getEntityInfoForType(dataClassType);
        return DataClassUtil.portGetPrimaryKeyCastExpression(entityInfo, castExpression, portVisitor);
    }
}

