/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.search;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.util.JavaUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.search.SearchPattern;

public class EntitySearchPatternUtil {
    private static final Logger LOGGER = LoggerHelper.getLogger(EntitySearchPatternUtil.class);
    private static final Collection<String> EXEMPT_INTERFACES = new HashSet<String>();
    private static final String COMMERCE_PACKAGE = "com.*";
    private EntityInfo iEntityInfo;
    private ApplicationInfo iApplicationInfo;
    private Collection<String> iBinarySearchResults;

    static {
        EXEMPT_INTERFACES.add("com.ibm.commerce.security.Protectable");
        EXEMPT_INTERFACES.add("com.ibm.commerce.security.Delegator");
        EXEMPT_INTERFACES.add("com.ibm.commerce.grouping.Groupable");
    }

    public EntitySearchPatternUtil(EntityInfo entityInfo, Collection<String> binarySearchResults) {
        this.iEntityInfo = entityInfo;
        this.iApplicationInfo = entityInfo.getModuleInfo().getApplicationInfo();
        this.iBinarySearchResults = binarySearchResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchPattern createEntitySearchPattern(IProgressMonitor progressMonitor) {
        SearchPattern searchPattern;
        block22: {
            searchPattern = null;
            try {
                try {
                    progressMonitor.beginTask("create search pattern for " + this.iEntityInfo.getEjbName(), 1000);
                    if (this.iEntityInfo.getEjbAccessBeanType() != null) {
                        ITypeHierarchy typeHierarchy;
                        IType[] subtypes;
                        searchPattern = SearchPattern.createPattern((IJavaElement)this.iEntityInfo.getEjbAccessBeanType(), (int)2, (int)8);
                        SearchPattern indirectReferencesSearchPattern = this.getIndirectReferencesSearchPattern(this.iEntityInfo.getEjbAccessBeanType());
                        if (indirectReferencesSearchPattern != null) {
                            searchPattern = SearchPattern.createOrPattern((SearchPattern)searchPattern, (SearchPattern)indirectReferencesSearchPattern);
                        }
                        if ((subtypes = (typeHierarchy = this.iEntityInfo.getEjbAccessBeanType().newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000))).getAllSubtypes(this.iEntityInfo.getEjbAccessBeanType())) != null) {
                            IType[] iTypeArray = subtypes;
                            int n = subtypes.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IType subtype = iTypeArray[n2];
                                if (subtype.isBinary()) {
                                    Collection<String> collection = this.iBinarySearchResults;
                                    synchronized (collection) {
                                        if (!this.iBinarySearchResults.contains(subtype.getResource().getName())) {
                                            LOGGER.info("found binary search result: " + subtype.getResource().getName());
                                            this.iBinarySearchResults.add(subtype.getResource().getName());
                                            this.iApplicationInfo.incrementSearchResultCount();
                                        }
                                    }
                                } else {
                                    String subtypeName = subtype.getFullyQualifiedName('.');
                                    this.iApplicationInfo.getProjectInfo(subtype.getResource().getProject()).getAccessBeanSubclassInfo(subtypeName, true);
                                    this.iApplicationInfo.incrementSearchResultCount();
                                }
                                searchPattern = SearchPattern.createOrPattern((SearchPattern)searchPattern, (SearchPattern)SearchPattern.createPattern((IJavaElement)subtype, (int)2, (int)8));
                                indirectReferencesSearchPattern = this.getIndirectReferencesSearchPattern(subtype);
                                if (indirectReferencesSearchPattern != null) {
                                    searchPattern = SearchPattern.createOrPattern((SearchPattern)searchPattern, (SearchPattern)indirectReferencesSearchPattern);
                                }
                                ++n2;
                            }
                        }
                    }
                    if (this.iEntityInfo.getHomeType() != null) {
                        SearchPattern homeTypeSearchPattern = SearchPattern.createPattern((IJavaElement)this.iEntityInfo.getHomeType(), (int)2, (int)8);
                        searchPattern = searchPattern == null ? homeTypeSearchPattern : SearchPattern.createOrPattern((SearchPattern)searchPattern, (SearchPattern)homeTypeSearchPattern);
                    }
                    if (this.iEntityInfo.getLocalHomeType() != null) {
                        SearchPattern localHomeTypeSearchPattern = SearchPattern.createPattern((IJavaElement)this.iEntityInfo.getLocalHomeType(), (int)2, (int)8);
                        searchPattern = searchPattern == null ? localHomeTypeSearchPattern : SearchPattern.createOrPattern((SearchPattern)searchPattern, (SearchPattern)localHomeTypeSearchPattern);
                    }
                    if (this.iEntityInfo.getPrimaryKeyType() != null && !this.iEntityInfo.getPrimaryKeyType().isBinary()) {
                        SearchPattern primaryKeyTypeSearchPattern = SearchPattern.createPattern((IJavaElement)this.iEntityInfo.getPrimaryKeyType(), (int)2, (int)8);
                        searchPattern = searchPattern == null ? primaryKeyTypeSearchPattern : SearchPattern.createOrPattern((SearchPattern)searchPattern, (SearchPattern)primaryKeyTypeSearchPattern);
                    }
                    if (this.iEntityInfo.getRemoteType() != null) {
                        SearchPattern remoteTypeSearchPattern = SearchPattern.createPattern((IJavaElement)this.iEntityInfo.getRemoteType(), (int)2, (int)8);
                        searchPattern = searchPattern == null ? remoteTypeSearchPattern : SearchPattern.createOrPattern((SearchPattern)searchPattern, (SearchPattern)remoteTypeSearchPattern);
                    }
                    if (this.iEntityInfo.getLocalType() != null) {
                        SearchPattern localTypeSearchPattern = SearchPattern.createPattern((IJavaElement)this.iEntityInfo.getLocalType(), (int)2, (int)8);
                        searchPattern = searchPattern == null ? localTypeSearchPattern : SearchPattern.createOrPattern((SearchPattern)searchPattern, (SearchPattern)localTypeSearchPattern);
                    }
                    if (this.iEntityInfo.getFactoryType() == null) break block22;
                    SearchPattern factoryTypeSearchPattern = SearchPattern.createPattern((IJavaElement)this.iEntityInfo.getFactoryType(), (int)2, (int)8);
                    if (searchPattern == null) {
                        searchPattern = factoryTypeSearchPattern;
                        break block22;
                    }
                    searchPattern = SearchPattern.createOrPattern((SearchPattern)searchPattern, (SearchPattern)factoryTypeSearchPattern);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    progressMonitor.done();
                }
            }
            finally {
                progressMonitor.done();
            }
        }
        return searchPattern;
    }

    private Collection<IType> getExemptSuperInterfaces(IType type) throws CoreException {
        HashSet<IType> exemptSuperInterfaces = new HashSet<IType>();
        String[] superInterfaceNames = type.getSuperInterfaceNames();
        if (superInterfaceNames != null) {
            String[] stringArray = superInterfaceNames;
            int n = superInterfaceNames.length;
            int n2 = 0;
            while (n2 < n) {
                String superInterfaceName = stringArray[n2];
                IType superInterfaceType = JavaUtil.resolveType(type, superInterfaceName);
                if (superInterfaceType != null) {
                    String name = superInterfaceType.getFullyQualifiedName('.');
                    if (EXEMPT_INTERFACES.contains(name) || !name.startsWith(COMMERCE_PACKAGE)) {
                        exemptSuperInterfaces.add(superInterfaceType);
                    }
                    exemptSuperInterfaces.addAll(this.getExemptSuperInterfaces(superInterfaceType));
                }
                ++n2;
            }
        }
        return exemptSuperInterfaces;
    }

    private SearchPattern getIndirectReferencesSearchPattern(IType type) throws CoreException {
        IMethod[] methods;
        IField[] fields;
        HashSet<IType> superTypes = new HashSet<IType>();
        superTypes.addAll(this.getExemptSuperInterfaces(type));
        String superclassName = type.getSuperclassName();
        IType currentType = type;
        while (superclassName != null) {
            IType superType = JavaUtil.resolveType(currentType, superclassName);
            if (superType != null) {
                superTypes.add(superType);
                superTypes.addAll(this.getExemptSuperInterfaces(superType));
                superclassName = superType.getSuperclassName();
                currentType = superType;
                continue;
            }
            LOGGER.info("could not resolve superclassName " + superclassName);
            break;
        }
        SearchPattern searchPattern = null;
        IField[] iFieldArray = fields = type.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            if (!Flags.isPrivate((int)field.getFlags())) {
                SearchPattern fieldSearchPattern = SearchPattern.createPattern((IJavaElement)field, (int)2, (int)8);
                searchPattern = searchPattern == null ? fieldSearchPattern : SearchPattern.createOrPattern((SearchPattern)searchPattern, (SearchPattern)fieldSearchPattern);
            }
            ++n2;
        }
        IMethod[] iMethodArray = methods = type.getMethods();
        int n3 = methods.length;
        n = 0;
        while (n < n3) {
            IMethod method = iMethodArray[n];
            if (!Flags.isPrivate((int)method.getFlags())) {
                SearchPattern methodSearchPattern;
                boolean extendedMethod = false;
                if (!method.isConstructor()) {
                    for (IType superType : superTypes) {
                        IMethod[] superMethods = superType.findMethods(method);
                        if (superMethods == null || superMethods.length <= 0) continue;
                        extendedMethod = true;
                        break;
                    }
                }
                if (!extendedMethod && (methodSearchPattern = SearchPattern.createPattern((IJavaElement)method, (int)2, (int)8)) != null) {
                    searchPattern = searchPattern == null ? methodSearchPattern : SearchPattern.createOrPattern((SearchPattern)searchPattern, (SearchPattern)methodSearchPattern);
                }
            }
            ++n;
        }
        return searchPattern;
    }
}

