/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.search;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.search.EntitySearchPatternUtil;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Logger;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;

public class BinaryEntitySearchUtil {
    private static final Logger LOGGER = LoggerHelper.getLogger(BinaryEntitySearchUtil.class);
    private Collection<EntityInfo> iEntities;
    private ApplicationInfo iApplicationInfo;
    private Collection<String> iBinarySearchResults;

    public BinaryEntitySearchUtil(ApplicationInfo applicationInfo, Collection<EntityInfo> entities, Collection<String> binarySearchResults) {
        this.iApplicationInfo = applicationInfo;
        this.iEntities = entities;
        this.iBinarySearchResults = binarySearchResults;
    }

    public void search(IProgressMonitor progressMonitor) {
        try {
            try {
                progressMonitor.beginTask("binary search for " + this.iEntities.size() + " entities", this.iEntities.size() * 1000 + 1000);
                long start = new Date().getTime();
                LOGGER.info("searching for " + this.iEntities.size() + " entities");
                SearchPattern searchPattern = null;
                for (EntityInfo entityInfo : this.iEntities) {
                    EntitySearchPatternUtil entitySearchPatternUtil = new EntitySearchPatternUtil(entityInfo, this.iBinarySearchResults);
                    SearchPattern entitySearchPattern = entitySearchPatternUtil.createEntitySearchPattern((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                    searchPattern = searchPattern == null ? entitySearchPattern : SearchPattern.createOrPattern((SearchPattern)searchPattern, (SearchPattern)entitySearchPattern);
                }
                SearchEngine searchEngine = new SearchEngine();
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)workspaceRoot);
                IJavaElement[] javaElements = new IJavaElement[]{javaModel};
                searchEngine.search(searchPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createJavaSearchScope((IJavaElement[])javaElements, (int)2), (SearchRequestor)new TypeSearchRequestor(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                LOGGER.info("end search for " + this.iEntities.size() + " entities " + (new Date().getTime() - start) / 1000L + " seconds");
            }
            catch (CoreException e) {
                e.printStackTrace();
                progressMonitor.done();
            }
            catch (NullPointerException e) {
                LOGGER.info("null pointer exception");
                for (EntityInfo entityInfo : this.iEntities) {
                    LOGGER.info(entityInfo.getEjbName());
                }
                e.printStackTrace();
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private class TypeSearchRequestor
    extends SearchRequestor {
        private TypeSearchRequestor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
            if (searchMatch.getAccuracy() == 0 && searchMatch.isExact()) {
                IJavaElement javaElement = (IJavaElement)searchMatch.getElement();
                if (javaElement instanceof IMember) {
                    IMember member = (IMember)javaElement;
                    IType type = member.getDeclaringType();
                    if (type == null && member.getElementType() == 7) {
                        type = (IType)member;
                    }
                    if (type != null) {
                        while (type.getDeclaringType() != null) {
                            type = type.getDeclaringType();
                        }
                        if (!BinaryEntitySearchUtil.this.iApplicationInfo.isDeleteIntendedType(type.getFullyQualifiedName('.')) && type.isBinary()) {
                            Collection collection = BinaryEntitySearchUtil.this.iBinarySearchResults;
                            synchronized (collection) {
                                if (!BinaryEntitySearchUtil.this.iBinarySearchResults.contains(searchMatch.getResource().getName())) {
                                    LOGGER.info("found binary search result: " + searchMatch.getResource().getName());
                                    BinaryEntitySearchUtil.this.iBinarySearchResults.add(searchMatch.getResource().getName());
                                    BinaryEntitySearchUtil.this.iApplicationInfo.incrementSearchResultCount();
                                }
                            }
                        }
                    } else {
                        LOGGER.info("no type found " + javaElement);
                    }
                } else if (javaElement.getElementType() == 13) {
                    ICompilationUnit compilationUnit = (ICompilationUnit)javaElement.getParent().getParent();
                    IType type = compilationUnit.getTypes()[0];
                    if (!BinaryEntitySearchUtil.this.iApplicationInfo.isDeleteIntendedType(type.getFullyQualifiedName('.')) && type.isBinary()) {
                        Collection collection = BinaryEntitySearchUtil.this.iBinarySearchResults;
                        synchronized (collection) {
                            if (!BinaryEntitySearchUtil.this.iBinarySearchResults.contains(searchMatch.getResource().getName())) {
                                LOGGER.info("found binary search result: " + searchMatch.getResource().getName());
                                BinaryEntitySearchUtil.this.iBinarySearchResults.add(searchMatch.getResource().getName());
                                BinaryEntitySearchUtil.this.iApplicationInfo.incrementSearchResultCount();
                            }
                        }
                    }
                } else {
                    LOGGER.info("unexpected search result " + javaElement);
                }
            }
        }
    }
}

