/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.parsers;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.AccessBeanSubclassInfo;
import com.ibm.commerce.jpa.port.info.ProjectInfo;
import com.ibm.commerce.jpa.port.parsers.AccessBeanSubclassParser;
import java.util.Collection;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.dom.ASTParser;

public class ProjectParser {
    private static final Logger LOGGER = LoggerHelper.getLogger(ProjectParser.class);
    private ASTParser iASTParser = ASTParser.newParser((int)3);
    private ProjectInfo iProjectInfo;

    public ProjectParser(ProjectInfo projectInfo) {
        this.iProjectInfo = projectInfo;
    }

    public IStatus parse(IProgressMonitor progressMonitor) {
        LOGGER.info("Parsing project " + this.iProjectInfo.getProject().getName());
        IStatus status = Status.OK_STATUS;
        try {
            Collection<AccessBeanSubclassInfo> accessBeanSubclasses = this.iProjectInfo.getAccessBeanSubclasses();
            progressMonitor.beginTask("parse " + this.iProjectInfo.getProject().getName(), accessBeanSubclasses.size() * 1000);
            for (AccessBeanSubclassInfo accessBeanSubclassInfo : accessBeanSubclasses) {
                if (progressMonitor.isCanceled()) {
                    status = Status.CANCEL_STATUS;
                    break;
                }
                AccessBeanSubclassParser parser = new AccessBeanSubclassParser(this.iASTParser, accessBeanSubclassInfo);
                parser.parse((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
            }
        }
        finally {
            progressMonitor.done();
            LOGGER.info("done parsing " + this.iProjectInfo.getProject().getName());
        }
        return status;
    }
}

