/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.parsers;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.AccessBeanSubclassInfo;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.ProjectInfo;
import com.ibm.commerce.jpa.port.info.TargetExceptionInfo;
import com.ibm.commerce.jpa.port.util.AccessBeanUtil;
import com.ibm.commerce.jpa.port.util.ApplicationInfoUtil;
import com.ibm.commerce.jpa.port.util.EntityReferenceUtil;
import com.ibm.commerce.jpa.port.util.FinderResultCacheUtil;
import com.ibm.commerce.jpa.port.util.XMLUtil;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProjectInfoXmlParser {
    private static final Logger LOGGER = LoggerHelper.getLogger(ProjectInfoXmlParser.class);
    private static final String ENTITY_REFERENCING_TYPE = "EntityReferencingType";
    private static final String INDIRECT_ENTITY_REFERENCING_TYPE = "IndirectEntityReferencingType";
    private static final String ENTITY_REFERENCE_SUBCLASS = "EntityReferenceSubclass";
    private static final String ACCESS_BEAN_SUBCLASS_INFO = "AccessBeanSubclassInfo";
    private static final String NAME = "name";
    private static final String SUPERCLASS_NAME = "superclassName";
    private static final String METHOD_INFO = "MethodInfo";
    private static final String METHOD_KEY = "MethodKey";
    private static final String TARGET_EXCEPTION = "TargetException";
    private static final String SOURCE_EXCEPTION = "SourceException";
    private ProjectInfo iProjectInfo;
    private ApplicationInfo iApplicationInfo;
    private IProject iProject;
    private IJavaProject iJavaProject;

    public ProjectInfoXmlParser(ProjectInfo projectInfo) {
        this.iProjectInfo = projectInfo;
        this.iApplicationInfo = projectInfo.getApplicationInfo();
        this.iProject = projectInfo.getProject();
        this.iJavaProject = projectInfo.getJavaProject();
    }

    public void parse(IProgressMonitor progressMonitor) {
        this.parseProjectInfoFile(".jpaAccessBeanSubclassInfo.xml");
        this.parseProjectInfoFile(".jpaEntityReferences.xml");
        this.parseProjectInfoFile(".jpaEntityReferenceSubclasses.xml");
    }

    public void parseProjectInfoFile(String fileName) {
        IFile projectInfoXmlFile = this.iProject.getFile(fileName);
        if (projectInfoXmlFile.exists()) {
            Document document = this.iApplicationInfo.getXMLUtil(this.iProject).readXml(projectInfoXmlFile);
            this.parseModuleInfo(document.getDocumentElement());
            this.iApplicationInfo.incrementParsedAssetCount();
        }
    }

    private void parseModuleInfo(Element moduleInfoElement) {
        NodeList childNodes = moduleInfoElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            block26: {
                Node node = childNodes.item(i);
                if (node.getNodeType() == 1) {
                    IType type;
                    String typeName;
                    Element element = (Element)node;
                    String nodeName = element.getNodeName();
                    if (ENTITY_REFERENCING_TYPE.equals(nodeName)) {
                        typeName = XMLUtil.getElementText(element);
                        this.iApplicationInfo.addDeleteIntendedType(typeName);
                        try {
                            type = this.iJavaProject.findType(typeName);
                            if (type == null) {
                                LOGGER.info("unable to find " + typeName);
                            }
                            if (!FinderResultCacheUtil.isFinderResultCacheUtil(type) && !EntityReferenceUtil.isPortExemptEntityReferencingType(type)) {
                                String simpleTypeName = type.getTypeQualifiedName('.');
                                if (simpleTypeName.startsWith("_")) {
                                    this.iProjectInfo.addIndirectEntityReferencingType(typeName);
                                    ApplicationInfoUtil.addJpaStubTypeMapping(this.iApplicationInfo, type);
                                } else {
                                    this.iProjectInfo.addEntityReferencingType(typeName);
                                    ApplicationInfoUtil.addJpaTypeMapping(this.iApplicationInfo, type);
                                }
                                break block26;
                            }
                            this.iProjectInfo.addDeleteIntendedType(typeName);
                        }
                        catch (JavaModelException e) {
                            e.printStackTrace();
                        }
                    } else if (INDIRECT_ENTITY_REFERENCING_TYPE.equals(nodeName)) {
                        typeName = XMLUtil.getElementText(element);
                        try {
                            type = this.iJavaProject.findType(typeName);
                            this.iProjectInfo.addIndirectEntityReferencingType(typeName);
                            ApplicationInfoUtil.addJpaStubTypeMapping(this.iApplicationInfo, type);
                        }
                        catch (JavaModelException e) {
                            e.printStackTrace();
                        }
                    } else if (ENTITY_REFERENCE_SUBCLASS.equals(nodeName)) {
                        typeName = XMLUtil.getElementText(element);
                        this.iApplicationInfo.addDeleteIntendedType(typeName);
                        this.iProjectInfo.addEntityReferenceSubclass(typeName);
                        try {
                            type = this.iJavaProject.findType(typeName);
                            this.iProjectInfo.addIndirectEntityReferencingType(type.getFullyQualifiedName('.'));
                            ApplicationInfoUtil.addJpaStubTypeMapping(this.iApplicationInfo, type);
                        }
                        catch (JavaModelException e) {
                            e.printStackTrace();
                        }
                    } else if (ACCESS_BEAN_SUBCLASS_INFO.equals(nodeName)) {
                        AccessBeanSubclassInfo accessBeanSubclassInfo = this.parseAccessBeanSubclassInfo(element);
                        EntityInfo entityInfo = accessBeanSubclassInfo.getEntityInfo();
                        String typeName2 = accessBeanSubclassInfo.getName();
                        if (entityInfo != null) {
                            this.iApplicationInfo.setEntityInfoForType(typeName2, entityInfo);
                        }
                        try {
                            IType type2 = this.iJavaProject.findType(typeName2);
                            if (type2 == null) {
                                LOGGER.info("unable to find type " + typeName2);
                            }
                            while (type2.getDeclaringType() != null) {
                                type2 = type2.getDeclaringType();
                            }
                            this.iApplicationInfo.addDeleteIntendedType(type2.getFullyQualifiedName('.'));
                            if (!AccessBeanUtil.isPortExemptAccessBeanSubclass(type2)) {
                                ApplicationInfoUtil.addJpaTypeMapping(this.iApplicationInfo, type2);
                                this.iProjectInfo.addEntityReferencingType(type2.getFullyQualifiedName('.'));
                            } else {
                                this.iApplicationInfo.addTypeMapping(typeName2, entityInfo.getEntityAccessBeanClassInfo().getQualifiedClassName());
                            }
                        }
                        catch (JavaModelException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            ++i;
        }
    }

    private AccessBeanSubclassInfo parseAccessBeanSubclassInfo(Element accessBeanSubclassInfoElement) {
        AccessBeanSubclassInfo accessBeanSubclassInfo = this.iProjectInfo.getAccessBeanSubclassInfo(accessBeanSubclassInfoElement.getAttribute(NAME), true);
        if (accessBeanSubclassInfoElement.hasAttribute(SUPERCLASS_NAME)) {
            String superclassName = accessBeanSubclassInfoElement.getAttribute(SUPERCLASS_NAME);
            try {
                IType superclassType = this.iProjectInfo.getJavaProject().findType(superclassName);
                if (superclassType == null) {
                    LOGGER.info("unable to find type " + superclassType);
                }
                ProjectInfo superclassProjectInfo = this.iApplicationInfo.getProjectInfo(superclassType.getJavaProject().getProject());
                AccessBeanSubclassInfo superclass = superclassProjectInfo.getAccessBeanSubclassInfo(superclassType.getFullyQualifiedName('.'), true);
                accessBeanSubclassInfo.setSuperclass(superclass);
                superclass.addSubclass(accessBeanSubclassInfo);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        NodeList childNodes = accessBeanSubclassInfoElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element element;
            String nodeName;
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1 && METHOD_INFO.equals(nodeName = (element = (Element)node).getNodeName())) {
                this.parseMethodInfo(accessBeanSubclassInfo, element);
            }
            ++i;
        }
        return accessBeanSubclassInfo;
    }

    private void parseMethodInfo(AccessBeanSubclassInfo accessBeanSubclassInfo, Element methodInfoElement) {
        String methodKey = null;
        TargetExceptionInfo targetExceptionInfo = new TargetExceptionInfo();
        NodeList childNodes = methodInfoElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                String exception;
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (METHOD_KEY.equals(nodeName)) {
                    methodKey = XMLUtil.getElementText(element);
                } else if (TARGET_EXCEPTION.equals(nodeName)) {
                    exception = element.getAttribute(NAME);
                    targetExceptionInfo.addTargetException(exception);
                } else if (SOURCE_EXCEPTION.equals(nodeName)) {
                    exception = element.getAttribute(NAME);
                    targetExceptionInfo.addSourceException(exception);
                }
            }
            ++i;
        }
        accessBeanSubclassInfo.setMethodUnhandledTargetExceptions(methodKey, targetExceptionInfo);
    }
}

