/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.parsers;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.ColumnInfo;
import com.ibm.commerce.jpa.port.info.ForeignKeyInfo;
import com.ibm.commerce.jpa.port.info.TableInfo;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PortConfigurationParser {
    private static final Logger LOGGER = LoggerHelper.getLogger(PortConfigurationParser.class);
    private static final String TABLE = "Table";
    private static final String TABLE_NAME = "tableName";
    private static final String COLUMN = "Column";
    private static final String TYPE = "type";
    private static final String LENGTH = "length";
    private static final String FOREIGN_KEY = "ForeignKey";
    private static final String PARENT_TABLE_NAME = "parentTableName";
    private static final String MEMBER = "Member";
    private static final String COLUMN_NAME = "columnName";
    private static final String REFERENCED_COLUMN_NAME = "referencedColumnName";
    private static final String NULLABLE = "nullable";
    private ApplicationInfo iApplicationInfo;
    private File iPortConfigurationFile;

    public PortConfigurationParser(ApplicationInfo applicationInfo, File portConfigurationFile) {
        this.iApplicationInfo = applicationInfo;
        this.iPortConfigurationFile = portConfigurationFile;
    }

    public void parse() {
        Document document = this.iApplicationInfo.getXMLUtil().readXml(this.iPortConfigurationFile);
        if (document == null || document.getDocumentElement() == null) {
            LOGGER.info("null document " + this.iPortConfigurationFile);
            this.iPortConfigurationFile.delete();
        } else {
            this.parsePortConfigurationElement(document.getDocumentElement());
            this.iApplicationInfo.incrementParsedAssetCount();
        }
    }

    private void parsePortConfigurationElement(Element portConfigurationElement) {
        NodeList childNodes = portConfigurationElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element element;
            String nodeName;
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1 && TABLE.equals(nodeName = (element = (Element)node).getNodeName())) {
                this.parseTableElement(element);
            }
            ++i;
        }
    }

    private void parseTableElement(Element tableElement) {
        String tableName = tableElement.getAttribute(TABLE_NAME);
        TableInfo tableInfo = this.iApplicationInfo.getTableInfo(tableName);
        if (tableInfo != null) {
            NodeList childNodes = tableElement.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node node = childNodes.item(i);
                if (node.getNodeType() == 1) {
                    Element element = (Element)node;
                    String nodeName = element.getNodeName();
                    if (FOREIGN_KEY.equals(nodeName)) {
                        this.parseForeignKeyElement(tableInfo, element);
                    } else if (COLUMN.equals(nodeName)) {
                        this.parseColumnElement(tableInfo, element);
                    }
                }
                ++i;
            }
        } else {
            LOGGER.info("Error parsing configuration file " + this.iPortConfigurationFile + ". Invalid table name: " + tableName);
        }
    }

    private void parseForeignKeyElement(TableInfo tableInfo, Element foreignKeyElement) {
        String parentTableName = foreignKeyElement.getAttribute(PARENT_TABLE_NAME);
        TableInfo parentTableInfo = this.iApplicationInfo.getTableInfo(parentTableName);
        if (parentTableInfo != null) {
            ForeignKeyInfo foreignKeyInfo = new ForeignKeyInfo(tableInfo);
            NodeList childNodes = foreignKeyElement.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Element element;
                String nodeName;
                Node node = childNodes.item(i);
                if (node.getNodeType() == 1 && MEMBER.equals(nodeName = (element = (Element)node).getNodeName())) {
                    String referencedColumnName;
                    ColumnInfo referencedColumn;
                    String columnName = element.getAttribute(COLUMN_NAME);
                    ColumnInfo memberColumn = tableInfo.getColumnInfoByName(columnName);
                    if (memberColumn == null) {
                        LOGGER.info("Error parsing configuration file " + this.iPortConfigurationFile + ". Invalid column name: " + columnName);
                    }
                    if ((referencedColumn = parentTableInfo.getColumnInfoByName(referencedColumnName = element.getAttribute(REFERENCED_COLUMN_NAME))) == null) {
                        LOGGER.info("Error parsing configuration file " + this.iPortConfigurationFile + ". Invalid referenced column name: " + referencedColumnName);
                    }
                    if (memberColumn != null && referencedColumn != null) {
                        boolean found = false;
                        Set<ForeignKeyInfo> foreignKeys = tableInfo.getForeignKeys();
                        for (ForeignKeyInfo current : foreignKeys) {
                            List<ColumnInfo> members = current.getMemberColumns();
                            for (ColumnInfo member : members) {
                                if (member != memberColumn) continue;
                                LOGGER.info("foreign key exists " + tableInfo.getTableName() + "." + columnName);
                                found = true;
                            }
                        }
                        if (!found) {
                            foreignKeyInfo.addMember(memberColumn, referencedColumn);
                        } else {
                            foreignKeyInfo = null;
                            break;
                        }
                    }
                }
                ++i;
            }
            if (foreignKeyInfo != null) {
                tableInfo.addForeignKey(foreignKeyInfo);
                foreignKeyInfo.setParentTableInfo(parentTableInfo);
            }
        } else {
            LOGGER.info("Error parsing configuration file " + this.iPortConfigurationFile + ". Invalid parent table name: " + parentTableName);
        }
    }

    private void parseColumnElement(TableInfo tableInfo, Element columnElement) {
        String columnName = columnElement.getAttribute(COLUMN_NAME);
        ColumnInfo columnInfo = tableInfo.getColumnInfoByName(columnName);
        if (columnInfo != null) {
            if (columnElement.hasAttribute(TYPE)) {
                columnInfo.setTypeName(columnElement.getAttribute(TYPE));
            }
            if (columnElement.hasAttribute(LENGTH)) {
                columnInfo.setLength(new Integer(columnElement.getAttribute(LENGTH)));
            }
            if (columnElement.hasAttribute(NULLABLE)) {
                columnInfo.setNullable(Boolean.parseBoolean(columnElement.getAttribute(NULLABLE)));
            }
        } else {
            LOGGER.info("Error parsing configuration file " + this.iPortConfigurationFile + ". Invalid column name: " + columnName + " in table " + tableInfo.getTableName());
        }
    }
}

